/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.configuration.ClassLoadingConfig;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.Set;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;

public class ApplicationIndexBuildStep {
    private static final Logger log = Logger.getLogger(ApplicationIndexBuildStep.class);

    @BuildStep
    ApplicationIndexBuildItem build(ArchiveRootBuildItem root, CurateOutcomeBuildItem curation, ClassLoadingConfig classLoadingConfig) throws IOException {
        final Indexer indexer = new Indexer();
        final Set<String> removedApplicationClasses = this.removedApplicationClasses(curation, classLoadingConfig);
        for (Path p : root.getRootDirectories()) {
            Files.walkFileTree(p, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().endsWith(".class")) {
                        if (this.isRemovedApplicationClass(file, removedApplicationClasses)) {
                            log.debugf("File %s will not be indexed because the class has been configured as part of '%s'", (Object)file, (Object)"quarkus.class-loading.removed-resources");
                        } else {
                            log.debugf("Indexing %s", (Object)file);
                            try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
                                indexer.index(stream);
                            }
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                private boolean isRemovedApplicationClass(Path file, Set<String> removedApplicationClasses2) {
                    if (removedApplicationClasses2.isEmpty()) {
                        return false;
                    }
                    String fileName = file.toString().replace('\\', '/');
                    String sanitizedFileName = fileName.startsWith("/") ? fileName.substring(1) : fileName;
                    for (String removedApplicationClass : removedApplicationClasses2) {
                        if (!sanitizedFileName.endsWith(removedApplicationClass)) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        Index appIndex = indexer.complete();
        return new ApplicationIndexBuildItem(appIndex);
    }

    private Set<String> removedApplicationClasses(CurateOutcomeBuildItem curation, ClassLoadingConfig classLoadingConfig) {
        ResolvedDependency appArtifact = curation.getApplicationModel().getAppArtifact();
        Set<String> entry = classLoadingConfig.removedResources.get(appArtifact.getGroupId() + ":" + appArtifact.getArtifactId());
        return entry != null ? entry : Collections.emptySet();
    }
}

