/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration.matching;

import io.quarkus.deployment.configuration.definition.ClassDefinition;
import io.quarkus.deployment.configuration.definition.RootDefinition;
import io.quarkus.deployment.configuration.matching.Container;
import org.wildfly.common.Assert;

public final class FieldContainer
extends Container {
    private final Container parent;
    private final ClassDefinition.ClassMember member;

    public FieldContainer(Container parent, ClassDefinition.ClassMember member) {
        this.parent = parent;
        this.member = (ClassDefinition.ClassMember)Assert.checkNotNullParam((String)"member", (Object)member);
    }

    @Override
    public Container getParent() {
        return this.parent;
    }

    @Override
    public ClassDefinition.ClassMember getClassMember() {
        return this.member;
    }

    @Override
    StringBuilder getCombinedName(StringBuilder sb) {
        RootDefinition rootDefinition;
        String rootName;
        ClassDefinition enclosing;
        Container parent = this.getParent();
        if (parent != null) {
            parent.getCombinedName(sb);
        }
        if ((enclosing = this.member.getEnclosingDefinition()) instanceof RootDefinition && !(rootName = (rootDefinition = (RootDefinition)enclosing).getRootName()).isEmpty()) {
            sb.append(rootName.replace('.', ':'));
        }
        if (sb.length() > 0) {
            sb.append(':');
        }
        sb.append(this.member.getField().getDeclaringClass().getSimpleName()).append('#');
        sb.append(this.member.getName());
        return sb;
    }

    @Override
    StringBuilder getPropertyName(StringBuilder sb) {
        String propertyName;
        RootDefinition rootDefinition;
        String rootName;
        ClassDefinition enclosing;
        Container parent = this.getParent();
        if (parent != null) {
            parent.getPropertyName(sb);
        }
        if ((enclosing = this.member.getEnclosingDefinition()) instanceof RootDefinition && !(rootName = (rootDefinition = (RootDefinition)enclosing).getRootName()).isEmpty()) {
            sb.append(rootName);
        }
        if (!(propertyName = this.member.getPropertyName()).isEmpty()) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(propertyName);
        }
        return sb;
    }
}

