/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.quarkus.registry.catalog.model.Platform;
import io.quarkus.registry.model.Release;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class ImmutablePlatform
implements Platform {
    private final String groupId;
    private final String groupIdJson;
    private final String artifactId;
    private final String artifactIdJson;
    private final List<Release> releases;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePlatform(Builder builder) {
        this.groupId = builder.groupId;
        this.artifactId = builder.artifactId;
        this.releases = ImmutablePlatform.createUnmodifiableList(true, builder.releases);
        if (builder.groupIdJson != null) {
            this.initShim.groupIdJson(builder.groupIdJson);
        }
        if (builder.artifactIdJson != null) {
            this.initShim.artifactIdJson(builder.artifactIdJson);
        }
        this.groupIdJson = this.initShim.getGroupIdJson();
        this.artifactIdJson = this.initShim.getArtifactIdJson();
        this.initShim = null;
    }

    private ImmutablePlatform(String groupId, String groupIdJson, String artifactId, String artifactIdJson, List<Release> releases) {
        this.groupId = groupId;
        this.groupIdJson = groupIdJson;
        this.artifactId = artifactId;
        this.artifactIdJson = artifactIdJson;
        this.releases = releases;
        this.initShim = null;
    }

    private String getGroupIdJsonInitialize() {
        return Platform.super.getGroupIdJson();
    }

    private String getArtifactIdJsonInitialize() {
        return Platform.super.getArtifactIdJson();
    }

    @Override
    @JsonProperty(value="group-id")
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    @JsonProperty(value="group-id-json")
    public String getGroupIdJson() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getGroupIdJson() : this.groupIdJson;
    }

    @Override
    @JsonProperty(value="artifact-id")
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    @JsonProperty(value="artifact-id-json")
    public String getArtifactIdJson() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getArtifactIdJson() : this.artifactIdJson;
    }

    @Override
    @JsonProperty(value="releases")
    public List<Release> getReleases() {
        return this.releases;
    }

    public final ImmutablePlatform withGroupId(String value) {
        String newValue = Objects.requireNonNull(value, "groupId");
        if (this.groupId.equals(newValue)) {
            return this;
        }
        return new ImmutablePlatform(newValue, this.groupIdJson, this.artifactId, this.artifactIdJson, this.releases);
    }

    public final ImmutablePlatform withGroupIdJson(String value) {
        String newValue = Objects.requireNonNull(value, "groupIdJson");
        if (this.groupIdJson.equals(newValue)) {
            return this;
        }
        return new ImmutablePlatform(this.groupId, newValue, this.artifactId, this.artifactIdJson, this.releases);
    }

    public final ImmutablePlatform withArtifactId(String value) {
        String newValue = Objects.requireNonNull(value, "artifactId");
        if (this.artifactId.equals(newValue)) {
            return this;
        }
        return new ImmutablePlatform(this.groupId, this.groupIdJson, newValue, this.artifactIdJson, this.releases);
    }

    public final ImmutablePlatform withArtifactIdJson(String value) {
        String newValue = Objects.requireNonNull(value, "artifactIdJson");
        if (this.artifactIdJson.equals(newValue)) {
            return this;
        }
        return new ImmutablePlatform(this.groupId, this.groupIdJson, this.artifactId, newValue, this.releases);
    }

    public final ImmutablePlatform withReleases(Release ... elements) {
        List<Release> newValue = ImmutablePlatform.createUnmodifiableList(false, ImmutablePlatform.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePlatform(this.groupId, this.groupIdJson, this.artifactId, this.artifactIdJson, newValue);
    }

    public final ImmutablePlatform withReleases(Iterable<? extends Release> elements) {
        if (this.releases == elements) {
            return this;
        }
        List<Release> newValue = ImmutablePlatform.createUnmodifiableList(false, ImmutablePlatform.createSafeList(elements, true, false));
        return new ImmutablePlatform(this.groupId, this.groupIdJson, this.artifactId, this.artifactIdJson, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePlatform && this.equalTo((ImmutablePlatform)another);
    }

    private boolean equalTo(ImmutablePlatform another) {
        return this.groupId.equals(another.groupId) && this.artifactId.equals(another.artifactId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.groupId.hashCode();
        h += (h << 5) + this.artifactId.hashCode();
        return h;
    }

    public String toString() {
        return "Platform{groupId=" + this.groupId + ", artifactId=" + this.artifactId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePlatform fromJson(Json json) {
        Builder builder = ImmutablePlatform.builder();
        if (json.groupId != null) {
            builder.groupId(json.groupId);
        }
        if (json.groupIdJson != null) {
            builder.groupIdJson(json.groupIdJson);
        }
        if (json.artifactId != null) {
            builder.artifactId(json.artifactId);
        }
        if (json.artifactIdJson != null) {
            builder.artifactIdJson(json.artifactIdJson);
        }
        if (json.releases != null) {
            builder.addAllReleases(json.releases);
        }
        return builder.build();
    }

    public static ImmutablePlatform copyOf(Platform instance) {
        if (instance instanceof ImmutablePlatform) {
            return (ImmutablePlatform)instance;
        }
        return ImmutablePlatform.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_GROUP_ID = 1L;
        private static final long INIT_BIT_ARTIFACT_ID = 2L;
        private long initBits = 3L;
        private String groupId;
        private String groupIdJson;
        private String artifactId;
        private String artifactIdJson;
        private List<Release> releases = new ArrayList<Release>();

        private Builder() {
        }

        public final Builder from(Platform instance) {
            Objects.requireNonNull(instance, "instance");
            this.groupId(instance.getGroupId());
            this.groupIdJson(instance.getGroupIdJson());
            this.artifactId(instance.getArtifactId());
            this.artifactIdJson(instance.getArtifactIdJson());
            this.addAllReleases(instance.getReleases());
            return this;
        }

        @JsonProperty(value="group-id")
        public final Builder groupId(String groupId) {
            this.groupId = Objects.requireNonNull(groupId, "groupId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="group-id-json")
        public final Builder groupIdJson(String groupIdJson) {
            this.groupIdJson = Objects.requireNonNull(groupIdJson, "groupIdJson");
            return this;
        }

        @JsonProperty(value="artifact-id")
        public final Builder artifactId(String artifactId) {
            this.artifactId = Objects.requireNonNull(artifactId, "artifactId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="artifact-id-json")
        public final Builder artifactIdJson(String artifactIdJson) {
            this.artifactIdJson = Objects.requireNonNull(artifactIdJson, "artifactIdJson");
            return this;
        }

        public final Builder addReleases(Release element) {
            this.releases.add(Objects.requireNonNull(element, "releases element"));
            return this;
        }

        public final Builder addReleases(Release ... elements) {
            for (Release element : elements) {
                this.releases.add(Objects.requireNonNull(element, "releases element"));
            }
            return this;
        }

        @JsonProperty(value="releases")
        public final Builder releases(Iterable<? extends Release> elements) {
            this.releases.clear();
            return this.addAllReleases(elements);
        }

        public final Builder addAllReleases(Iterable<? extends Release> elements) {
            for (Release release : elements) {
                this.releases.add(Objects.requireNonNull(release, "releases element"));
            }
            return this;
        }

        public ImmutablePlatform build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePlatform(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("groupId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("artifactId");
            }
            return "Cannot build Platform, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements Platform {
        String groupId;
        String groupIdJson;
        String artifactId;
        String artifactIdJson;
        List<Release> releases = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="group-id")
        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @JsonProperty(value="group-id-json")
        public void setGroupIdJson(String groupIdJson) {
            this.groupIdJson = groupIdJson;
        }

        @JsonProperty(value="artifact-id")
        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        @JsonProperty(value="artifact-id-json")
        public void setArtifactIdJson(String artifactIdJson) {
            this.artifactIdJson = artifactIdJson;
        }

        @JsonProperty(value="releases")
        public void setReleases(List<Release> releases) {
            this.releases = releases;
        }

        @Override
        public String getGroupId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getGroupIdJson() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getArtifactId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getArtifactIdJson() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Release> getReleases() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private byte groupIdJsonBuildStage = 0;
        private String groupIdJson;
        private byte artifactIdJsonBuildStage = 0;
        private String artifactIdJson;

        private InitShim() {
        }

        String getGroupIdJson() {
            if (this.groupIdJsonBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.groupIdJsonBuildStage == 0) {
                this.groupIdJsonBuildStage = (byte)-1;
                this.groupIdJson = Objects.requireNonNull(ImmutablePlatform.this.getGroupIdJsonInitialize(), "groupIdJson");
                this.groupIdJsonBuildStage = 1;
            }
            return this.groupIdJson;
        }

        void groupIdJson(String groupIdJson) {
            this.groupIdJson = groupIdJson;
            this.groupIdJsonBuildStage = 1;
        }

        String getArtifactIdJson() {
            if (this.artifactIdJsonBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.artifactIdJsonBuildStage == 0) {
                this.artifactIdJsonBuildStage = (byte)-1;
                this.artifactIdJson = Objects.requireNonNull(ImmutablePlatform.this.getArtifactIdJsonInitialize(), "artifactIdJson");
                this.artifactIdJsonBuildStage = 1;
            }
            return this.artifactIdJson;
        }

        void artifactIdJson(String artifactIdJson) {
            this.artifactIdJson = artifactIdJson;
            this.artifactIdJsonBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.groupIdJsonBuildStage == -1) {
                attributes.add("groupIdJson");
            }
            if (this.artifactIdJsonBuildStage == -1) {
                attributes.add("artifactIdJson");
            }
            return "Cannot build Platform, attribute initializers form cycle " + attributes;
        }
    }
}

