/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import io.quarkus.registry.model.ArtifactKey;
import io.quarkus.registry.model.ImmutablePlatform;
import io.quarkus.registry.model.Platform;
import io.quarkus.registry.model.Release;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class ModifiablePlatform
implements Platform {
    private static final long INIT_BIT_ID = 1L;
    private long initBits = 1L;
    private ArtifactKey id;
    private final LinkedHashSet<Release> releases = new LinkedHashSet();

    private ModifiablePlatform() {
    }

    public static ModifiablePlatform create() {
        return new ModifiablePlatform();
    }

    @Override
    @JsonProperty(value="id")
    @JsonUnwrapped
    public final ArtifactKey getId() {
        if (!this.idIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.id;
    }

    @Override
    @JsonProperty(value="releases")
    public final Set<Release> getReleases() {
        return this.releases;
    }

    public ModifiablePlatform clear() {
        this.initBits = 1L;
        this.id = null;
        this.releases.clear();
        return this;
    }

    public ModifiablePlatform from(Platform instance) {
        Objects.requireNonNull(instance, "instance");
        if (instance instanceof ModifiablePlatform) {
            this.from((ModifiablePlatform)instance);
            return this;
        }
        this.setId(instance.getId());
        this.addAllReleases(instance.getReleases());
        return this;
    }

    public ModifiablePlatform from(ModifiablePlatform instance) {
        Objects.requireNonNull(instance, "instance");
        if (instance.idIsSet()) {
            this.setId(instance.getId());
        }
        this.addAllReleases(instance.getReleases());
        return this;
    }

    public ModifiablePlatform setId(ArtifactKey id) {
        this.id = Objects.requireNonNull(id, "id");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public ModifiablePlatform addReleases(Release element) {
        Objects.requireNonNull(element, "releases element");
        this.releases.add(element);
        return this;
    }

    public final ModifiablePlatform addReleases(Release ... elements) {
        for (Release e : elements) {
            this.addReleases(e);
        }
        return this;
    }

    public ModifiablePlatform setReleases(Iterable<? extends Release> elements) {
        this.releases.clear();
        this.addAllReleases(elements);
        return this;
    }

    public ModifiablePlatform addAllReleases(Iterable<? extends Release> elements) {
        for (Release release : elements) {
            this.addReleases(release);
        }
        return this;
    }

    public final boolean idIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    public final ModifiablePlatform unsetId() {
        this.initBits |= 1L;
        this.id = null;
        return this;
    }

    public final boolean isInitialized() {
        return this.initBits == 0L;
    }

    private void checkRequiredAttributes() {
        if (!this.isInitialized()) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.idIsSet()) {
            attributes.add("id");
        }
        return "Platform is not initialized, some of the required attributes are not set " + attributes;
    }

    public final ImmutablePlatform toImmutable() {
        this.checkRequiredAttributes();
        return ImmutablePlatform.copyOf(this);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ModifiablePlatform)) {
            return false;
        }
        ModifiablePlatform other = (ModifiablePlatform)another;
        if (!this.isInitialized() || !other.isInitialized()) {
            return false;
        }
        return this.equalTo(other);
    }

    private boolean equalTo(ModifiablePlatform another) {
        return this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        return h;
    }

    public String toString() {
        return "ModifiablePlatform{id=" + (this.idIsSet() ? this.getId() : "?") + "}";
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }
}

