/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.component;

import io.quarkus.arc.InjectableInstance;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.runtime.configuration.CharsetConverter;
import io.quarkus.runtime.configuration.CidrAddressConverter;
import io.quarkus.runtime.configuration.DurationConverter;
import io.quarkus.runtime.configuration.InetAddressConverter;
import io.quarkus.runtime.configuration.InetSocketAddressConverter;
import io.quarkus.runtime.configuration.LocaleConverter;
import io.quarkus.runtime.configuration.MemorySizeConverter;
import io.quarkus.runtime.configuration.PathConverter;
import io.quarkus.runtime.configuration.RegexConverter;
import io.quarkus.runtime.configuration.ZoneIdConverter;
import io.quarkus.runtime.logging.LevelConverter;
import io.quarkus.test.InjectMock;
import io.quarkus.test.component.MockBeanConfiguratorImpl;
import io.quarkus.test.component.QuarkusComponentTest;
import io.quarkus.test.component.QuarkusComponentTestExtension;
import io.quarkus.test.component.SkipInject;
import io.quarkus.test.component.TestConfigProperty;
import io.smallrye.config.SmallRyeConfigBuilder;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.BeanContainer;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.spi.Converter;
import org.jboss.logging.Logger;
import org.mockito.Mock;

class QuarkusComponentTestConfiguration {
    static final List<Converter<?>> DEFAULT_CONVERTERS = List.of(new InetSocketAddressConverter(), new CharsetConverter(), new CidrAddressConverter(), new InetAddressConverter(), new RegexConverter(), new PathConverter(), new DurationConverter(), new MemorySizeConverter(), new LocaleConverter(), new ZoneIdConverter(), new LevelConverter());
    static final QuarkusComponentTestConfiguration DEFAULT = new QuarkusComponentTestConfiguration(Map.of(), Set.of(), List.of(), false, true, 500, List.of(), DEFAULT_CONVERTERS, null);
    private static final Logger LOG = Logger.getLogger(QuarkusComponentTestConfiguration.class);
    final Map<String, String> configProperties;
    final Set<Class<?>> componentClasses;
    final List<MockBeanConfiguratorImpl<?>> mockConfigurators;
    final boolean useDefaultConfigProperties;
    final boolean addNestedClassesAsComponents;
    final int configSourceOrdinal;
    final List<AnnotationsTransformer> annotationsTransformers;
    final List<Converter<?>> configConverters;
    final Consumer<SmallRyeConfigBuilder> configBuilderCustomizer;

    QuarkusComponentTestConfiguration(Map<String, String> configProperties, Set<Class<?>> componentClasses, List<MockBeanConfiguratorImpl<?>> mockConfigurators, boolean useDefaultConfigProperties, boolean addNestedClassesAsComponents, int configSourceOrdinal, List<AnnotationsTransformer> annotationsTransformers, List<Converter<?>> configConverters, Consumer<SmallRyeConfigBuilder> configBuilderCustomizer) {
        this.configProperties = configProperties;
        this.componentClasses = componentClasses;
        this.mockConfigurators = mockConfigurators;
        this.useDefaultConfigProperties = useDefaultConfigProperties;
        this.addNestedClassesAsComponents = addNestedClassesAsComponents;
        this.configSourceOrdinal = configSourceOrdinal;
        this.annotationsTransformers = annotationsTransformers;
        this.configConverters = configConverters;
        this.configBuilderCustomizer = configBuilderCustomizer;
    }

    /*
     * WARNING - void declaration
     */
    QuarkusComponentTestConfiguration update(Class<?> testClass) {
        HashMap<String, String> configProperties = new HashMap<String, String>(this.configProperties);
        ArrayList componentClasses = new ArrayList(this.componentClasses);
        boolean useDefaultConfigProperties = this.useDefaultConfigProperties;
        boolean addNestedClassesAsComponents = this.addNestedClassesAsComponents;
        int configSourceOrdinal = this.configSourceOrdinal;
        ArrayList<AnnotationsTransformer> annotationsTransformers = new ArrayList<AnnotationsTransformer>(this.annotationsTransformers);
        ArrayList configConverters = new ArrayList(this.configConverters);
        QuarkusComponentTest testAnnotation = testClass.getAnnotation(QuarkusComponentTest.class);
        if (testAnnotation != null) {
            AnnotatedElement[] converters;
            Collections.addAll(componentClasses, testAnnotation.value());
            useDefaultConfigProperties = testAnnotation.useDefaultConfigProperties();
            addNestedClassesAsComponents = testAnnotation.addNestedClassesAsComponents();
            configSourceOrdinal = testAnnotation.configSourceOrdinal();
            Class<? extends AnnotationsTransformer>[] transformers = testAnnotation.annotationsTransformers();
            if (transformers.length > 0) {
                for (Class<? extends AnnotationsTransformer> clazz : transformers) {
                    try {
                        annotationsTransformers.add(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    }
                    catch (Exception e) {
                        LOG.errorf((Throwable)e, "Unable to instantiate %s", clazz);
                    }
                }
            }
            if ((converters = testAnnotation.configConverters()).length > 0) {
                void var14_19;
                AnnotatedElement[] annotatedElementArray = converters;
                int n = annotatedElementArray.length;
                boolean bl = false;
                while (var14_19 < n) {
                    AnnotatedElement converterClass = annotatedElementArray[var14_19];
                    try {
                        configConverters.add((Converter)((Class)converterClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    }
                    catch (Exception e) {
                        LOG.errorf((Throwable)e, "Unable to instantiate %s", (Object)converterClass);
                    }
                    ++var14_19;
                }
            }
        }
        for (Class<?> current = testClass; current != null && current != Object.class; current = current.getSuperclass()) {
            for (Field field : current.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Inject.class)) continue;
                if (Instance.class.isAssignableFrom(field.getType()) || QuarkusComponentTestExtension.isListAllInjectionPoint(field.getGenericType(), field.getAnnotations(), field)) {
                    componentClasses.add(QuarkusComponentTestConfiguration.getRawType(QuarkusComponentTestExtension.getFirstActualTypeArgument(field.getGenericType())));
                    continue;
                }
                if (QuarkusComponentTestConfiguration.resolvesToBuiltinBean(field.getType())) continue;
                componentClasses.add(field.getType());
            }
            if (addNestedClassesAsComponents) {
                for (AnnotatedElement annotatedElement : current.getDeclaredClasses()) {
                    if (!Modifier.isStatic(((Class)annotatedElement).getModifiers())) continue;
                    componentClasses.add((Class<?>)annotatedElement);
                }
            }
            for (AnnotatedElement annotatedElement : current.getDeclaredMethods()) {
                if (!QuarkusComponentTestExtension.isTestMethod((Executable)annotatedElement)) continue;
                for (Parameter param : ((Executable)annotatedElement).getParameters()) {
                    if (QuarkusComponentTestExtension.BUILTIN_PARAMETER.test(param) || param.isAnnotationPresent(InjectMock.class) || param.isAnnotationPresent(SkipInject.class) || param.isAnnotationPresent(Mock.class)) continue;
                    if (Instance.class.isAssignableFrom(param.getType()) || QuarkusComponentTestExtension.isListAllInjectionPoint(param.getParameterizedType(), param.getAnnotations(), param)) {
                        componentClasses.add(QuarkusComponentTestConfiguration.getRawType(QuarkusComponentTestExtension.getFirstActualTypeArgument(param.getParameterizedType())));
                        continue;
                    }
                    componentClasses.add(param.getType());
                }
            }
        }
        ArrayList testConfigProperties = new ArrayList();
        Collections.addAll(testConfigProperties, (TestConfigProperty[])testClass.getAnnotationsByType(TestConfigProperty.class));
        for (TestConfigProperty testConfigProperty : testConfigProperties) {
            configProperties.put(testConfigProperty.key(), testConfigProperty.value());
        }
        return new QuarkusComponentTestConfiguration(Map.copyOf(configProperties), Set.copyOf(componentClasses), this.mockConfigurators, useDefaultConfigProperties, addNestedClassesAsComponents, configSourceOrdinal, List.copyOf(annotationsTransformers), List.copyOf(configConverters), this.configBuilderCustomizer);
    }

    QuarkusComponentTestConfiguration update(Method testMethod) {
        HashMap<String, String> configProperties = new HashMap<String, String>(this.configProperties);
        ArrayList testConfigProperties = new ArrayList();
        Collections.addAll(testConfigProperties, (TestConfigProperty[])testMethod.getAnnotationsByType(TestConfigProperty.class));
        for (TestConfigProperty testConfigProperty : testConfigProperties) {
            configProperties.put(testConfigProperty.key(), testConfigProperty.value());
        }
        return new QuarkusComponentTestConfiguration(configProperties, this.componentClasses, this.mockConfigurators, this.useDefaultConfigProperties, this.addNestedClassesAsComponents, this.configSourceOrdinal, this.annotationsTransformers, this.configConverters, this.configBuilderCustomizer);
    }

    private static boolean resolvesToBuiltinBean(Class<?> rawType) {
        return Provider.class.equals(rawType) || Instance.class.equals(rawType) || InjectableInstance.class.equals(rawType) || Event.class.equals(rawType) || BeanContainer.class.equals(rawType) || BeanManager.class.equals(rawType);
    }

    static <T> Class<T> getRawType(Type type) {
        GenericArrayType genericArrayType;
        Class<T> rawType;
        ParameterizedType parameterizedType;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType() instanceof Class) {
            return (Class)parameterizedType.getRawType();
        }
        if (type instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)type;
            Type[] bounds = variable.getBounds();
            return QuarkusComponentTestConfiguration.getBound(bounds);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)type;
            return QuarkusComponentTestConfiguration.getBound(wildcard.getUpperBounds());
        }
        if (type instanceof GenericArrayType && (rawType = QuarkusComponentTestConfiguration.getRawType((genericArrayType = (GenericArrayType)type).getGenericComponentType())) != null) {
            return Array.newInstance(rawType, 0).getClass();
        }
        return null;
    }

    private static <T> Class<T> getBound(Type[] bounds) {
        if (bounds.length == 0) {
            return Object.class;
        }
        return QuarkusComponentTestConfiguration.getRawType(bounds[0]);
    }
}

