/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.deployment;

import io.quarkus.agroal.runtime.DataSources;
import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.agroal.spi.JdbcDataSourceSchemaReadyBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.InitTaskBuildItem;
import io.quarkus.deployment.builditem.InitTaskCompletedBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.liquibase.LiquibaseDataSource;
import io.quarkus.liquibase.LiquibaseFactory;
import io.quarkus.liquibase.runtime.LiquibaseBuildTimeConfig;
import io.quarkus.liquibase.runtime.LiquibaseDataSourceBuildTimeConfig;
import io.quarkus.liquibase.runtime.LiquibaseFactoryProducer;
import io.quarkus.liquibase.runtime.LiquibaseRecorder;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.paths.PathFilter;
import io.quarkus.runtime.util.StringUtil;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import liquibase.AbstractExtensibleObject;
import liquibase.GlobalConfiguration;
import liquibase.change.AddColumnConfig;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.CreateProcedureChange;
import liquibase.change.core.CreateViewChange;
import liquibase.change.core.DeleteDataChange;
import liquibase.change.core.EmptyChange;
import liquibase.change.core.LoadDataChange;
import liquibase.change.core.LoadDataColumnConfig;
import liquibase.change.core.SQLFileChange;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.FastCheckService;
import liquibase.changelog.RanChangeSet;
import liquibase.command.CommandFactory;
import liquibase.configuration.ConfiguredValueModifierFactory;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.LiquibaseTableNamesFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.datatype.DataTypeInfo;
import liquibase.datatype.core.UnknownType;
import liquibase.diff.compare.CompareControl;
import liquibase.exception.LiquibaseException;
import liquibase.executor.ExecutorService;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ChangeLogParserConfiguration;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.plugin.AbstractPlugin;
import liquibase.plugin.AbstractPluginFactory;
import liquibase.precondition.Precondition;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.DirectoryResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.sql.visitor.AppendSqlVisitor;
import liquibase.sql.visitor.PrependSqlVisitor;
import liquibase.sql.visitor.RegExpReplaceSqlVisitor;
import liquibase.sql.visitor.ReplaceSqlVisitor;
import liquibase.sqlgenerator.core.LockDatabaseChangeLogGenerator;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

class LiquibaseProcessor {
    private static final Logger LOGGER = Logger.getLogger(LiquibaseProcessor.class);
    private static final String LIQUIBASE_BEAN_NAME_PREFIX = "liquibase_";
    private static final ArtifactCoords LIQUIBASE_ARTIFACT = Dependency.of((String)"org.liquibase", (String)"liquibase-core", (String)"*");
    private static final PathFilter LIQUIBASE_RESOURCE_FILTER = PathFilter.forIncludes(List.of("*.properties", "www.liquibase.org/xml/ns/dbchangelog/*.xsd"));
    private static final DotName DATABASE_CHANGE_PROPERTY = DotName.createSimple((String)DatabaseChangeProperty.class.getName());
    private static final DotName DATA_TYPE_INFO_ANNOTATION = DotName.createSimple((String)DataTypeInfo.class.getName());

    LiquibaseProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.LIQUIBASE);
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    IndexDependencyBuildItem indexLiquibase() {
        return new IndexDependencyBuildItem(LIQUIBASE_ARTIFACT.getGroupId(), LIQUIBASE_ARTIFACT.getArtifactId());
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    void nativeImageConfiguration(LiquibaseBuildTimeConfig liquibaseBuildConfig, List<JdbcDataSourceBuildItem> jdbcDataSourceBuildItems, CombinedIndexBuildItem combinedIndex, CurateOutcomeBuildItem curateOutcome, BuildProducer<ReflectiveClassBuildItem> reflective, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ServiceProviderBuildItem> services, BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitialized, BuildProducer<NativeImageResourceBundleBuildItem> resourceBundle) {
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem(CompareControl.class.getName()));
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem(LockDatabaseChangeLogGenerator.class.getName()));
        reflective.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{UnknownType.class.getName()}).reason(this.getClass().getName()).constructors().methods().build());
        reflective.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{AbstractExtensibleObject.class.getName(), DeleteDataChange.class.getName(), EmptyChange.class.getName(), JdbcConnection.class.getName(), AbstractPlugin.class.getName()}).reason(this.getClass().getName()).methods().build());
        reflective.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])((String[])combinedIndex.getIndex().getAllKnownSubclasses(AbstractPluginFactory.class).stream().map(classInfo -> classInfo.name().toString()).toArray(String[]::new))).reason(this.getClass().getName()).constructors().build());
        reflective.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{CommandFactory.class.getName(), LiquibaseTableNamesFactory.class.getName(), ConfiguredValueModifierFactory.class.getName(), FastCheckService.class.getName()}).reason(this.getClass().getName()).constructors().build());
        reflective.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{RanChangeSet.class.getName(), LiquibaseConfiguration.class.getName(), ChangeLogParserConfiguration.class.getName(), GlobalConfiguration.class.getName(), ExecutorService.class.getName(), ColumnConfig.class.getName(), AddColumnConfig.class.getName(), LoadDataColumnConfig.class.getName(), PrependSqlVisitor.class.getName(), ReplaceSqlVisitor.class.getName(), AppendSqlVisitor.class.getName(), RegExpReplaceSqlVisitor.class.getName()}).reason(this.getClass().getName()).constructors().methods().fields().build());
        reflective.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{ConstraintsConfig.class.getName()}).reason(this.getClass().getName()).fields().build());
        reflective.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ConcurrentHashMap.class, ArrayList.class}).reason(this.getClass().getName()).build());
        HashSet<String> classesMarkedWithDatabaseChangeProperty = new HashSet<String>();
        for (AnnotationInstance databaseChangePropertyInstance : combinedIndex.getIndex().getAnnotations(DATABASE_CHANGE_PROPERTY)) {
            AnnotationTarget annotationTarget = databaseChangePropertyInstance.target();
            if (annotationTarget.kind() != AnnotationTarget.Kind.METHOD) continue;
            classesMarkedWithDatabaseChangeProperty.add(annotationTarget.asMethod().declaringClass().name().toString());
        }
        reflective.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])classesMarkedWithDatabaseChangeProperty.toArray(new String[0])).reason(this.getClass().getName()).constructors().methods().fields().build());
        Set classesAnnotatedWithDataTypeInfo = combinedIndex.getIndex().getAnnotations(DATA_TYPE_INFO_ANNOTATION).stream().map(AnnotationInstance::target).filter(at -> at.kind() == AnnotationTarget.Kind.CLASS).map(at -> at.asClass().name().toString()).collect(Collectors.toSet());
        reflective.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])((String[])classesAnnotatedWithDataTypeInfo.toArray(String[]::new))).reason(this.getClass().getName()).constructors().methods().build());
        Collection dataSourceNames = jdbcDataSourceBuildItems.stream().map(JdbcDataSourceBuildItem::getName).collect(Collectors.toSet());
        resource.produce((BuildItem)new NativeImageResourceBuildItem(this.getChangeLogs(dataSourceNames, liquibaseBuildConfig).toArray(new String[0])));
        this.consumeService(Precondition.class.getName(), (serviceClassName, implementations) -> {
            services.produce((BuildItem)new ServiceProviderBuildItem(serviceClassName, implementations.toArray(new String[0])));
            reflective.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])implementations.toArray(new String[0])).reason(this.getClass().getName()).constructors().methods().fields().build());
        });
        Collection dependencies = curateOutcome.getApplicationModel().getRuntimeDependencies();
        resource.produce((BuildItem)NativeImageResourceBuildItem.ofDependencyResources((Collection)dependencies, (ArtifactCoords)LIQUIBASE_ARTIFACT, (PathFilter)LIQUIBASE_RESOURCE_FILTER));
        services.produce(ServiceProviderBuildItem.allProvidersOfDependency((Collection)dependencies, (ArtifactCoords)LIQUIBASE_ARTIFACT));
        resourceBundle.produce((BuildItem)new NativeImageResourceBundleBuildItem("liquibase/i18n/liquibase-core"));
    }

    private void consumeService(String serviceClassName, BiConsumer<String, Collection<String>> consumer) {
        try {
            String service = "META-INF/services/" + serviceClassName;
            Set implementations = ServiceUtil.classNamesNamedIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)service);
            consumer.accept(serviceClassName, implementations);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createBeans(LiquibaseRecorder recorder, List<JdbcDataSourceBuildItem> jdbcDataSourceBuildItems, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{LiquibaseFactoryProducer.class}).setUnremovable().setDefaultScope(DotNames.SINGLETON).build());
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(LiquibaseDataSource.class).build());
        Set<String> dataSourceNames = this.getDataSourceNames(jdbcDataSourceBuildItems);
        for (String dataSourceName : dataSourceNames) {
            SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(LiquibaseFactory.class).scope(ApplicationScoped.class)).setRuntimeInit().unremovable()).addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(LiquibaseFactoryProducer.class)), new AnnotationInstance[0])).addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(DataSources.class)), new AnnotationInstance[0])).createWith(recorder.liquibaseFunction(dataSourceName));
            if (DataSourceUtil.isDefault((String)dataSourceName)) {
                configurator.addQualifier(Default.class);
            } else {
                String beanName = LIQUIBASE_BEAN_NAME_PREFIX + dataSourceName;
                configurator.name(beanName);
                configurator.addQualifier().annotation(DotNames.NAMED).addValue("value", (Object)beanName).done();
                configurator.addQualifier().annotation(LiquibaseDataSource.class).addValue("value", (Object)dataSourceName).done();
            }
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)configurator.done());
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Consume(value=BeanContainerBuildItem.class)
    ServiceStartBuildItem startLiquibase(LiquibaseRecorder recorder, List<JdbcDataSourceBuildItem> jdbcDataSourceBuildItems, BuildProducer<InitTaskCompletedBuildItem> initializationCompleteBuildItem, BuildProducer<JdbcDataSourceSchemaReadyBuildItem> schemaReadyBuildItem) {
        Set<String> dataSourceNames = this.getDataSourceNames(jdbcDataSourceBuildItems);
        for (String dataSourceName : dataSourceNames) {
            recorder.doStartActions(dataSourceName);
        }
        schemaReadyBuildItem.produce((BuildItem)new JdbcDataSourceSchemaReadyBuildItem(dataSourceNames));
        initializationCompleteBuildItem.produce((BuildItem)new InitTaskCompletedBuildItem("liquibase"));
        return new ServiceStartBuildItem("liquibase");
    }

    @BuildStep
    public InitTaskBuildItem configureInitTask(ApplicationInfoBuildItem app) {
        return InitTaskBuildItem.create().withName(app.getName() + "-liquibase-init").withTaskEnvVars(Map.of("QUARKUS_INIT_AND_EXIT", "true", "QUARKUS_LIQUIBASE_ENABLED", "true")).withAppEnvVars(Map.of("QUARKUS_LIQUIBASE_ENABLED", "false")).withSharedEnvironment(true).withSharedFilesystem(true);
    }

    private Set<String> getDataSourceNames(List<JdbcDataSourceBuildItem> jdbcDataSourceBuildItems) {
        HashSet<String> result = new HashSet<String>(jdbcDataSourceBuildItems.size());
        for (JdbcDataSourceBuildItem item : jdbcDataSourceBuildItems) {
            result.add(item.getName());
        }
        return result;
    }

    private List<String> getChangeLogs(Collection<String> dataSourceNames, LiquibaseBuildTimeConfig liquibaseBuildConfig) {
        if (dataSourceNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LiquibaseDataSourceBuildTimeConfig> liquibaseDataSources = new ArrayList<LiquibaseDataSourceBuildTimeConfig>();
        if (DataSourceUtil.hasDefault(dataSourceNames)) {
            liquibaseDataSources.add(liquibaseBuildConfig.defaultDataSource);
        }
        for (String dataSourceName : dataSourceNames) {
            if (DataSourceUtil.isDefault((String)dataSourceName)) continue;
            liquibaseDataSources.add(liquibaseBuildConfig.getConfigForDataSourceName(dataSourceName));
        }
        ChangeLogParameters changeLogParameters = new ChangeLogParameters();
        ChangeLogParserFactory changeLogParserFactory = ChangeLogParserFactory.getInstance();
        LinkedHashSet<String> resources = new LinkedHashSet<String>();
        for (LiquibaseDataSourceBuildTimeConfig liquibaseDataSourceConfig : liquibaseDataSources) {
            Optional oSearchPaths = liquibaseDataSourceConfig.searchPath;
            String changeLog = liquibaseDataSourceConfig.changeLog;
            String parsedChangeLog = this.parseChangeLog(oSearchPaths, changeLog);
            try {
                ResourceAccessor resourceAccessor = this.resolveResourceAccessor(oSearchPaths, changeLog);
                try {
                    resources.addAll(this.findAllChangeLogFiles(parsedChangeLog, changeLogParserFactory, resourceAccessor, changeLogParameters));
                }
                finally {
                    if (resourceAccessor == null) continue;
                    resourceAccessor.close();
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        LOGGER.debugf("Liquibase changeLogs: %s", resources);
        return new ArrayList<String>(resources);
    }

    private ResourceAccessor resolveResourceAccessor(Optional<List<String>> oSearchPaths, String changeLog) throws FileNotFoundException {
        CompositeResourceAccessor compositeResourceAccessor = new CompositeResourceAccessor(new ResourceAccessor[0]);
        compositeResourceAccessor.addResourceAccessor((ResourceAccessor)new ClassLoaderResourceAccessor(Thread.currentThread().getContextClassLoader()));
        if (!changeLog.startsWith("filesystem:") && oSearchPaths.isEmpty()) {
            return compositeResourceAccessor;
        }
        if (oSearchPaths.isEmpty()) {
            compositeResourceAccessor.addResourceAccessor((ResourceAccessor)new DirectoryResourceAccessor(Paths.get(StringUtil.changePrefix((String)changeLog, (String)"filesystem:", (String)""), new String[0]).getParent()));
            return compositeResourceAccessor;
        }
        for (String searchPath : oSearchPaths.get()) {
            compositeResourceAccessor.addResourceAccessor((ResourceAccessor)new DirectoryResourceAccessor(Paths.get(searchPath, new String[0])));
        }
        return compositeResourceAccessor;
    }

    private String parseChangeLog(Optional<List<String>> oSearchPaths, String changeLog) {
        if (changeLog.startsWith("filesystem:") && oSearchPaths.isEmpty()) {
            return Paths.get(StringUtil.changePrefix((String)changeLog, (String)"filesystem:", (String)""), new String[0]).getFileName().toString();
        }
        if (changeLog.startsWith("filesystem:")) {
            return StringUtil.changePrefix((String)changeLog, (String)"filesystem:", (String)"");
        }
        if (changeLog.startsWith("classpath:")) {
            return StringUtil.changePrefix((String)changeLog, (String)"classpath:", (String)"");
        }
        return changeLog;
    }

    private Set<String> findAllChangeLogFiles(String file, ChangeLogParserFactory changeLogParserFactory, ResourceAccessor resourceAccessor, ChangeLogParameters changeLogParameters) {
        try {
            ChangeLogParser parser = changeLogParserFactory.getParser(file, resourceAccessor);
            DatabaseChangeLog changelog = parser.parse(file, changeLogParameters, resourceAccessor);
            if (changelog != null) {
                LinkedHashSet<String> result = new LinkedHashSet<String>();
                for (ChangeSet changeSet : changelog.getChangeSets()) {
                    result.add(changeSet.getFilePath());
                    changeSet.getChanges().stream().map(change -> this.extractChangeFile((Change)change, changeSet.getFilePath())).forEach(changeFile -> changeFile.ifPresent(result::add));
                    for (DatabaseChangeLog parent = changeSet.getChangeLog(); parent != null; parent = parent.getParentChangeLog()) {
                        result.add(parent.getFilePath());
                    }
                }
                result.add(changelog.getFilePath());
                return result;
            }
        }
        catch (LiquibaseException ex) {
            throw new IllegalStateException(ex);
        }
        return Collections.emptySet();
    }

    private Optional<String> extractChangeFile(Change change, String changeSetFilePath) {
        String path = null;
        Boolean relative = null;
        if (change instanceof LoadDataChange) {
            LoadDataChange loadDataChange = (LoadDataChange)change;
            path = loadDataChange.getFile();
            relative = loadDataChange.isRelativeToChangelogFile();
        } else if (change instanceof SQLFileChange) {
            SQLFileChange sqlFileChange = (SQLFileChange)change;
            path = sqlFileChange.getPath();
            relative = sqlFileChange.isRelativeToChangelogFile();
        } else if (change instanceof CreateProcedureChange) {
            CreateProcedureChange createProcedureChange = (CreateProcedureChange)change;
            path = createProcedureChange.getPath();
            relative = createProcedureChange.isRelativeToChangelogFile();
        } else if (change instanceof CreateViewChange) {
            CreateViewChange createViewChange = (CreateViewChange)change;
            path = createViewChange.getPath();
            relative = createViewChange.getRelativeToChangelogFile();
        }
        if (path == null) {
            return Optional.empty();
        }
        if (relative == null || !relative.booleanValue() || changeSetFilePath == null) {
            return Optional.of(path);
        }
        return Optional.of(Paths.get(changeSetFilePath, new String[0]).resolveSibling(path).toString().replace('\\', '/'));
    }
}

