/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.deployment.devservices;

import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.ConfigurationBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.oidc.runtime.devui.OidcDevUiRecorder;
import io.quarkus.oidc.runtime.devui.OidcDevUiRpcSvcPropertiesBean;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.List;
import java.util.Map;

public abstract class AbstractDevUIProcessor {
    protected static final String CONFIG_PREFIX = "quarkus.oidc.";
    protected static final String CLIENT_ID_CONFIG_KEY = "quarkus.oidc.client-id";

    protected static CardPageBuildItem createProviderWebComponent(OidcDevUiRecorder recorder, Capabilities capabilities, String oidcProviderName, String oidcApplicationType, String oidcGrantType, String authorizationUrl, String tokenUrl, String logoutUrl, boolean introspectionIsAvailable, BuildProducer<SyntheticBeanBuildItem> beanProducer, Duration webClientTimeout, Map<String, Map<String, String>> grantOptions, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, ConfigurationBuildItem configurationBuildItem, String keycloakAdminUrl, Map<String, String> keycloakUsers, List<String> keycloakRealms, boolean alwaysLogoutUserInDevUiOnReload) {
        CardPageBuildItem cardPage = new CardPageBuildItem();
        cardPage.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().icon("font-awesome-solid:boxes-stacked")).title((String)(oidcProviderName == null ? "OpenId Connect Dev Console" : oidcProviderName + " provider"))).componentLink("qwc-oidc-provider.js"));
        boolean swaggerIsAvailable = capabilities.isPresent("io.quarkus.smallrye.openapi");
        boolean graphqlIsAvailable = capabilities.isPresent("io.quarkus.smallrye.graphql");
        String swaggerUiPath = swaggerIsAvailable ? nonApplicationRootPathBuildItem.resolvePath(AbstractDevUIProcessor.getProperty(configurationBuildItem, "quarkus.swagger-ui.path")) : null;
        String graphqlUiPath = graphqlIsAvailable ? nonApplicationRootPathBuildItem.resolvePath(AbstractDevUIProcessor.getProperty(configurationBuildItem, "quarkus.smallrye-graphql.ui.root-path")) : null;
        cardPage.addBuildTimeData("devRoot", (Object)nonApplicationRootPathBuildItem.getNonApplicationRootPath());
        beanProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(OidcDevUiRpcSvcPropertiesBean.class).unremovable()).supplier(recorder.prepareRpcServiceProperties(authorizationUrl, tokenUrl, logoutUrl, webClientTimeout, grantOptions, keycloakUsers, oidcProviderName, oidcApplicationType, oidcGrantType, introspectionIsAvailable, keycloakAdminUrl, keycloakRealms, swaggerIsAvailable, graphqlIsAvailable, swaggerUiPath, graphqlUiPath, alwaysLogoutUserInDevUiOnReload)).scope(Singleton.class)).setRuntimeInit().done());
        return cardPage;
    }

    private static String getProperty(ConfigurationBuildItem configurationBuildItem, String propertyKey) {
        String propertyValue = (String)configurationBuildItem.getReadResult().getAllBuildTimeValues().get(propertyKey);
        if (propertyValue != null) {
            return propertyValue;
        }
        propertyValue = (String)configurationBuildItem.getReadResult().getBuildTimeRunTimeValues().get(propertyKey);
        if (propertyValue == null) {
            propertyValue = (String)configurationBuildItem.getReadResult().getRunTimeDefaultValues().get(propertyKey);
        }
        return propertyValue;
    }
}

