/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.deployment.devservices;

import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ConfigurationBuildItem;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.RuntimeConfigSetupCompleteBuildItem;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.deployment.OidcBuildTimeConfig;
import io.quarkus.oidc.deployment.devservices.AbstractDevUIProcessor;
import io.quarkus.oidc.runtime.devui.OidcDevJsonRpcService;
import io.quarkus.oidc.runtime.devui.OidcDevServicesUtils;
import io.quarkus.oidc.runtime.devui.OidcDevUiRecorder;
import io.quarkus.oidc.runtime.providers.KnownOidcProviders;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class OidcDevUIProcessor
extends AbstractDevUIProcessor {
    static volatile Vertx vertxInstance;
    private static final Logger LOG;
    private static final String TENANT_ENABLED_CONFIG_KEY = "quarkus.oidc.tenant-enabled";
    private static final String DISCOVERY_ENABLED_CONFIG_KEY = "quarkus.oidc.discovery-enabled";
    private static final String AUTH_SERVER_URL_CONFIG_KEY = "quarkus.oidc.auth-server-url";
    private static final String APP_TYPE_CONFIG_KEY = "quarkus.oidc.application-type";
    private static final String OIDC_PROVIDER_CONFIG_KEY = "quarkus.oidc.provider";
    private static final String SERVICE_APP_TYPE = "service";
    private static final String KEYCLOAK = "Keycloak";
    private static final String AZURE = "Azure";
    private static final Set<String> OTHER_PROVIDERS;
    OidcBuildTimeConfig oidcConfig;

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep(onlyIf={IsDevelopment.class})
    @Consume(value=RuntimeConfigSetupCompleteBuildItem.class)
    void prepareOidcDevConsole(CuratedApplicationShutdownBuildItem closeBuildItem, Capabilities capabilities, HttpConfiguration httpConfiguration, BeanContainerBuildItem beanContainer, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, BuildProducer<CardPageBuildItem> cardPageProducer, ConfigurationBuildItem configurationBuildItem, OidcDevUiRecorder recorder) {
        if (!OidcDevUIProcessor.isOidcTenantEnabled() || !OidcDevUIProcessor.isClientIdSet()) {
            return;
        }
        OidcTenantConfig providerConfig = OidcDevUIProcessor.getProviderConfig();
        String authServerUrl = OidcDevUIProcessor.getAuthServerUrl(providerConfig);
        if (authServerUrl != null) {
            if (vertxInstance == null) {
                vertxInstance = Vertx.vertx();
                Runnable closeTask = new Runnable(){

                    @Override
                    public void run() {
                        if (vertxInstance != null) {
                            try {
                                vertxInstance.close();
                            }
                            catch (Throwable t) {
                                LOG.error((Object)"Failed to close Vertx instance", t);
                            }
                        }
                        vertxInstance = null;
                    }
                };
                closeBuildItem.addCloseTask(closeTask, true);
            }
            JsonObject metadata = null;
            if (OidcDevUIProcessor.isDiscoveryEnabled(providerConfig) && (metadata = this.discoverMetadata(authServerUrl)) == null) {
                return;
            }
            String providerName = this.tryToGetProviderName(authServerUrl);
            boolean metadataNotNull = metadata != null;
            String keycloakAdminUrl = KEYCLOAK.equals(providerName) ? authServerUrl.substring(0, authServerUrl.indexOf("/realms/")) : null;
            CardPageBuildItem cardPage = OidcDevUIProcessor.createProviderWebComponent(recorder, capabilities, providerName, OidcDevUIProcessor.getApplicationType(providerConfig), this.oidcConfig.devui().grant().type().isPresent() ? this.oidcConfig.devui().grant().type().get().getGrantType() : "code", metadataNotNull ? metadata.getString("authorization_endpoint") : null, metadataNotNull ? metadata.getString("token_endpoint") : null, metadataNotNull ? metadata.getString("end_session_endpoint") : null, metadataNotNull ? metadata.containsKey("introspection_endpoint") || metadata.containsKey("userinfo_endpoint") : this.checkProviderUserInfoRequired(providerConfig), beanContainer, this.oidcConfig.devui().webClientTimeout(), this.oidcConfig.devui().grantOptions(), nonApplicationRootPathBuildItem, configurationBuildItem, keycloakAdminUrl, null, null, true, httpConfiguration);
            cardPageProducer.produce((BuildItem)cardPage);
        }
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    JsonRPCProvidersBuildItem produceOidcDevJsonRpcService() {
        return new JsonRPCProvidersBuildItem(OidcDevJsonRpcService.class);
    }

    private boolean checkProviderUserInfoRequired(OidcTenantConfig providerConfig) {
        if (providerConfig != null) {
            return providerConfig.authentication.userInfoRequired.orElse(false);
        }
        return false;
    }

    private String tryToGetProviderName(String authServerUrl) {
        if (authServerUrl.contains("/realms/")) {
            return KEYCLOAK;
        }
        if (authServerUrl.contains("microsoft")) {
            return AZURE;
        }
        for (String provider : OTHER_PROVIDERS) {
            if (!authServerUrl.contains(provider.toLowerCase())) continue;
            return provider;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonObject discoverMetadata(String authServerUrl) {
        try (WebClient client = OidcDevServicesUtils.createWebClient((Vertx)vertxInstance);){
            String metadataUrl = authServerUrl + "/.well-known/openid-configuration";
            LOG.infof("OIDC Dev Console: discovering the provider metadata at %s", (Object)metadataUrl);
            HttpResponse resp = (HttpResponse)client.getAbs(metadataUrl).putHeader(HttpHeaders.ACCEPT.toString(), "application/json").send().await().indefinitely();
            if (resp.statusCode() == 200) {
                JsonObject jsonObject = resp.bodyAsJsonObject();
                return jsonObject;
            }
            LOG.errorf("OIDC metadata discovery failed: %s", (Object)resp.bodyAsString());
            JsonObject jsonObject = null;
            return jsonObject;
        }
    }

    private static String getConfigProperty(String name) {
        return (String)ConfigProvider.getConfig().getValue(name, String.class);
    }

    private static boolean isOidcTenantEnabled() {
        return OidcDevUIProcessor.getBooleanProperty(TENANT_ENABLED_CONFIG_KEY);
    }

    private static boolean isDiscoveryEnabled(OidcTenantConfig providerConfig) {
        return ConfigProvider.getConfig().getOptionalValue(DISCOVERY_ENABLED_CONFIG_KEY, Boolean.class).orElse(providerConfig != null ? providerConfig.discoveryEnabled.orElse(true) : true);
    }

    private static boolean getBooleanProperty(String name) {
        return ConfigProvider.getConfig().getOptionalValue(name, Boolean.class).orElse(true);
    }

    private static boolean isClientIdSet() {
        return ConfigUtils.isPropertyPresent((String)"quarkus.oidc.client-id");
    }

    private static String getAuthServerUrl(OidcTenantConfig providerConfig) {
        try {
            return OidcDevUIProcessor.getConfigProperty(AUTH_SERVER_URL_CONFIG_KEY);
        }
        catch (Exception ex) {
            return providerConfig != null ? (String)providerConfig.authServerUrl.get() : null;
        }
    }

    private static String getApplicationType(OidcTenantConfig providerConfig) {
        Optional appType = ConfigProvider.getConfig().getOptionalValue(APP_TYPE_CONFIG_KEY, OidcTenantConfig.ApplicationType.class);
        if (appType.isEmpty() && providerConfig != null) {
            appType = providerConfig.applicationType;
        }
        return appType.isPresent() ? ((OidcTenantConfig.ApplicationType)appType.get()).name().toLowerCase() : SERVICE_APP_TYPE;
    }

    private static OidcTenantConfig getProviderConfig() {
        try {
            OidcTenantConfig.Provider p = (OidcTenantConfig.Provider)ConfigProvider.getConfig().getValue(OIDC_PROVIDER_CONFIG_KEY, OidcTenantConfig.Provider.class);
            return KnownOidcProviders.provider((OidcTenantConfig.Provider)p);
        }
        catch (Exception ex) {
            return null;
        }
    }

    static {
        LOG = Logger.getLogger(OidcDevUIProcessor.class);
        OTHER_PROVIDERS = Set.of("Auth0", "Okta", "Google", "Github", "Spotify");
    }
}

