/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.SecurityEvent;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.oidc.runtime.BackChannelLogoutTokenCache;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.OidcTenantConfig;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TenantConfigBean;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.oidc.runtime.TokenVerificationResult;
import io.quarkus.security.spi.runtime.SecurityEventHelper;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.event.Observes;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.microprofile.jwt.Claims;
import org.jboss.logging.Logger;
import org.jose4j.jwt.consumer.InvalidJwtException;

public class BackChannelLogoutHandler {
    private static final Logger LOG = Logger.getLogger(BackChannelLogoutHandler.class);
    private static final String SLASH = "/";

    void setup(@Observes Router router, DefaultTenantConfigResolver resolver) {
        TenantConfigBean tenantConfigBean = resolver.getTenantConfigBean();
        BackChannelLogoutHandler.addRoute(router, tenantConfigBean.getDefaultTenant().oidcConfig(), resolver);
        for (TenantConfigContext nameToOidcTenantConfig : tenantConfigBean.getStaticTenantsConfig().values()) {
            if (nameToOidcTenantConfig.oidcConfig() == null) continue;
            BackChannelLogoutHandler.addRoute(router, nameToOidcTenantConfig.oidcConfig(), resolver);
        }
    }

    private static void addRoute(Router router, OidcTenantConfig oidcTenantConfig, DefaultTenantConfigResolver resolver) {
        if (oidcTenantConfig.tenantEnabled() && oidcTenantConfig.logout().backchannel().path().isPresent()) {
            router.route(oidcTenantConfig.logout().backchannel().path().get()).handler((Handler)new RouteHandler(oidcTenantConfig, resolver));
        }
    }

    private static class RouteHandler
    implements Handler<RoutingContext> {
        private final OidcTenantConfig oidcTenantConfig;
        private final DefaultTenantConfigResolver resolver;

        RouteHandler(OidcTenantConfig oidcTenantConfig, DefaultTenantConfigResolver resolver) {
            this.oidcTenantConfig = oidcTenantConfig;
            this.resolver = resolver;
        }

        public void handle(final RoutingContext context) {
            LOG.debugf("Back channel logout request for the tenant %s received", (Object)this.oidcTenantConfig.tenantId().get());
            String requestPath = context.request().path();
            final TenantConfigContext tenantContext = this.getTenantConfigContext(requestPath);
            if (tenantContext == null) {
                LOG.errorf("Tenant configuration for the tenant %s is not available or does not match the backchannel logout path %s", (Object)this.oidcTenantConfig.tenantId().get(), (Object)requestPath);
                context.response().setStatusCode(400);
                context.response().end();
                return;
            }
            if (OidcUtils.isFormUrlEncodedRequest(context)) {
                OidcUtils.getFormUrlEncodedData(context).subscribe().with((Consumer)new Consumer<MultiMap>(){

                    @Override
                    public void accept(MultiMap form) {
                        String encodedLogoutToken = form.get("logout_token");
                        if (encodedLogoutToken == null) {
                            LOG.debug((Object)"Back channel logout token is missing");
                            context.response().setStatusCode(400);
                        } else {
                            try {
                                TokenVerificationResult result = tenantContext.provider().verifyLogoutJwtToken(encodedLogoutToken);
                                if (this.verifyLogoutTokenClaims(result)) {
                                    String key = result.localVerificationResult.getString(oidcTenantConfig.logout().backchannel().logoutTokenKey());
                                    BackChannelLogoutTokenCache tokens = resolver.getBackChannelLogoutTokens().get(oidcTenantConfig.tenantId().get());
                                    if (tokens == null) {
                                        tokens = new BackChannelLogoutTokenCache(oidcTenantConfig, context.vertx());
                                        resolver.getBackChannelLogoutTokens().put(oidcTenantConfig.tenantId().get(), tokens);
                                    }
                                    tokens.addTokenVerification(key, result);
                                    if (resolver.isSecurityEventObserved()) {
                                        SecurityEventHelper.fire(resolver.getSecurityEvent(), (io.quarkus.security.spi.runtime.SecurityEvent)new SecurityEvent(SecurityEvent.Type.OIDC_BACKCHANNEL_LOGOUT_INITIATED, Map.of("logout_token", result)));
                                    }
                                    context.response().setStatusCode(200);
                                } else {
                                    context.response().setStatusCode(400);
                                }
                            }
                            catch (InvalidJwtException e) {
                                LOG.debug((Object)"Back channel logout token is invalid");
                                context.response().setStatusCode(400);
                            }
                        }
                        context.response().end();
                    }
                });
            } else {
                LOG.debug((Object)("HTTP POST and " + HttpHeaders.APPLICATION_X_WWW_FORM_URLENCODED.toString() + " content type must be used with the Back channel logout request"));
                context.response().setStatusCode(400);
                context.response().end();
            }
        }

        private boolean verifyLogoutTokenClaims(TokenVerificationResult result) {
            JsonObject events = result.localVerificationResult.getJsonObject("events");
            if (events == null || events.getJsonObject("http://schemas.openid.net/event/backchannel-logout") == null) {
                LOG.debug((Object)"Back channel logout token does not have a valid 'events' claim");
                return false;
            }
            if (!result.localVerificationResult.containsKey(this.oidcTenantConfig.logout().backchannel().logoutTokenKey())) {
                LOG.debugf("Back channel logout token does not have %s", (Object)this.oidcTenantConfig.logout().backchannel().logoutTokenKey());
                return false;
            }
            if (result.localVerificationResult.containsKey(Claims.nonce.name())) {
                LOG.debug((Object)"Back channel logout token must not contain 'nonce' claim");
                return false;
            }
            return true;
        }

        private TenantConfigContext getTenantConfigContext(String requestPath) {
            if (this.isMatchingTenant(requestPath, this.resolver.getTenantConfigBean().getDefaultTenant())) {
                return this.resolver.getTenantConfigBean().getDefaultTenant();
            }
            for (TenantConfigContext tenant : this.resolver.getTenantConfigBean().getStaticTenantsConfig().values()) {
                if (!this.isMatchingTenant(requestPath, tenant)) continue;
                return tenant;
            }
            return null;
        }

        private boolean isMatchingTenant(String requestPath, TenantConfigContext tenant) {
            return tenant.oidcConfig().tenantEnabled() && tenant.oidcConfig().tenantId().get().equals(this.oidcTenantConfig.tenantId().get()) && requestPath.equals(this.getRootPath() + (String)tenant.oidcConfig().logout().backchannel().path().orElse(null));
        }

        private String getRootPath() {
            String rootPath = OidcCommonUtils.prependSlash((String)this.resolver.getRootPath());
            if (rootPath.length() > 1 && rootPath.endsWith(BackChannelLogoutHandler.SLASH)) {
                rootPath = rootPath.substring(rootPath.length() - 1);
            }
            return BackChannelLogoutHandler.SLASH.equals(rootPath) ? "" : rootPath;
        }
    }
}

