/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime;

import io.quarkus.security.ForbiddenException;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.AuthorizationFailureEvent;
import io.quarkus.security.spi.runtime.AuthorizationSuccessEvent;
import io.quarkus.security.spi.runtime.MethodDescription;
import io.quarkus.security.spi.runtime.SecurityEvent;
import io.quarkus.security.spi.runtime.SecurityEventHelper;
import io.quarkus.vertx.http.runtime.security.AbstractPathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.JaxRsPathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import java.util.Map;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class JaxRsPermissionChecker {
    private final JaxRsPathMatchingHttpSecurityPolicy jaxRsPathMatchingPolicy;
    private final SecurityEventHelper<AuthorizationSuccessEvent, AuthorizationFailureEvent> eventHelper;
    @Inject
    RoutingContext routingContext;
    @Inject
    CurrentIdentityAssociation identityAssociation;

    JaxRsPermissionChecker(BeanManager beanManager, Event<AuthorizationFailureEvent> authZFailureEvent, Event<AuthorizationSuccessEvent> authZSuccessEvent, @ConfigProperty(name="quarkus.security.events.enabled") boolean securityEventsEnabled, JaxRsPathMatchingHttpSecurityPolicy jaxRsPathMatchingPolicy) {
        this.jaxRsPathMatchingPolicy = jaxRsPathMatchingPolicy.hasNoPermissions() ? null : jaxRsPathMatchingPolicy;
        this.eventHelper = new SecurityEventHelper(authZSuccessEvent, authZFailureEvent, (SecurityEvent)SecurityEventHelper.AUTHORIZATION_SUCCESS, (SecurityEvent)SecurityEventHelper.AUTHORIZATION_FAILURE, beanManager, securityEventsEnabled);
    }

    boolean shouldRunPermissionChecks() {
        return this.jaxRsPathMatchingPolicy != null;
    }

    void applyPermissionChecks(MethodDescription methodDescription) {
        SecurityIdentity newIdentity;
        HttpSecurityPolicy.CheckResult checkResult = (HttpSecurityPolicy.CheckResult)this.jaxRsPathMatchingPolicy.checkPermission(this.routingContext, this.identityAssociation.getDeferredIdentity(), methodDescription).await().indefinitely();
        if (checkResult.getAugmentedIdentity() == null) {
            newIdentity = checkResult.isPermitted() ? null : this.identityAssociation.getIdentity();
        } else if (checkResult.getAugmentedIdentity() != this.identityAssociation.getIdentity()) {
            newIdentity = checkResult.getAugmentedIdentity();
            QuarkusHttpUser.setIdentity((SecurityIdentity)newIdentity, (RoutingContext)this.routingContext);
            this.identityAssociation.setIdentity(newIdentity);
        } else {
            newIdentity = checkResult.getAugmentedIdentity();
        }
        if (checkResult.isPermitted()) {
            if (this.eventHelper.fireEventOnSuccess()) {
                this.eventHelper.fireSuccessEvent((SecurityEvent)new AuthorizationSuccessEvent(newIdentity, AbstractPathMatchingHttpSecurityPolicy.class.getName(), Map.of(RoutingContext.class.getName(), this.routingContext)));
            }
            return;
        }
        Object exception = newIdentity.isAnonymous() ? new UnauthorizedException() : new ForbiddenException();
        if (this.eventHelper.fireEventOnFailure()) {
            this.eventHelper.fireFailureEvent((SecurityEvent)new AuthorizationFailureEvent(newIdentity, (Throwable)exception, AbstractPathMatchingHttpSecurityPolicy.class.getName(), Map.of(RoutingContext.class.getName(), this.routingContext)));
        }
        throw exception;
    }

    MethodDescription getMethodSecuredWithAuthZPolicy(MethodDescription invokedMethodDesc, MethodDescription fallbackMethodDesc) {
        if (this.shouldRunPermissionChecks()) {
            if (this.jaxRsPathMatchingPolicy.requiresAuthorizationPolicy(invokedMethodDesc)) {
                return invokedMethodDesc;
            }
            if (this.jaxRsPathMatchingPolicy.requiresAuthorizationPolicy(fallbackMethodDesc)) {
                return fallbackMethodDesc;
            }
        }
        return null;
    }

    SecurityEventHelper<AuthorizationSuccessEvent, AuthorizationFailureEvent> getEventHelper() {
        return this.eventHelper;
    }
}

