/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime.interceptor;

import io.quarkus.runtime.BlockingOperationNotAllowedException;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.SecurityIdentityAssociation;
import io.quarkus.security.spi.runtime.AuthorizationFailureEvent;
import io.quarkus.security.spi.runtime.AuthorizationSuccessEvent;
import io.quarkus.security.spi.runtime.MethodDescription;
import io.quarkus.security.spi.runtime.SecurityCheck;
import io.quarkus.security.spi.runtime.SecurityCheckStorage;
import io.quarkus.security.spi.runtime.SecurityEvent;
import io.quarkus.security.spi.runtime.SecurityEventHelper;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Singleton;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.ConfigProvider;

@Singleton
public class SecurityConstrainer {
    public static final Object CHECK_OK = new Object();
    private final SecurityCheckStorage storage;
    private final SecurityEventHelper<AuthorizationSuccessEvent, AuthorizationFailureEvent> securityEventHelper;
    private final Instance<SecurityIdentityAssociation> securityIdentityAssociation;
    private final Supplier<Map<String, Object>> additionalEventPropsSupplier;

    public SecurityConstrainer(SecurityCheckStorage storage, BeanManager beanManager, Event<AuthorizationFailureEvent> authZFailureEvent, Event<AuthorizationSuccessEvent> authZSuccessEvent, boolean runtimeConfigReady, Instance<SecurityIdentityAssociation> securityIdentityAssociation, Supplier<Map<String, Object>> additionalEventPropsSupplier) {
        this.securityIdentityAssociation = securityIdentityAssociation;
        this.additionalEventPropsSupplier = additionalEventPropsSupplier;
        this.storage = storage;
        if (runtimeConfigReady) {
            boolean securityEventsEnabled = (Boolean)ConfigProvider.getConfig().getValue("quarkus.security.events.enabled", Boolean.class);
            this.securityEventHelper = new SecurityEventHelper(authZSuccessEvent, authZFailureEvent, (SecurityEvent)SecurityEventHelper.AUTHORIZATION_SUCCESS, (SecurityEvent)SecurityEventHelper.AUTHORIZATION_FAILURE, beanManager, securityEventsEnabled);
        } else {
            this.securityEventHelper = SecurityEventHelper.lazilyOf(authZSuccessEvent, authZFailureEvent, (SecurityEvent)SecurityEventHelper.AUTHORIZATION_SUCCESS, (SecurityEvent)SecurityEventHelper.AUTHORIZATION_FAILURE, (BeanManager)beanManager);
        }
    }

    public void check(Method method, Object[] parameters) {
        SecurityCheck securityCheck = this.storage.getSecurityCheck(method);
        SecurityIdentity identity = null;
        if (securityCheck != null && !securityCheck.isPermitAll()) {
            try {
                identity = ((SecurityIdentityAssociation)this.securityIdentityAssociation.get()).getIdentity();
            }
            catch (BlockingOperationNotAllowedException blockingException) {
                throw new BlockingOperationNotAllowedException("Blocking security check attempted in code running on the event loop. Make the secured method return an async type, i.e. Uni, Multi or CompletionStage, or use an authentication mechanism that sets the SecurityIdentity in a blocking manner prior to delegating the call", (Throwable)blockingException);
            }
            if (this.securityEventHelper.fireEventOnFailure()) {
                try {
                    securityCheck.apply(identity, method, parameters);
                }
                catch (Exception exception) {
                    this.fireAuthZFailureEvent(identity, exception, securityCheck, method);
                    throw exception;
                }
            } else {
                securityCheck.apply(identity, method, parameters);
            }
        }
        if (this.securityEventHelper.fireEventOnSuccess()) {
            this.fireAuthZSuccessEvent(securityCheck, identity, method);
        }
    }

    public Uni<?> nonBlockingCheck(final Method method, final Object[] parameters) {
        final SecurityCheck securityCheck = this.storage.getSecurityCheck(method);
        if (securityCheck != null) {
            if (!securityCheck.isPermitAll()) {
                return ((SecurityIdentityAssociation)this.securityIdentityAssociation.get()).getDeferredIdentity().onItem().transformToUni(new Function<SecurityIdentity, Uni<?>>(){

                    @Override
                    public Uni<?> apply(final SecurityIdentity securityIdentity) {
                        Uni checkResult = securityCheck.nonBlockingApply(securityIdentity, method, parameters);
                        if (SecurityConstrainer.this.securityEventHelper.fireEventOnFailure()) {
                            checkResult = checkResult.onFailure().invoke((Consumer)new Consumer<Throwable>(){

                                @Override
                                public void accept(Throwable throwable) {
                                    SecurityConstrainer.this.fireAuthZFailureEvent(securityIdentity, throwable, securityCheck, method);
                                }
                            });
                        }
                        if (SecurityConstrainer.this.securityEventHelper.fireEventOnSuccess()) {
                            checkResult = checkResult.invoke(new Runnable(){

                                @Override
                                public void run() {
                                    SecurityConstrainer.this.fireAuthZSuccessEvent(securityCheck, securityIdentity, method);
                                }
                            });
                        }
                        return checkResult;
                    }
                });
            }
            if (this.securityEventHelper.fireEventOnSuccess()) {
                this.fireAuthZSuccessEvent(securityCheck, null, method);
            }
        }
        return Uni.createFrom().item(CHECK_OK);
    }

    private void fireAuthZSuccessEvent(SecurityCheck securityCheck, SecurityIdentity identity, Method method) {
        String securityCheckName = securityCheck == null ? null : securityCheck.getClass().getName();
        Map<String, Object> additionalEventProps = this.additionalEventPropsSupplier.get();
        if (identity == null) {
            identity = (SecurityIdentity)additionalEventProps.get(SecurityIdentity.class.getName());
        }
        this.securityEventHelper.fireSuccessEvent((SecurityEvent)new AuthorizationSuccessEvent(identity, securityCheckName, this.additionalEventPropsSupplier.get(), MethodDescription.ofMethod((Method)method)));
    }

    private void fireAuthZFailureEvent(SecurityIdentity identity, Throwable failure, SecurityCheck securityCheck, Method method) {
        this.securityEventHelper.fireFailureEvent((SecurityEvent)new AuthorizationFailureEvent(identity, failure, securityCheck.getClass().getName(), this.additionalEventPropsSupplier.get(), MethodDescription.ofMethod((Method)method)));
    }
}

