/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta;

import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.util.StreamUtils;
import org.springframework.web.util.ContentCachingRequestWrapper;

final class RequestPayloadExtractor {
    RequestPayloadExtractor() {
    }

    @Nullable
    String extract(@NotNull HttpServletRequest request, @NotNull SentryOptions options) {
        if (request instanceof ContentCachingRequestWrapper) {
            ContentCachingRequestWrapper cachedRequest = (ContentCachingRequestWrapper)request;
            try {
                byte[] body = cachedRequest.getInputStream().isFinished() ? cachedRequest.getContentAsByteArray() : StreamUtils.copyToByteArray((InputStream)cachedRequest.getInputStream());
                return new String(body, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                options.getLogger().log(SentryLevel.ERROR, "Failed to set request body", (Throwable)e);
                return null;
            }
        }
        return null;
    }
}

