/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.inflector.utils;

import io.swagger.inflector.Constants;
import io.swagger.models.ArrayModel;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolverFully {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolverFully.class);
    private Map<String, Model> schemas;
    private Map<String, Model> resolvedModels = new HashMap<String, Model>();
    private Map<String, Property> resolvedProperties = new HashMap<String, Property>();

    public void resolveFully(Swagger swagger) {
        if (swagger.getDefinitions() != null) {
            this.schemas = swagger.getDefinitions();
            if (this.schemas == null) {
                this.schemas = new HashMap<String, Model>();
            }
        }
        for (String name : this.schemas.keySet()) {
            ArrayModel am;
            Model model = this.schemas.get(name);
            if (model instanceof ModelImpl) {
                ModelImpl impl = (ModelImpl)model;
                if (impl.getVendorExtensions().containsKey(Constants.X_SWAGGER_ROUTER_MODEL)) continue;
                impl.setVendorExtension(Constants.X_SWAGGER_ROUTER_MODEL, (Object)name);
                continue;
            }
            if (model instanceof ComposedModel) {
                ComposedModel cm = (ComposedModel)model;
                if (cm.getVendorExtensions().containsKey(Constants.X_SWAGGER_ROUTER_MODEL)) continue;
                cm.setVendorExtension(Constants.X_SWAGGER_ROUTER_MODEL, (Object)name);
                continue;
            }
            if (!(model instanceof ArrayModel) || (am = (ArrayModel)model).getVendorExtensions().containsKey(Constants.X_SWAGGER_ROUTER_MODEL)) continue;
            am.setVendorExtension(Constants.X_SWAGGER_ROUTER_MODEL, (Object)name);
        }
        if (swagger.getPaths() != null) {
            for (String pathname : swagger.getPaths().keySet()) {
                Path pathItem = (Path)swagger.getPaths().get(pathname);
                this.resolvePath(pathItem);
            }
        }
    }

    public void resolvePath(Path path) {
        for (Operation op : path.getOperations()) {
            for (Parameter parameter : op.getParameters()) {
                if (!(parameter instanceof BodyParameter)) continue;
                BodyParameter body = (BodyParameter)parameter;
                Model schema = body.getSchema();
                Model resolved = this.resolveModel(schema);
                body.setSchema(resolved);
            }
            if (op.getResponses() == null) continue;
            for (String code : op.getResponses().keySet()) {
                Response response = (Response)op.getResponses().get(code);
                if (response.getResponseSchema() == null) continue;
                Model resolved = this.resolveModel(response.getResponseSchema());
                response.setResponseSchema(resolved);
            }
        }
    }

    public Model resolveModel(Model schema) {
        if (schema instanceof RefModel) {
            String ref = ((RefModel)schema).get$ref();
            Model resolved = this.schemas.get(ref = ref.substring(ref.lastIndexOf("/") + 1));
            if (resolved == null) {
                LOGGER.error("unresolved model " + ref);
                return schema;
            }
            if (this.resolvedModels.containsKey(ref)) {
                LOGGER.debug("avoiding infinite loop");
                return this.resolvedModels.get(ref);
            }
            this.resolvedModels.put(ref, schema);
            Model model = this.resolveModel(resolved);
            this.resolvedModels.put(ref, model);
            return model;
        }
        if (schema instanceof ArrayModel) {
            ArrayModel arrayModel = (ArrayModel)schema;
            if (((RefProperty)arrayModel.getItems()).get$ref() != null) {
                arrayModel.setItems(this.resolveProperty(arrayModel.getItems()));
            } else {
                arrayModel.setItems(arrayModel.getItems());
            }
            return arrayModel;
        }
        if (schema.getProperties() != null) {
            Property property;
            ModelImpl model = (ModelImpl)schema;
            LinkedHashMap<String, Property> updated = new LinkedHashMap<String, Property>();
            for (String propertyName : model.getProperties().keySet()) {
                property = (Property)model.getProperties().get(propertyName);
                Property resolved = this.resolveProperty(property);
                updated.put(propertyName, resolved);
            }
            for (String key : updated.keySet()) {
                property = (Property)updated.get(key);
                if (!(property instanceof ObjectProperty)) continue;
                ObjectProperty op = (ObjectProperty)property;
                if (op.getProperties() != model.getProperties()) {
                    model.addProperty(key, property);
                    continue;
                }
                LOGGER.debug("not adding recursive properties, using generic object");
                model.addProperty(key, (Property)new ObjectProperty());
            }
            return model;
        }
        LOGGER.error("no type match for " + schema);
        return schema;
    }

    private Property resolveProperty(Property property) {
        if (property instanceof RefProperty) {
            String ref = ((RefProperty)property).get$ref();
            Model resolved = this.schemas.get(ref = ref.substring(ref.lastIndexOf("/") + 1));
            if (resolved == null) {
                LOGGER.error("unresolved model " + ref);
                return property;
            }
            if (this.resolvedModels.containsKey(ref)) {
                LOGGER.debug("avoiding infinite loop");
                return (Property)this.resolvedModels.get(ref);
            }
            this.resolvedProperties.put(ref, property);
            Model model = this.resolveModel(resolved);
            this.resolvedModels.put(ref, model);
            return (Property)model;
        }
        if (property instanceof ObjectProperty) {
            ObjectProperty obj = (ObjectProperty)property;
            if (obj.getProperties() != null) {
                LinkedHashMap<String, Property> updated = new LinkedHashMap<String, Property>();
                for (String propertyName : obj.getProperties().keySet()) {
                    Property innerProperty = (Property)obj.getProperties().get(propertyName);
                    if (property == innerProperty) continue;
                    Property resolved = this.resolveProperty(innerProperty);
                    updated.put(propertyName, resolved);
                }
                obj.setProperties(updated);
            }
            return obj;
        }
        return property;
    }
}

