/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.handlers.ServletChain;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;

public class RequestDispatcherImpl
implements RequestDispatcher {
    private final String path;
    private final ServletContextImpl servletContext;
    private final ServletChain chain;
    private final ServletPathMatch pathMatch;
    private final boolean named;

    public RequestDispatcherImpl(String path, ServletContextImpl servletContext) {
        this.path = path;
        this.servletContext = servletContext;
        int qPos = path.indexOf("?");
        this.pathMatch = qPos == -1 ? servletContext.getDeployment().getServletPaths().getServletHandlerByPath(path) : servletContext.getDeployment().getServletPaths().getServletHandlerByPath(path.substring(0, qPos));
        this.chain = this.pathMatch;
        this.named = false;
    }

    public RequestDispatcherImpl(ServletChain chain, ServletContextImpl servletContext) {
        this.chain = chain;
        this.named = true;
        this.servletContext = servletContext;
        this.path = null;
        this.pathMatch = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        ServletRequestContext servletRequestContext = ServletRequestContext.requireCurrent();
        HttpServletRequestImpl requestImpl = servletRequestContext.getOriginalRequest();
        HttpServletResponseImpl responseImpl = servletRequestContext.getOriginalResponse();
        if (!this.servletContext.getDeployment().getDeploymentInfo().isAllowNonStandardWrappers()) {
            if (servletRequestContext.getOriginalRequest() != request && !(request instanceof ServletRequestWrapper)) {
                throw UndertowServletMessages.MESSAGES.requestWasNotOriginalOrWrapper(request);
            }
            if (servletRequestContext.getOriginalResponse() != response && !(response instanceof ServletResponseWrapper)) {
                throw UndertowServletMessages.MESSAGES.responseWasNotOriginalOrWrapper(response);
            }
        }
        response.resetBuffer();
        ServletRequest oldRequest = servletRequestContext.getServletRequest();
        ServletResponse oldResponse = servletRequestContext.getServletResponse();
        Map<String, Deque<String>> queryParameters = requestImpl.getQueryParameters();
        if (!this.named) {
            if (request.getAttribute("javax.servlet.forward.request_uri") == null) {
                request.setAttribute("javax.servlet.forward.request_uri", (Object)requestImpl.getRequestURI());
                request.setAttribute("javax.servlet.forward.context_path", (Object)requestImpl.getContextPath());
                request.setAttribute("javax.servlet.forward.servlet_path", (Object)requestImpl.getServletPath());
                request.setAttribute("javax.servlet.forward.path_info", (Object)requestImpl.getPathInfo());
                request.setAttribute("javax.servlet.forward.query_string", (Object)requestImpl.getQueryString());
            }
            String newQueryString = "";
            int qsPos = this.path.indexOf("?");
            String newServletPath = this.path;
            if (qsPos != -1) {
                newQueryString = newServletPath.substring(qsPos + 1);
                newServletPath = newServletPath.substring(0, qsPos);
            }
            String newRequestUri = this.servletContext.getContextPath() + newServletPath;
            Map<String, Deque<String>> newQueryParameters = this.createNewQueryParameters(queryParameters, newQueryString);
            requestImpl.setQueryParameters(newQueryParameters);
            requestImpl.getExchange().setRelativePath(newServletPath);
            requestImpl.getExchange().setQueryString(newQueryString);
            requestImpl.getExchange().setRequestPath(newRequestUri);
            requestImpl.getExchange().setRequestURI(newRequestUri);
            ((ServletRequestContext)requestImpl.getExchange().getAttachment(ServletRequestContext.ATTACHMENT_KEY)).setServletPathMatch(this.pathMatch);
            requestImpl.setServletContext(this.servletContext);
            responseImpl.setServletContext(this.servletContext);
        }
        try {
            try {
                servletRequestContext.setServletRequest(request);
                servletRequestContext.setServletResponse(response);
                if (this.named) {
                    this.servletContext.getDeployment().getServletDispatcher().dispatchToServlet(requestImpl.getExchange(), this.chain, DispatcherType.FORWARD);
                } else {
                    this.servletContext.getDeployment().getServletDispatcher().dispatchToPath(requestImpl.getExchange(), this.pathMatch, DispatcherType.FORWARD);
                }
                if (response instanceof HttpServletResponseImpl) {
                    responseImpl.closeStreamAndWriter();
                } else {
                    try {
                        PrintWriter writer = response.getWriter();
                        writer.flush();
                        writer.close();
                    }
                    catch (IllegalStateException e) {
                        ServletOutputStream outputStream = response.getOutputStream();
                        outputStream.flush();
                        outputStream.close();
                    }
                }
            }
            catch (ServletException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            servletRequestContext.setServletRequest(oldRequest);
            servletRequestContext.setServletResponse(oldResponse);
        }
    }

    private Map<String, Deque<String>> createNewQueryParameters(Map<String, Deque<String>> queryParameters, String newQueryString) {
        HashMap<String, Deque<String>> newQueryParameters = new HashMap<String, Deque<String>>();
        String[] arr$ = newQueryString.split("&");
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ArrayDeque<String> queue;
            String part;
            String name = part = arr$[i$];
            String value = "";
            int equals = part.indexOf(61);
            if (equals != -1) {
                name = part.substring(0, equals);
                value = part.substring(equals + 1);
            }
            if ((queue = (ArrayDeque<String>)newQueryParameters.get(name)) == null) {
                queue = new ArrayDeque<String>(1);
                newQueryParameters.put(name, queue);
            }
            queue.add(value);
        }
        for (Map.Entry<String, Deque<String>> entry : queryParameters.entrySet()) {
            if (!newQueryParameters.containsKey(entry.getKey())) {
                newQueryParameters.put(entry.getKey(), new ArrayDeque(entry.getValue()));
                continue;
            }
            ((Deque)newQueryParameters.get(entry.getKey())).addAll((Collection)entry.getValue());
        }
        return newQueryParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        ServletRequestContext servletRequestContext = ServletRequestContext.requireCurrent();
        HttpServletRequestImpl requestImpl = servletRequestContext.getOriginalRequest();
        HttpServletResponseImpl responseImpl = servletRequestContext.getOriginalResponse();
        if (!this.servletContext.getDeployment().getDeploymentInfo().isAllowNonStandardWrappers()) {
            if (servletRequestContext.getOriginalRequest() != request && !(request instanceof ServletRequestWrapper)) {
                throw UndertowServletMessages.MESSAGES.requestWasNotOriginalOrWrapper(request);
            }
            if (servletRequestContext.getOriginalResponse() != response && !(response instanceof ServletResponseWrapper)) {
                throw UndertowServletMessages.MESSAGES.responseWasNotOriginalOrWrapper(response);
            }
        }
        ServletRequest oldRequest = servletRequestContext.getServletRequest();
        ServletResponse oldResponse = servletRequestContext.getServletResponse();
        Object requestUri = null;
        Object contextPath = null;
        Object servletPath = null;
        Object pathInfo = null;
        Object queryString = null;
        Map<String, Deque<String>> queryParameters = requestImpl.getQueryParameters();
        if (!this.named) {
            requestUri = request.getAttribute("javax.servlet.include.request_uri");
            contextPath = request.getAttribute("javax.servlet.include.context_path");
            servletPath = request.getAttribute("javax.servlet.include.servlet_path");
            pathInfo = request.getAttribute("javax.servlet.include.path_info");
            queryString = request.getAttribute("javax.servlet.include.query_string");
            String newQueryString = "";
            int qsPos = this.path.indexOf("?");
            String newServletPath = this.path;
            if (qsPos != -1) {
                newQueryString = newServletPath.substring(qsPos + 1);
                newServletPath = newServletPath.substring(0, qsPos);
            }
            String newRequestUri = this.servletContext.getContextPath() + newServletPath;
            Map<String, Deque<String>> newQueryParameters = this.createNewQueryParameters(queryParameters, newQueryString);
            requestImpl.setQueryParameters(newQueryParameters);
            request.setAttribute("javax.servlet.include.request_uri", (Object)newRequestUri);
            request.setAttribute("javax.servlet.include.context_path", (Object)this.servletContext.getContextPath());
            request.setAttribute("javax.servlet.include.servlet_path", (Object)this.pathMatch.getMatched());
            request.setAttribute("javax.servlet.include.path_info", (Object)this.pathMatch.getRemaining());
            request.setAttribute("javax.servlet.include.query_string", (Object)newQueryString);
        }
        boolean inInclude = responseImpl.isInsideInclude();
        responseImpl.setInsideInclude(true);
        ServletContextImpl oldContext = requestImpl.getServletContext();
        try {
            requestImpl.setServletContext(this.servletContext);
            responseImpl.setServletContext(this.servletContext);
            try {
                servletRequestContext.setServletRequest(request);
                servletRequestContext.setServletResponse(response);
                this.servletContext.getDeployment().getServletDispatcher().dispatchToServlet(requestImpl.getExchange(), this.chain, DispatcherType.INCLUDE);
            }
            catch (ServletException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            responseImpl.setInsideInclude(inInclude);
            requestImpl.setServletContext(oldContext);
            responseImpl.setServletContext(oldContext);
            servletRequestContext.setServletRequest(oldRequest);
            servletRequestContext.setServletResponse(oldResponse);
            if (!this.named) {
                request.setAttribute("javax.servlet.include.request_uri", requestUri);
                request.setAttribute("javax.servlet.include.context_path", contextPath);
                request.setAttribute("javax.servlet.include.servlet_path", servletPath);
                request.setAttribute("javax.servlet.include.path_info", pathInfo);
                request.setAttribute("javax.servlet.include.query_string", queryString);
                requestImpl.setQueryParameters(queryParameters);
            }
        }
    }

    public void error(ServletRequest request, ServletResponse response, String servletName, String message) throws ServletException, IOException {
        this.error(request, response, servletName, null, message);
    }

    public void error(ServletRequest request, ServletResponse response, String servletName) throws ServletException, IOException {
        this.error(request, response, servletName, null, null);
    }

    public void error(ServletRequest request, ServletResponse response, String servletName, Throwable exception) throws ServletException, IOException {
        this.error(request, response, servletName, exception, exception.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void error(ServletRequest request, ServletResponse response, String servletName, Throwable exception, String message) throws ServletException, IOException {
        ServletRequestContext servletRequestContext = ServletRequestContext.requireCurrent();
        HttpServletRequestImpl requestImpl = servletRequestContext.getOriginalRequest();
        HttpServletResponseImpl responseImpl = servletRequestContext.getOriginalResponse();
        if (!this.servletContext.getDeployment().getDeploymentInfo().isAllowNonStandardWrappers()) {
            if (servletRequestContext.getOriginalRequest() != request && !(request instanceof ServletRequestWrapper)) {
                throw UndertowServletMessages.MESSAGES.requestWasNotOriginalOrWrapper(request);
            }
            if (servletRequestContext.getOriginalResponse() != response && !(response instanceof ServletResponseWrapper)) {
                throw UndertowServletMessages.MESSAGES.responseWasNotOriginalOrWrapper(response);
            }
        }
        response.resetBuffer();
        ServletRequest oldRequest = servletRequestContext.getServletRequest();
        ServletResponse oldResponse = servletRequestContext.getServletResponse();
        servletRequestContext.setDispatcherType(DispatcherType.ERROR);
        request.setAttribute("javax.servlet.error.request_uri", (Object)requestImpl.getRequestURI());
        request.setAttribute("javax.servlet.error.servlet_name", (Object)servletName);
        if (exception != null) {
            request.setAttribute("javax.servlet.error.exception", (Object)exception);
            request.setAttribute("javax.servlet.error.exception_type", exception.getClass());
        }
        request.setAttribute("javax.servlet.error.message", (Object)message);
        request.setAttribute("javax.servlet.error.status_code", (Object)responseImpl.getStatus());
        String newQueryString = "";
        int qsPos = this.path.indexOf("?");
        String newServletPath = this.path;
        if (qsPos != -1) {
            newQueryString = newServletPath.substring(qsPos + 1);
            newServletPath = newServletPath.substring(0, qsPos);
        }
        String newRequestUri = this.servletContext.getContextPath() + newServletPath;
        HashMap<String, Deque<String>> newQueryParameters = new HashMap<String, Deque<String>>();
        String[] arr$ = newQueryString.split("&");
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ArrayDeque<String> queue;
            String part;
            String name = part = arr$[i$];
            String value = "";
            int equals = part.indexOf(61);
            if (equals != -1) {
                name = part.substring(0, equals);
                value = part.substring(equals + 1);
            }
            if ((queue = (ArrayDeque<String>)newQueryParameters.get(name)) == null) {
                queue = new ArrayDeque<String>(1);
                newQueryParameters.put(name, queue);
            }
            queue.add(value);
        }
        requestImpl.setQueryParameters(newQueryParameters);
        requestImpl.getExchange().setRelativePath(newServletPath);
        requestImpl.getExchange().setQueryString(newQueryString);
        requestImpl.getExchange().setRequestPath(newRequestUri);
        requestImpl.getExchange().setRequestURI(newRequestUri);
        ((ServletRequestContext)requestImpl.getExchange().getAttachment(ServletRequestContext.ATTACHMENT_KEY)).setServletPathMatch(this.pathMatch);
        requestImpl.setServletContext(this.servletContext);
        responseImpl.setServletContext(this.servletContext);
        try {
            try {
                servletRequestContext.setServletRequest(request);
                servletRequestContext.setServletResponse(response);
                this.servletContext.getDeployment().getServletDispatcher().dispatchToPath(requestImpl.getExchange(), this.pathMatch, DispatcherType.ERROR);
            }
            catch (ServletException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            servletRequestContext.setServletRequest(oldRequest);
            servletRequestContext.setServletResponse(oldResponse);
        }
    }
}

