/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.dropwizard.ThroughputMeter;
import io.vertx.ext.dropwizard.ThroughputTimer;
import java.util.concurrent.TimeUnit;

public class Helper {
    public static JsonObject convertMetric(Metric metric, TimeUnit rateUnit, TimeUnit durationUnit) {
        if (metric instanceof Timer) {
            return Helper.toJson((Timer)metric, rateUnit, durationUnit);
        }
        if (metric instanceof Gauge) {
            return Helper.toJson((Gauge)metric);
        }
        if (metric instanceof Counter) {
            return Helper.toJson((Counter)metric);
        }
        if (metric instanceof Histogram) {
            return Helper.toJson((Histogram)metric);
        }
        if (metric instanceof Meter) {
            return Helper.toJson((Meter)metric, rateUnit);
        }
        throw new IllegalArgumentException("Unknown metric " + metric);
    }

    private static JsonObject toJson(Gauge gauge) {
        return new JsonObject().put("type", (Object)"gauge").put("value", gauge.getValue());
    }

    private static JsonObject toJson(Counter counter) {
        return new JsonObject().put("type", (Object)"counter").put("count", (Object)counter.getCount());
    }

    private static JsonObject toJson(Histogram histogram) {
        Snapshot snapshot = histogram.getSnapshot();
        JsonObject json = new JsonObject();
        json.put("type", (Object)"histogram");
        json.put("count", (Object)histogram.getCount());
        Helper.populateSnapshot(json, snapshot, 1.0);
        return json;
    }

    private static JsonObject toJson(Meter meter, TimeUnit rateUnit) {
        JsonObject json = new JsonObject();
        json.put("type", (Object)"meter");
        if (meter instanceof ThroughputMeter) {
            ThroughputMeter throughput = (ThroughputMeter)meter;
            json.put("oneSecondRate", (Object)throughput.getValue());
        }
        Helper.populateMetered(json, (Metered)meter, rateUnit);
        return json;
    }

    private static JsonObject toJson(Timer timer, TimeUnit rateUnit, TimeUnit durationUnit) {
        Snapshot snapshot = timer.getSnapshot();
        JsonObject json = new JsonObject();
        json.put("type", (Object)"timer");
        if (timer instanceof ThroughputTimer) {
            ThroughputTimer throughput = (ThroughputTimer)timer;
            json.put("oneSecondRate", (Object)throughput.getValue());
        }
        Helper.populateMetered(json, (Metered)timer, rateUnit);
        double factor = 1.0 / (double)durationUnit.toNanos(1L);
        Helper.populateSnapshot(json, snapshot, factor);
        String duration = durationUnit.toString().toLowerCase();
        json.put("durationRate", (Object)duration);
        return json;
    }

    private static void populateMetered(JsonObject json, Metered meter, TimeUnit rateUnit) {
        double factor = rateUnit.toSeconds(1L);
        json.put("count", (Object)meter.getCount());
        json.put("meanRate", (Object)(meter.getMeanRate() * factor));
        json.put("oneMinuteRate", (Object)(meter.getOneMinuteRate() * factor));
        json.put("fiveMinuteRate", (Object)(meter.getFiveMinuteRate() * factor));
        json.put("fifteenMinuteRate", (Object)(meter.getFifteenMinuteRate() * factor));
        String rate = "events/" + rateUnit.toString().toLowerCase();
        json.put("rate", (Object)rate);
    }

    private static void populateSnapshot(JsonObject json, Snapshot snapshot, double factor) {
        json.put("min", (Object)((double)snapshot.getMin() * factor));
        json.put("max", (Object)((double)snapshot.getMax() * factor));
        json.put("mean", (Object)(snapshot.getMean() * factor));
        json.put("stddev", (Object)(snapshot.getStdDev() * factor));
        json.put("median", (Object)(snapshot.getMedian() * factor));
        json.put("75%", (Object)(snapshot.get75thPercentile() * factor));
        json.put("95%", (Object)(snapshot.get95thPercentile() * factor));
        json.put("98%", (Object)(snapshot.get98thPercentile() * factor));
        json.put("99%", (Object)(snapshot.get99thPercentile() * factor));
        json.put("99.9%", (Object)(snapshot.get999thPercentile() * factor));
    }
}

