/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.healthchecks.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.healthchecks.CheckResult;
import io.vertx.ext.healthchecks.Status;
import io.vertx.ext.healthchecks.impl.Procedure;
import io.vertx.ext.healthchecks.impl.ProcedureException;
import java.util.Objects;

class DefaultProcedure
implements Procedure {
    private final Handler<Promise<Status>> handler;
    private final String name;
    private final Vertx vertx;
    private final long timeout;

    DefaultProcedure(Vertx vertx, String name, long timeout, Handler<Promise<Status>> handler) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(name);
        Objects.requireNonNull(handler);
        this.timeout = timeout;
        this.name = name;
        this.handler = handler;
        this.vertx = vertx;
    }

    @Override
    public void check(Handler<CheckResult> resultHandler) {
        try {
            Promise promise = Promise.promise();
            promise.future().onComplete(ar -> resultHandler.handle((Object)DefaultProcedure.from(this.name, ar)));
            if (this.timeout >= 0L) {
                this.vertx.setTimer(this.timeout, l -> promise.tryFail((Throwable)new ProcedureException("Timeout")));
            }
            try {
                this.handler.handle((Object)promise);
            }
            catch (Exception e) {
                promise.tryFail((Throwable)new ProcedureException(e));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static CheckResult from(String name, AsyncResult<?> ar) {
        if (ar.succeeded()) {
            Status res = null;
            if (ar.result() instanceof Status) {
                res = (Status)ar.result();
            } else if (ar.result() instanceof JsonObject) {
                res = new Status((JsonObject)ar.result());
            }
            return CheckResult.from(name, res);
        }
        return CheckResult.from(name, ar.cause());
    }
}

