/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.containers;

import io.zeebe.containers.ZeebeBrokerNode;
import io.zeebe.containers.ZeebeDefaults;
import io.zeebe.containers.ZeebePort;
import java.time.Duration;
import org.apiguardian.api.API;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

@API(status=API.Status.STABLE)
public class ZeebeBrokerContainer
extends GenericContainer<ZeebeBrokerContainer>
implements ZeebeBrokerNode<ZeebeBrokerContainer> {
    private static final Duration DEFAULT_STARTUP_TIMEOUT = Duration.ofMinutes(1L);

    public ZeebeBrokerContainer() {
        this(ZeebeDefaults.getInstance().getDefaultDockerImage());
    }

    public ZeebeBrokerContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        this.applyDefaultConfiguration();
    }

    public static HttpWaitStrategy newDefaultBrokerReadyCheck() {
        return new HttpWaitStrategy().forPath("/ready").forPort(ZeebePort.MONITORING.getPort()).forStatusCodeMatching(status -> status >= 200 && status < 300).withReadTimeout(Duration.ofSeconds(10L));
    }

    private WaitAllStrategy newDefaultWaitStrategy() {
        return new WaitAllStrategy(WaitAllStrategy.Mode.WITH_OUTER_TIMEOUT).withStrategy((WaitStrategy)new HostPortWaitStrategy()).withStrategy((WaitStrategy)ZeebeBrokerContainer.newDefaultBrokerReadyCheck()).withStartupTimeout(DEFAULT_STARTUP_TIMEOUT);
    }

    private void applyDefaultConfiguration() {
        ((ZeebeBrokerContainer)((ZeebeBrokerContainer)((ZeebeBrokerContainer)((ZeebeBrokerContainer)((ZeebeBrokerContainer)this.withNetwork(Network.SHARED)).waitingFor((WaitStrategy)this.newDefaultWaitStrategy())).withEnv("ZEEBE_BROKER_GATEWAY_ENABLE", "false")).withEnv("ZEEBE_BROKER_NETWORK_HOST", "0.0.0.0")).withEnv("ZEEBE_BROKER_NETWORK_ADVERTISEDHOST", this.getInternalHost())).addExposedPorts(new int[]{ZeebePort.COMMAND.getPort(), ZeebePort.INTERNAL.getPort(), ZeebePort.MONITORING.getPort()});
    }
}

