/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.containers;

import io.zeebe.containers.ZeebeData;
import io.zeebe.containers.ZeebeNode;
import io.zeebe.containers.ZeebePort;
import io.zeebe.containers.util.HostPortForwarder;
import org.apiguardian.api.API;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.MountableFile;

@API(status=API.Status.STABLE)
public interface ZeebeBrokerNode<T extends GenericContainer<T>>
extends ZeebeNode<T> {
    default public String getInternalCommandAddress() {
        return this.getInternalAddress(ZeebePort.COMMAND.getPort());
    }

    default public String getExternalCommandAddress() {
        return this.getExternalAddress(ZeebePort.COMMAND.getPort());
    }

    @API(status=API.Status.EXPERIMENTAL)
    default public T withZeebeData(ZeebeData data) {
        data.attach((GenericContainer)this.self());
        return (T)((GenericContainer)this.self());
    }

    @API(status=API.Status.EXPERIMENTAL)
    default public T withDebugExporter(int port) {
        int containerPort = HostPortForwarder.forwardHostPort(port, 5);
        ((GenericContainer)this.withCopyToContainer((Transferable)MountableFile.forClasspathResource((String)"debug-exporter.jar"), "/tmp/debug-exporter.jar")).withEnv("ZEEBE_BROKER_EXPORTERS_DEBUG_JARPATH", "/tmp/debug-exporter.jar").withEnv("ZEEBE_BROKER_EXPORTERS_DEBUG_CLASSNAME", "io.zeebe.containers.exporter.DebugExporter").withEnv("ZEEBE_BROKER_EXPORTERS_DEBUG_ARGS_URL", "http://host.testcontainers.internal:" + containerPort + "/records");
        return (T)((GenericContainer)this.self());
    }
}

