/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.containers;

import io.zeebe.containers.ZeebeBrokerContainer;
import io.zeebe.containers.ZeebeBrokerNode;
import io.zeebe.containers.ZeebeDefaults;
import io.zeebe.containers.ZeebeGatewayContainer;
import io.zeebe.containers.ZeebeGatewayNode;
import io.zeebe.containers.ZeebePort;
import io.zeebe.containers.ZeebeTopologyWaitStrategy;
import java.time.Duration;
import org.apiguardian.api.API;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

@API(status=API.Status.STABLE)
public class ZeebeContainer
extends GenericContainer<ZeebeContainer>
implements ZeebeGatewayNode<ZeebeContainer>,
ZeebeBrokerNode<ZeebeContainer> {
    private static final Duration DEFAULT_STARTUP_TIMEOUT = Duration.ofMinutes(1L);

    public ZeebeContainer() {
        this(ZeebeDefaults.getInstance().getDefaultDockerImage());
    }

    public ZeebeContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        this.applyDefaultConfiguration();
    }

    @Override
    public ZeebeContainer withTopologyCheck(ZeebeTopologyWaitStrategy topologyCheck) {
        return (ZeebeContainer)this.waitingFor((WaitStrategy)this.newDefaultWaitStrategy().withStrategy((WaitStrategy)topologyCheck));
    }

    @Override
    public ZeebeContainer withoutTopologyCheck() {
        return (ZeebeContainer)this.waitingFor((WaitStrategy)this.newDefaultWaitStrategy());
    }

    protected WaitAllStrategy newDefaultWaitStrategy() {
        return new WaitAllStrategy(WaitAllStrategy.Mode.WITH_OUTER_TIMEOUT).withStrategy((WaitStrategy)new HostPortWaitStrategy()).withStrategy((WaitStrategy)ZeebeBrokerContainer.newDefaultBrokerReadyCheck()).withStartupTimeout(DEFAULT_STARTUP_TIMEOUT);
    }

    private void applyDefaultConfiguration() {
        ((ZeebeContainer)((ZeebeContainer)((ZeebeContainer)((ZeebeContainer)this.withNetwork(Network.SHARED)).withTopologyCheck(ZeebeGatewayContainer.newDefaultTopologyCheck()).withEnv("ZEEBE_BROKER_GATEWAY_ENABLE", "true")).withEnv("ZEEBE_BROKER_NETWORK_HOST", "0.0.0.0")).withEnv("ZEEBE_BROKER_NETWORK_ADVERTISEDHOST", this.getInternalHost())).addExposedPorts(new int[]{ZeebePort.GATEWAY.getPort(), ZeebePort.COMMAND.getPort(), ZeebePort.INTERNAL.getPort(), ZeebePort.MONITORING.getPort()});
    }
}

