/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.containers;

import io.zeebe.containers.ZeebeDefaults;
import io.zeebe.containers.ZeebeGatewayNode;
import io.zeebe.containers.ZeebePort;
import io.zeebe.containers.ZeebeTopologyWaitStrategy;
import java.time.Duration;
import org.apiguardian.api.API;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

@API(status=API.Status.STABLE)
public class ZeebeGatewayContainer
extends GenericContainer<ZeebeGatewayContainer>
implements ZeebeGatewayNode<ZeebeGatewayContainer> {
    private static final Duration DEFAULT_STARTUP_TIMEOUT = Duration.ofMinutes(1L);

    public ZeebeGatewayContainer() {
        this(ZeebeDefaults.getInstance().getDefaultDockerImage());
    }

    public ZeebeGatewayContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        this.applyDefaultConfiguration();
    }

    public static ZeebeTopologyWaitStrategy newDefaultTopologyCheck() {
        return new ZeebeTopologyWaitStrategy().forBrokersCount(1);
    }

    @Override
    public ZeebeGatewayContainer withTopologyCheck(ZeebeTopologyWaitStrategy topologyCheck) {
        return (ZeebeGatewayContainer)this.waitingFor((WaitStrategy)this.newDefaultWaitStrategy(topologyCheck));
    }

    @Override
    public ZeebeGatewayContainer withoutTopologyCheck() {
        return (ZeebeGatewayContainer)this.waitingFor(new HostPortWaitStrategy().withStartupTimeout(DEFAULT_STARTUP_TIMEOUT));
    }

    private void applyDefaultConfiguration() {
        ((ZeebeGatewayContainer)((ZeebeGatewayContainer)((ZeebeGatewayContainer)((ZeebeGatewayContainer)((ZeebeGatewayContainer)((ZeebeGatewayContainer)this.withNetwork(Network.SHARED)).withTopologyCheck(ZeebeGatewayContainer.newDefaultTopologyCheck()).withEnv("ZEEBE_GATEWAY_NETWORK_HOST", "0.0.0.0")).withEnv("ZEEBE_GATEWAY_CLUSTER_MEMBERID", this.getInternalHost())).withEnv("ZEEBE_GATEWAY_CLUSTER_HOST", this.getInternalHost())).withEnv("ZEEBE_STANDALONE_GATEWAY", "true")).withStartupTimeout(DEFAULT_STARTUP_TIMEOUT)).addExposedPorts(new int[]{ZeebePort.GATEWAY.getPort(), ZeebePort.INTERNAL.getPort(), ZeebePort.MONITORING.getPort()});
    }

    private WaitAllStrategy newDefaultWaitStrategy(ZeebeTopologyWaitStrategy topologyCheck) {
        return new WaitAllStrategy(WaitAllStrategy.Mode.WITH_OUTER_TIMEOUT).withStrategy((WaitStrategy)new HostPortWaitStrategy()).withStrategy((WaitStrategy)topologyCheck).withStartupTimeout(DEFAULT_STARTUP_TIMEOUT);
    }
}

