/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.containers.archive;

import io.zeebe.containers.ZeebeDefaults;
import io.zeebe.containers.archive.ContainerArchive;
import java.io.IOException;
import java.util.Objects;
import org.agrona.LangUtil;
import org.apiguardian.api.API;
import org.testcontainers.containers.GenericContainer;

@API(status=API.Status.EXPERIMENTAL)
public final class ContainerArchiveBuilder {
    private static final String DEFAULT_ARCHIVE_PATH = "/tmp/data.tar.gz";
    private String containerPath = ZeebeDefaults.getInstance().getDefaultDataPath();
    private String archivePath = "/tmp/data.tar.gz";
    private GenericContainer<?> container;

    public <T extends GenericContainer<T>> ContainerArchiveBuilder withContainer(T container) {
        this.container = Objects.requireNonNull(container);
        return this;
    }

    public ContainerArchiveBuilder withArchivePath(String archivePath) {
        this.archivePath = Objects.requireNonNull(archivePath);
        return this;
    }

    public ContainerArchiveBuilder withContainerPath(String containerPath) {
        this.containerPath = Objects.requireNonNull(containerPath);
        return this;
    }

    public ContainerArchive build() {
        if (this.container == null) {
            throw new IllegalArgumentException("Expected to reference an archive from a container, but no container given");
        }
        if (!this.container.isCreated()) {
            throw new IllegalArgumentException("Expected to extract data from the given container, but it doesn't exist yet");
        }
        this.archiveContainerPath();
        return new ContainerArchive(this.archivePath, this.container);
    }

    private void archiveContainerPath() {
        try {
            this.container.execInContainer(new String[]{"tar", "-chzf", this.archivePath, this.containerPath});
        }
        catch (IOException e) {
            LangUtil.rethrowUnchecked((Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LangUtil.rethrowUnchecked((Throwable)e);
        }
    }
}

