/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.containers.clock;

import feign.Target;
import io.zeebe.containers.ZeebeNode;
import io.zeebe.containers.clock.ZeebeClockClient;
import io.zeebe.containers.clock.ZeebeClockImpl;
import io.zeebe.containers.clock.ZeebeClockTarget;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL)
public interface ZeebeClock {
    public Instant pinTime(Instant var1);

    public Instant addTime(Duration var1);

    public Instant getCurrentTime();

    public Instant resetTime();

    public static ZeebeClock newDefaultClock(ZeebeNode<?> zeebe) {
        return new ZeebeClockImpl(new ZeebeClockTarget(zeebe));
    }

    public static ZeebeClock newDefaultClock(URL url) {
        return new ZeebeClockImpl((Target<ZeebeClockClient>)new Target.HardCodedTarget(ZeebeClockClient.class, url.toString()));
    }

    public static final class ZeebeClockException
    extends RuntimeException {
        public ZeebeClockException(Throwable cause) {
            super(cause);
        }
    }
}

