/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.containers.exporter;

import io.camunda.zeebe.protocol.record.Record;
import io.zeebe.containers.exporter.RecordHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.jcip.annotations.ThreadSafe;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.impl.HttpProcessors;
import org.apache.hc.core5.http.impl.bootstrap.AsyncServerBootstrap;
import org.apache.hc.core5.http.impl.bootstrap.HttpAsyncServer;
import org.apache.hc.core5.http.nio.AsyncServerRequestHandler;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.ListenerEndpoint;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.EXPERIMENTAL)
@ThreadSafe
public final class DebugReceiver
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebugReceiver.class);
    private final RecordHandler recordHandler;
    private final HttpAsyncServer server;
    private final SocketAddress unboundAddress;
    private boolean started;
    private ListenerEndpoint endpoint;

    public DebugReceiver(Consumer<Record<?>> recordConsumer) {
        this(recordConsumer, 0);
    }

    public DebugReceiver(Consumer<Record<?>> recordConsumer, boolean autoAcknowledge) {
        this(recordConsumer, 0, autoAcknowledge);
    }

    public DebugReceiver(Consumer<Record<?>> recordConsumer, int port) {
        this(recordConsumer, port, true);
    }

    public DebugReceiver(Consumer<Record<?>> recordConsumer, int port, boolean autoAcknowledge) {
        this(recordConsumer, new InetSocketAddress("localhost", port), autoAcknowledge);
    }

    public DebugReceiver(Consumer<Record<?>> recordConsumer, InetSocketAddress address) {
        this(recordConsumer, address, true);
    }

    public DebugReceiver(Consumer<Record<?>> recordConsumer, InetSocketAddress address, boolean autoAcknowledge) {
        this(new RecordHandler(recordConsumer, autoAcknowledge), address);
    }

    DebugReceiver(RecordHandler recordHandler, InetSocketAddress unboundAddress) {
        this.unboundAddress = Objects.requireNonNull(unboundAddress, "must specify a bind address");
        this.recordHandler = Objects.requireNonNull(recordHandler, "must specify a record handler");
        this.server = this.createServer();
    }

    public void acknowledge(int partitionId, long position) {
        this.recordHandler.acknowledge(partitionId, position);
    }

    public synchronized InetSocketAddress serverAddress() {
        if (!this.started || this.endpoint == null) {
            throw new IllegalStateException("Cannot get server bind address until the receiver is opened");
        }
        return (InetSocketAddress)this.endpoint.getAddress();
    }

    public synchronized URI recordsEndpoint() {
        if (!this.started || this.endpoint == null) {
            throw new IllegalStateException("Cannot get records endpoint until the receiver is opened");
        }
        return URI.create(String.format("http:/%s/records", this.endpoint.getAddress()));
    }

    public DebugReceiver start() {
        if (this.started) {
            return this;
        }
        try {
            this.server.start();
            this.endpoint = (ListenerEndpoint)this.server.listen(this.unboundAddress, URIScheme.HTTP).get();
            this.started = true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn("Interrupted while awaiting server bind; if in the process of shutting down, can be ignored", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to open debug receiver", (Throwable)e);
            this.close();
        }
        return this;
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        this.server.close(CloseMode.IMMEDIATE);
        this.started = false;
    }

    @Override
    public void close() {
        this.stop();
    }

    private HttpAsyncServer createServer() {
        IOReactorConfig config = IOReactorConfig.custom().setIoThreadCount(2).setSoReuseAddress(true).setSoTimeout(5, TimeUnit.SECONDS).setTcpNoDelay(true).build();
        return AsyncServerBootstrap.bootstrap().setIOReactorConfig(config).setCanonicalHostName("localhost").setCharCodingConfig(CharCodingConfig.custom().setCharset(StandardCharsets.UTF_8).build()).setHttpProcessor(HttpProcessors.server((String)"ztc-debug/1.1")).registerVirtual("host.testcontainers.internal", "/records", (AsyncServerRequestHandler)this.recordHandler).register("/records", (AsyncServerRequestHandler)this.recordHandler).create();
    }
}

