/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.containers.util;

import java.time.Duration;
import org.apiguardian.api.API;
import org.testcontainers.containers.GenericContainer;

@API(status=API.Status.EXPERIMENTAL)
public final class RemoteDebugger {
    public static final int DEFAULT_REMOTE_DEBUGGER_PORT = 5005;
    public static final Duration DEFAULT_START_TIMEOUT = Duration.ofMinutes(5L);

    private RemoteDebugger() {
    }

    public static <T extends GenericContainer<T>> T configure(T container) {
        return RemoteDebugger.configure(container, 5005);
    }

    public static <T extends GenericContainer<T>> T configure(T container, int port) {
        return RemoteDebugger.configure(container, port, true);
    }

    public static <T extends GenericContainer<T>> T configure(T container, int port, boolean suspend) {
        String javaOpts = container.getEnvMap().getOrDefault("JAVA_OPTS", "");
        char suspendFlag = suspend ? (char)'y' : 'n';
        container.addExposedPort(Integer.valueOf(port));
        container.getPortBindings().add(port + ":" + port);
        container.withEnv("JAVA_OPTS", String.format("-agentlib:jdwp=transport=dt_socket,server=y,suspend=%s,address=0.0.0.0:%d %s", Character.valueOf(suspendFlag), port, javaOpts));
        return (T)container.withStartupTimeout(DEFAULT_START_TIMEOUT);
    }
}

