/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.ObjectName;
import net.bull.javamelody.internal.model.MBeansAccessor;

public final class TomcatInformations
implements Serializable {
    private static final boolean TOMCAT_USED = System.getProperty("catalina.home") != null;
    private static final long serialVersionUID = -6145865427461051370L;
    private static final List<ObjectName> THREAD_POOLS = new ArrayList<ObjectName>();
    private static final List<ObjectName> GLOBAL_REQUEST_PROCESSORS = new ArrayList<ObjectName>();
    private static int mbeansInitAttemps;
    private final String name;
    private final int maxThreads;
    private final int currentThreadCount;
    private final int currentThreadsBusy;
    private final long bytesReceived;
    private final long bytesSent;
    private final int requestCount;
    private final int errorCount;
    private final long processingTime;
    private final long maxTime;

    private TomcatInformations(ObjectName threadPool) throws JMException {
        this.name = threadPool.getKeyProperty("name");
        this.maxThreads = (Integer)MBeansAccessor.getAttribute(threadPool, "maxThreads");
        this.currentThreadCount = (Integer)MBeansAccessor.getAttribute(threadPool, "currentThreadCount");
        this.currentThreadsBusy = (Integer)MBeansAccessor.getAttribute(threadPool, "currentThreadsBusy");
        ObjectName grp = null;
        for (ObjectName globalRequestProcessor : GLOBAL_REQUEST_PROCESSORS) {
            if (!this.name.equals(globalRequestProcessor.getKeyProperty("name"))) continue;
            grp = globalRequestProcessor;
            break;
        }
        if (grp != null) {
            this.bytesReceived = (Long)MBeansAccessor.getAttribute(grp, "bytesReceived");
            this.bytesSent = (Long)MBeansAccessor.getAttribute(grp, "bytesSent");
            this.requestCount = (Integer)MBeansAccessor.getAttribute(grp, "requestCount");
            this.errorCount = (Integer)MBeansAccessor.getAttribute(grp, "errorCount");
            this.processingTime = (Long)MBeansAccessor.getAttribute(grp, "processingTime");
            this.maxTime = (Long)MBeansAccessor.getAttribute(grp, "maxTime");
        } else {
            this.bytesReceived = 0L;
            this.bytesSent = 0L;
            this.requestCount = 0;
            this.errorCount = 0;
            this.processingTime = 0L;
            this.maxTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<TomcatInformations> buildTomcatInformationsList() {
        if (!TOMCAT_USED) {
            return Collections.emptyList();
        }
        try {
            List<ObjectName> list = THREAD_POOLS;
            synchronized (list) {
                if ((THREAD_POOLS.isEmpty() || GLOBAL_REQUEST_PROCESSORS.isEmpty()) && mbeansInitAttemps < 10) {
                    TomcatInformations.initMBeans();
                    ++mbeansInitAttemps;
                }
            }
            ArrayList<TomcatInformations> tomcatInformationsList = new ArrayList<TomcatInformations>(THREAD_POOLS.size());
            for (ObjectName threadPool : THREAD_POOLS) {
                tomcatInformationsList.add(new TomcatInformations(threadPool));
            }
            return tomcatInformationsList;
        }
        catch (AttributeNotFoundException | InstanceNotFoundException e) {
            return Collections.emptyList();
        }
        catch (JMException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void initMBeans() {
        THREAD_POOLS.clear();
        GLOBAL_REQUEST_PROCESSORS.clear();
        THREAD_POOLS.addAll(MBeansAccessor.getTomcatThreadPools());
        GLOBAL_REQUEST_PROCESSORS.addAll(MBeansAccessor.getTomcatGlobalRequestProcessors());
    }

    public String getName() {
        return this.name;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    int getCurrentThreadCount() {
        return this.currentThreadCount;
    }

    public int getCurrentThreadsBusy() {
        return this.currentThreadsBusy;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public int getRequestCount() {
        return this.requestCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.getName() + ", maxThreads=" + this.getMaxThreads() + ", currentThreadCount=" + this.getCurrentThreadCount() + ", currentThreadsBusy=" + this.getCurrentThreadsBusy() + ", bytesReceived=" + this.getBytesReceived() + ", bytesSent=" + this.getBytesSent() + ", requestCount=" + this.getRequestCount() + ", errorCount=" + this.getErrorCount() + ", processingTime=" + this.getProcessingTime() + ", maxTime=" + this.getMaxTime() + "]";
    }
}

