/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.bull.javamelody.internal.model.Counter;
import net.bull.javamelody.internal.model.CounterRequest;
import net.bull.javamelody.internal.model.ThreadInformations;

public class CounterRequestContext
implements CounterRequest.ICounterRequestContext,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Long ONE = 1L;
    private static final String SPRING_BEST_MATCHING_PATTERN_ATTRIBUTE = "org.springframework.web.servlet.HandlerMapping.bestMatchingPattern";
    private Counter parentCounter;
    private final CounterRequestContext parentContext;
    private CounterRequestContext currentChildContext;
    private final String requestName;
    private final String completeRequestName;
    private final transient HttpServletRequest httpRequest;
    private final String remoteUser;
    private final transient Thread thread;
    private long threadId;
    private String threadName;
    private final long startTime;
    private final long startCpuTime;
    private final long startAllocatedBytes;
    private final String sessionId;
    private int childHits;
    private int childDurationsSum;
    private Map<String, Long> childRequestsExecutionsByRequestId;

    public CounterRequestContext(Counter parentCounter, CounterRequestContext parentContext, String requestName, String completeRequestName, HttpServletRequest httpRequest, String remoteUser, long startCpuTime, long startAllocatedBytes, String sessionId) {
        this(parentCounter, parentContext, requestName, completeRequestName, httpRequest, remoteUser, Thread.currentThread(), System.currentTimeMillis(), startCpuTime, startAllocatedBytes, sessionId);
        if (parentContext != null) {
            parentContext.setCurrentChildContext(this);
        }
    }

    private CounterRequestContext(Counter parentCounter, CounterRequestContext parentContext, String requestName, String completeRequestName, HttpServletRequest httpRequest, String remoteUser, Thread thread, long startTime, long startCpuTime, long startAllocatedBytes, String sessionId) {
        assert (parentCounter != null);
        assert (requestName != null);
        assert (completeRequestName != null);
        this.parentCounter = parentCounter;
        this.parentContext = parentContext;
        this.requestName = requestName;
        this.completeRequestName = completeRequestName;
        this.httpRequest = httpRequest;
        this.remoteUser = remoteUser;
        this.thread = thread;
        if (thread != null) {
            this.threadId = thread.getId();
            this.threadName = thread.getName();
        } else {
            this.threadId = -1L;
            this.threadName = null;
        }
        this.startTime = startTime;
        this.startCpuTime = startCpuTime;
        this.startAllocatedBytes = startAllocatedBytes;
        this.sessionId = sessionId;
    }

    public Counter getParentCounter() {
        return this.parentCounter;
    }

    void setParentCounter(Counter parentCounter) {
        assert (parentCounter != null && this.parentCounter.getName().equals(parentCounter.getName()));
        this.parentCounter = parentCounter;
    }

    public static void replaceParentCounters(List<CounterRequestContext> rootCurrentContexts, List<Counter> newParentCounters) {
        HashMap<String, Counter> newParentCountersByName = new HashMap<String, Counter>(newParentCounters.size());
        for (Counter counter : newParentCounters) {
            newParentCountersByName.put(counter.getName(), counter);
        }
        CounterRequestContext.replaceParentCounters(rootCurrentContexts, newParentCountersByName);
    }

    private static void replaceParentCounters(List<CounterRequestContext> rootCurrentContexts, Map<String, Counter> newParentCountersByName) {
        for (CounterRequestContext context : rootCurrentContexts) {
            List<CounterRequestContext> childContexts;
            Counter newParentCounter = newParentCountersByName.get(context.getParentCounter().getName());
            if (newParentCounter != null) {
                context.setParentCounter(newParentCounter);
            }
            if ((childContexts = context.getChildContexts()).isEmpty()) continue;
            CounterRequestContext.replaceParentCounters(childContexts, newParentCountersByName);
        }
    }

    public CounterRequestContext getParentContext() {
        return this.parentContext;
    }

    public static String getHttpRequestName(HttpServletRequest httpRequest, String requestName) {
        if (httpRequest == null) {
            return requestName;
        }
        try {
            String bestMatchingPattern = (String)httpRequest.getAttribute(SPRING_BEST_MATCHING_PATTERN_ATTRIBUTE);
            if (bestMatchingPattern != null) {
                int indexOfSpace = requestName.indexOf(32);
                if (indexOfSpace != -1) {
                    return bestMatchingPattern + requestName.substring(indexOfSpace);
                }
                return bestMatchingPattern;
            }
        }
        catch (IllegalStateException e) {
            return requestName;
        }
        return requestName;
    }

    public String getRequestName() {
        return CounterRequestContext.getHttpRequestName(this.httpRequest, this.requestName);
    }

    public String getCompleteRequestName() {
        return this.completeRequestName;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public Thread getThread() {
        return this.thread;
    }

    public List<StackTraceElement> getThreadStackTrace() {
        if (this.thread != null) {
            return List.of(this.thread.getStackTrace());
        }
        return null;
    }

    public String getThreadName() {
        if (this.threadName != null) {
            return this.threadName;
        }
        return Long.toString(this.threadId);
    }

    public long getThreadId() {
        return this.threadId;
    }

    public int getDuration(long timeOfSnapshot) {
        return (int)Math.max(timeOfSnapshot - this.startTime, 0L);
    }

    public int getCpuTime() {
        if (this.startCpuTime < 0L) {
            return -1;
        }
        int cpuTime = (int)((ThreadInformations.getThreadCpuTime(this.getThreadId()) - this.startCpuTime) / 1000000L);
        return Math.max(cpuTime, 0);
    }

    public int getAllocatedKBytes() {
        if (this.startAllocatedBytes < 0L) {
            return -1;
        }
        int allocatedKBytes = (int)((ThreadInformations.getThreadAllocatedBytes(this.getThreadId()) - this.startAllocatedBytes) / 1024L);
        return Math.max(allocatedKBytes, 0);
    }

    @Override
    public int getChildHits() {
        return this.childHits;
    }

    @Override
    public int getChildDurationsSum() {
        return this.childDurationsSum;
    }

    public Map<String, Long> getChildRequestsExecutionsByRequestId() {
        if (this.childRequestsExecutionsByRequestId == null) {
            return Collections.emptyMap();
        }
        return this.childRequestsExecutionsByRequestId;
    }

    public int getTotalChildHits() {
        int result = this.getChildHits();
        for (CounterRequestContext childContext = this.getCurrentChildContext(); childContext != null; childContext = childContext.getCurrentChildContext()) {
            result += childContext.getChildHits();
        }
        return result;
    }

    public int getTotalChildDurationsSum() {
        int result = this.getChildDurationsSum();
        for (CounterRequestContext childContext = this.getCurrentChildContext(); childContext != null; childContext = childContext.getCurrentChildContext()) {
            result += childContext.getChildDurationsSum();
        }
        return result;
    }

    public boolean hasChildHits() {
        return this.parentCounter.getChildCounterName() != null && (this.getTotalChildHits() > 0 || this.parentCounter.hasChildHits());
    }

    public List<CounterRequestContext> getChildContexts() {
        CounterRequestContext childContext = this.getCurrentChildContext();
        List childContexts = childContext == null ? Collections.emptyList() : new ArrayList(2);
        while (childContext != null) {
            childContexts.add(childContext);
            childContext = childContext.getCurrentChildContext();
        }
        return Collections.unmodifiableList(childContexts);
    }

    private CounterRequestContext getCurrentChildContext() {
        return this.currentChildContext;
    }

    private void setCurrentChildContext(CounterRequestContext currentChildContext) {
        this.currentChildContext = currentChildContext;
    }

    void addChildRequest(Counter childCounter, String request, String requestId, long duration, boolean systemError, long responseSize) {
        if (this.parentContext != null && this.parentCounter.getName().equals(this.parentContext.getParentCounter().getChildCounterName())) {
            ++this.childHits;
            this.childDurationsSum += (int)duration;
        }
        if (this.parentContext == null) {
            this.addChildRequestForDrillDown(requestId);
        } else {
            this.parentContext.addChildRequestForDrillDown(requestId);
        }
    }

    private void addChildRequestForDrillDown(String requestId) {
        Long nbExecutions;
        if (this.childRequestsExecutionsByRequestId == null) {
            this.childRequestsExecutionsByRequestId = new LinkedHashMap<String, Long>();
        }
        nbExecutions = (nbExecutions = this.childRequestsExecutionsByRequestId.get(requestId)) == null ? ONE : Long.valueOf(nbExecutions + 1L);
        this.childRequestsExecutionsByRequestId.put(requestId, nbExecutions);
    }

    void closeChildContext() {
        CounterRequestContext childContext = this.getCurrentChildContext();
        this.childHits += childContext.getChildHits();
        this.childDurationsSum += childContext.getChildDurationsSum();
        this.setCurrentChildContext(null);
    }

    public CounterRequestContext clone() {
        assert (this.getParentContext() == null);
        return this.clone(null);
    }

    private CounterRequestContext clone(CounterRequestContext parentContextClone) {
        Counter counter = this.getParentCounter();
        CounterRequestContext clone = new CounterRequestContext(counter, parentContextClone, this.getRequestName(), this.getCompleteRequestName(), this.httpRequest, this.getRemoteUser(), this.getThread(), this.startTime, this.startCpuTime, this.startAllocatedBytes, this.sessionId);
        clone.threadId = this.getThreadId();
        clone.threadName = this.getThreadName();
        clone.childHits = this.getChildHits();
        clone.childDurationsSum = this.getChildDurationsSum();
        CounterRequestContext childContext = this.getCurrentChildContext();
        if (childContext != null) {
            clone.currentChildContext = childContext.clone(clone);
        }
        if (this.childRequestsExecutionsByRequestId != null) {
            clone.childRequestsExecutionsByRequestId = new LinkedHashMap<String, Long>(this.childRequestsExecutionsByRequestId);
        }
        return clone;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[parentCounter=" + this.getParentCounter().getName() + ", completeRequestName=" + this.getCompleteRequestName() + ", threadId=" + this.getThreadId() + ", threadName=" + this.getThreadName() + ", startTime=" + this.startTime + ", childHits=" + this.getChildHits() + ", childDurationsSum=" + this.getChildDurationsSum() + ", childContexts=" + this.getChildContexts() + "]";
    }
}

