/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MBeanNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final List<MBeanNode> children;
    private final List<MBeanAttribute> attributes;

    MBeanNode(String name) {
        this.name = name;
        this.description = null;
        this.children = new ArrayList<MBeanNode>();
        this.attributes = null;
    }

    MBeanNode(String name, String description, List<MBeanAttribute> attributes) {
        this.name = name;
        this.description = description;
        this.children = null;
        this.attributes = attributes;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<MBeanNode> getChildren() {
        return this.children;
    }

    public List<MBeanAttribute> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.getName() + "]";
    }

    public static class MBeanAttribute
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final String description;
        private final String formattedValue;

        MBeanAttribute(String name, String description, String formattedValue) {
            this.name = name;
            this.description = description;
            this.formattedValue = formattedValue;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getFormattedValue() {
            return this.formattedValue;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[name=" + this.getName() + ", formattedValue=" + this.getFormattedValue() + "]";
        }
    }
}

