/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.common;

import java.util.Collections;
import java.util.Set;
import junit.framework.Assert;
import net.objectlab.kit.datecalc.common.AbstractDateTestCase;
import net.objectlab.kit.datecalc.common.DateCalculator;
import net.objectlab.kit.datecalc.common.DefaultHolidayCalendar;
import net.objectlab.kit.datecalc.common.HolidayCalendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDateCalculatorCombinationTest<E>
extends AbstractDateTestCase<E> {
    public void testInvalidCombinationDiffHandler() {
        DateCalculator cal1 = this.newDateCalculator("bla", "backward");
        DateCalculator cal2 = this.newDateCalculator("bla2", "forward");
        try {
            cal1.combine(cal2);
            Assert.fail((String)"should not have allowed 2 different handler types to be combined");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testInvalidCombinationNullNotNullHandler() {
        DateCalculator cal1 = this.newDateCalculator("bla", null);
        DateCalculator cal2 = this.newDateCalculator("bla2", "forward");
        try {
            cal1.combine(cal2);
            Assert.fail((String)"should not have allowed 2 different handler types to be combined");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testInvalidCombinationNotNullNullHandler() {
        DateCalculator cal1 = this.newDateCalculator("bla", "forward");
        DateCalculator cal2 = this.newDateCalculator("bla2", null);
        try {
            cal1.combine(cal2);
            Assert.fail((String)"should not have allowed 2 different handler types to be combined");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testValidCombinationOneEmptySet() {
        this.registerHolidays("UK", this.createUKHolidayCalendar());
        DateCalculator cal1 = this.newDateCalculator("bla", "forward");
        Set emptySet = Collections.emptySet();
        DefaultHolidayCalendar hol = new DefaultHolidayCalendar(emptySet, this.newDate("2006-01-01"), this.newDate("2020-12-31"));
        cal1.setHolidayCalendar((HolidayCalendar)hol);
        Object localDate = this.newDate("2006-08-08");
        cal1.setStartDate(localDate);
        DateCalculator cal2 = this.newDateCalculator("UK", "forward");
        DateCalculator combo = cal1.combine(cal2);
        Assert.assertEquals((String)"Combo name", (String)"bla/UK", (String)combo.getName());
        Assert.assertEquals((String)"Combo type", (String)"forward", (String)combo.getHolidayHandlerType());
        Assert.assertEquals((String)"start", localDate, (Object)combo.getStartDate());
        Assert.assertEquals((String)"currentDate", localDate, (Object)combo.getCurrentBusinessDate());
        Assert.assertEquals((String)"Holidays", (int)4, (int)combo.getHolidayCalendar().getHolidays().size());
    }

    public void testValidCombination() {
        this.registerHolidays("UK", this.createUKHolidayCalendar());
        this.registerHolidays("UK", this.createUKHolidayCalendar());
        DateCalculator cal1 = this.newDateCalculator("UK", "forward");
        Object localDate = this.newDate("2006-08-08");
        cal1.setStartDate(localDate);
        DateCalculator cal2 = this.newDateCalculator("UK", "forward");
        DateCalculator combo = cal1.combine(cal2);
        Assert.assertEquals((String)"Combo name", (String)"UK/UK", (String)combo.getName());
        Assert.assertEquals((String)"Combo type", (String)"forward", (String)combo.getHolidayHandlerType());
        Assert.assertEquals((String)"start", localDate, (Object)combo.getStartDate());
        Assert.assertEquals((String)"currentDate", localDate, (Object)combo.getCurrentBusinessDate());
        Assert.assertEquals((String)"Holidays", (int)4, (int)combo.getHolidayCalendar().getHolidays().size());
        Assert.assertEquals((String)"Early Boundary", this.newDate("2006-01-01"), (Object)combo.getHolidayCalendar().getEarlyBoundary());
        Assert.assertEquals((String)"Late Boundary", this.newDate("2020-12-31"), (Object)combo.getHolidayCalendar().getLateBoundary());
    }

    public void testValidCombination2Sets() {
        this.registerHolidays("UK", this.createUKHolidayCalendar());
        this.registerHolidays("US", this.createUSHolidayCalendar());
        DateCalculator cal1 = this.newDateCalculator("US", "forward");
        Object localDate = this.newDate("2006-08-08");
        cal1.setStartDate(localDate);
        DateCalculator cal2 = this.newDateCalculator("UK", "forward");
        DateCalculator combo = cal1.combine(cal2);
        Assert.assertEquals((String)"Combo name", (String)"US/UK", (String)combo.getName());
        Assert.assertEquals((String)"Combo type", (String)"forward", (String)combo.getHolidayHandlerType());
        Assert.assertEquals((String)"start", localDate, (Object)combo.getStartDate());
        Assert.assertEquals((String)"currentDate", localDate, (Object)combo.getCurrentBusinessDate());
        Assert.assertEquals((String)"Holidays", (int)6, (int)combo.getHolidayCalendar().getHolidays().size());
        Assert.assertEquals((String)"Early Boundary", this.newDate("2006-01-01"), (Object)combo.getHolidayCalendar().getEarlyBoundary());
        Assert.assertEquals((String)"Late Boundary", this.newDate("2020-12-31"), (Object)combo.getHolidayCalendar().getLateBoundary());
    }

    public void testNullCombination() {
        this.registerHolidays("US", this.createUSHolidayCalendar());
        DateCalculator cal1 = this.newDateCalculator("US", "forward");
        Object localDate = this.newDate("2006-08-08");
        cal1.setStartDate(localDate);
        DateCalculator combo = cal1.combine(null);
        Assert.assertSame((String)"same", (Object)combo, cal1);
        Assert.assertEquals((String)"Combo name", (String)"US", (String)combo.getName());
        Assert.assertEquals((String)"Combo type", (String)"forward", (String)combo.getHolidayHandlerType());
        Assert.assertEquals((String)"start", localDate, (Object)combo.getStartDate());
        Assert.assertEquals((String)"currentDate", localDate, (Object)combo.getCurrentBusinessDate());
        Assert.assertEquals((String)"Holidays", (int)3, (int)combo.getHolidayCalendar().getHolidays().size());
    }

    public void testSameCombination() {
        this.registerHolidays("US", this.createUSHolidayCalendar());
        DateCalculator cal1 = this.newDateCalculator("US", "forward");
        Object localDate = this.newDate("2006-08-08");
        cal1.setStartDate(localDate);
        DateCalculator combo = cal1.combine(cal1);
        Assert.assertSame((String)"same", (Object)combo, cal1);
        Assert.assertEquals((String)"Combo name", (String)"US", (String)combo.getName());
        Assert.assertEquals((String)"Combo type", (String)"forward", (String)combo.getHolidayHandlerType());
        Assert.assertEquals((String)"start", localDate, (Object)combo.getStartDate());
        Assert.assertEquals((String)"currentDate", localDate, (Object)combo.getCurrentBusinessDate());
        Assert.assertEquals((String)"Holidays", (int)3, (int)combo.getHolidayCalendar().getHolidays().size());
        Assert.assertEquals((String)"Early Boundary", this.newDate("2005-01-01"), (Object)combo.getHolidayCalendar().getEarlyBoundary());
        Assert.assertEquals((String)"Late Boundary", this.newDate("2021-12-31"), (Object)combo.getHolidayCalendar().getLateBoundary());
    }

    public void testInvalidEarlyBoundary() {
        this.checkInvalidEarlyBoundary("forward");
        this.checkInvalidEarlyBoundary("backward");
        this.checkInvalidEarlyBoundary("forwardUnlessMovingBack");
        this.checkInvalidEarlyBoundary("modifiedFollowing");
        this.checkInvalidEarlyBoundary("modifiedPreceding");
    }

    public void checkInvalidEarlyBoundary(String type) {
        this.registerHolidays("US", this.createUSHolidayCalendar());
        DateCalculator cal1 = this.newDateCalculator("US", type);
        Object localDate = this.newDate("2006-08-08");
        cal1.setStartDate(localDate);
        DateCalculator cal2 = this.newDateCalculator("BLA", type);
        cal1.setStartDate(localDate);
        try {
            cal2.combine(cal1);
            AbstractDateCalculatorCombinationTest.fail((String)"Combination should have thrown an exception because of boundary");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            cal1.combine(cal2);
            AbstractDateCalculatorCombinationTest.fail((String)"Combination should have thrown an exception because of boundary");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void testInvalidLateBoundary() {
        this.checkInvalidLateBoundary("forward");
        this.checkInvalidLateBoundary("backward");
        this.checkInvalidLateBoundary("forwardUnlessMovingBack");
        this.checkInvalidLateBoundary("modifiedFollowing");
        this.checkInvalidLateBoundary("modifiedPreceding");
    }

    public void checkInvalidLateBoundary(String type) {
        this.registerHolidays("US", this.createUSHolidayCalendar());
        DateCalculator cal1 = this.newDateCalculator("US", type);
        Object localDate = this.newDate("2006-08-08");
        cal1.setStartDate(localDate);
        DateCalculator cal2 = this.newDateCalculator("BLA", type);
        Set emptySet = Collections.emptySet();
        DefaultHolidayCalendar hol = new DefaultHolidayCalendar(emptySet, this.newDate("2006-01-01"), null);
        cal2.setHolidayCalendar((HolidayCalendar)hol);
        cal2.setStartDate(localDate);
        try {
            cal2.combine(cal1);
            AbstractDateCalculatorCombinationTest.fail((String)"Combination should have thrown an exception because of boundary");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            cal1.combine(cal2);
            AbstractDateCalculatorCombinationTest.fail((String)"Combination should have thrown an exception because of boundary");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void testInvalidExplicitEarlyBoundary() {
        this.registerHolidays("US", this.createUSHolidayCalendar());
        DateCalculator cal1 = this.newDateCalculator("US", "forward");
        Object localDate = this.newDate("2006-08-08");
        cal1.setStartDate(localDate);
        DateCalculator cal2 = this.newDateCalculator("BLA", "forward");
        Set emptySet = Collections.emptySet();
        DefaultHolidayCalendar hol = new DefaultHolidayCalendar(emptySet, null, this.newDate("2006-12-31"));
        cal2.setHolidayCalendar((HolidayCalendar)hol);
        cal2.setStartDate(localDate);
        try {
            cal2.combine(cal1);
            AbstractDateCalculatorCombinationTest.fail((String)"Combination should have thrown an exception because of boundary");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            cal1.combine(cal2);
            AbstractDateCalculatorCombinationTest.fail((String)"Combination should have thrown an exception because of boundary");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }
}

