/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.common;

import java.util.Set;
import junit.framework.Assert;
import net.objectlab.kit.datecalc.common.AbstractDateTestCase;
import net.objectlab.kit.datecalc.common.DateCalculator;
import net.objectlab.kit.datecalc.common.DefaultHolidayCalendar;
import net.objectlab.kit.datecalc.common.HolidayCalendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDateCalculatorFactoryTest<E>
extends AbstractDateTestCase<E> {
    public void testGetCalendarsNoHoliday() {
        DateCalculator cal1 = this.getDateCalculatorFactory().getDateCalculator("bla", null);
        Assert.assertNotNull((String)"cal1", (Object)cal1);
        Assert.assertEquals((String)"name", (String)"bla", (String)cal1.getName());
        Assert.assertTrue((String)"no holiday", (boolean)cal1.getHolidayCalendar().getHolidays().isEmpty());
        DateCalculator cal2 = this.getDateCalculatorFactory().getDateCalculator("bla", null);
        Assert.assertNotNull((String)"cal2", (Object)cal2);
        Assert.assertEquals((String)"name", (String)"bla", (String)cal2.getName());
        Assert.assertTrue((String)"no holiday", (boolean)cal2.getHolidayCalendar().getHolidays().isEmpty());
        Assert.assertNotSame((Object)cal1, (Object)cal2);
    }

    public void testGetCalendarsNoHolidayButSomeRegistered() {
        this.getDateCalculatorFactory().registerHolidays("UK", this.createUKHolidayCalendar());
        DateCalculator cal1 = this.getDateCalculatorFactory().getDateCalculator("bla", null);
        Assert.assertNotNull((String)"cal1", (Object)cal1);
        Assert.assertEquals((String)"name", (String)"bla", (String)cal1.getName());
        Assert.assertTrue((String)"no holiday", (boolean)cal1.getHolidayCalendar().getHolidays().isEmpty());
        DateCalculator cal2 = this.getDateCalculatorFactory().getDateCalculator("UK", null);
        Assert.assertNotNull((String)"cal2", (Object)cal2);
        Assert.assertEquals((String)"name cal2", (String)"UK", (String)cal2.getName());
        Assert.assertEquals((String)"UK holidays", (int)4, (int)cal2.getHolidayCalendar().getHolidays().size());
        Assert.assertNotSame((Object)cal1, (Object)cal2);
    }

    public void testGetCalendarsNames() {
        this.getDateCalculatorFactory().registerHolidays("UK", this.createUKHolidayCalendar());
        this.getDateCalculatorFactory().registerHolidays("US", this.createUSHolidayCalendar());
        Set cals = this.getDateCalculatorFactory().getRegisteredHolidayCalendarNames();
        Assert.assertNotNull((String)"cal1", (Object)cals);
        Assert.assertEquals((String)"cals size", (int)2, (int)cals.size());
        Assert.assertTrue((String)"UK", (boolean)cals.contains("UK"));
        Assert.assertTrue((String)"US", (boolean)cals.contains("US"));
        Assert.assertTrue((String)"BLA", (!cals.contains("BLA") ? 1 : 0) != 0);
        this.getDateCalculatorFactory().unregisterHolidayCalendar("ZZZ");
        cals = this.getDateCalculatorFactory().getRegisteredHolidayCalendarNames();
        Assert.assertNotNull((String)"cal1", (Object)cals);
        Assert.assertEquals((String)"cals size", (int)2, (int)cals.size());
        Assert.assertTrue((String)"UK", (boolean)cals.contains("UK"));
        Assert.assertTrue((String)"US", (boolean)cals.contains("US"));
        Assert.assertTrue((String)"BLA", (!cals.contains("BLA") ? 1 : 0) != 0);
        this.getDateCalculatorFactory().unregisterHolidayCalendar("UK");
        cals = this.getDateCalculatorFactory().getRegisteredHolidayCalendarNames();
        Assert.assertNotNull((String)"cal1", (Object)cals);
        Assert.assertEquals((String)"cals size", (int)1, (int)cals.size());
        Assert.assertTrue((String)"UK", (!cals.contains("UK") ? 1 : 0) != 0);
        Assert.assertTrue((String)"US", (boolean)cals.contains("US"));
        Assert.assertTrue((String)"BLA", (!cals.contains("BLA") ? 1 : 0) != 0);
        this.getDateCalculatorFactory().unregisterHolidayCalendar("US");
        cals = this.getDateCalculatorFactory().getRegisteredHolidayCalendarNames();
        Assert.assertNotNull((String)"cal1", (Object)cals);
        Assert.assertEquals((String)"cals size", (int)0, (int)cals.size());
        this.getDateCalculatorFactory().registerHolidays("UK", this.createUKHolidayCalendar());
        this.getDateCalculatorFactory().registerHolidays("US", this.createUSHolidayCalendar());
        cals = this.getDateCalculatorFactory().getRegisteredHolidayCalendarNames();
        Assert.assertNotNull((String)"cal1", (Object)cals);
        Assert.assertEquals((String)"cals size", (int)2, (int)cals.size());
        Assert.assertTrue((String)"UK", (boolean)cals.contains("UK"));
        Assert.assertTrue((String)"US", (boolean)cals.contains("US"));
        Assert.assertTrue((String)"BLA", (!cals.contains("BLA") ? 1 : 0) != 0);
        this.getDateCalculatorFactory().unregisterAllHolidayCalendars();
        cals = this.getDateCalculatorFactory().getRegisteredHolidayCalendarNames();
        Assert.assertNotNull((String)"cal1", (Object)cals);
        Assert.assertEquals((String)"cals size", (int)0, (int)cals.size());
    }

    public void testGetCorrectAlgo() {
        DateCalculator cal1 = this.getDateCalculatorFactory().getDateCalculator("bla", null);
        Assert.assertNull((String)"No algo", (Object)cal1.getHolidayHandlerType());
        cal1 = this.getDateCalculatorFactory().getDateCalculator("bla", "backward");
        Assert.assertEquals((String)"Type", (String)"backward", (String)cal1.getHolidayHandlerType());
        cal1 = this.getDateCalculatorFactory().getDateCalculator("bla", "forward");
        Assert.assertEquals((String)"Type", (String)"forward", (String)cal1.getHolidayHandlerType());
        cal1 = this.getDateCalculatorFactory().getDateCalculator("bla", "modifiedFollowing");
        Assert.assertEquals((String)"Type", (String)"modifiedFollowing", (String)cal1.getHolidayHandlerType());
        cal1 = this.getDateCalculatorFactory().getDateCalculator("bla", "modifiedPreceding");
        Assert.assertEquals((String)"Type", (String)"modifiedPreceding", (String)cal1.getHolidayHandlerType());
    }

    public void testGetIncorrectAlgo() {
        try {
            this.getDateCalculatorFactory().getDateCalculator("bla", "bliobl");
            AbstractDateCalculatorFactoryTest.fail((String)"Should have thrown UnsupportedOperationException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetHolCal() {
        DateCalculator cal1 = this.getDateCalculatorFactory().getDateCalculator("bla", null);
        Assert.assertNotNull((String)"No algo", (Object)cal1);
        Assert.assertNotNull((String)"No hol", (Object)cal1.getHolidayCalendar().getHolidays());
        Assert.assertTrue((String)"empty hol", (boolean)cal1.getHolidayCalendar().getHolidays().isEmpty());
        cal1.setHolidayCalendar(null);
        Assert.assertNotNull((String)"empty", (Object)cal1.getHolidayCalendar().getHolidays());
        Assert.assertTrue((String)"empty hol", (boolean)cal1.getHolidayCalendar().getHolidays().isEmpty());
    }

    public void testUseDefault() {
        DateCalculator cal1 = this.getDateCalculatorFactory().getDateCalculator("bla", null);
        Assert.assertNotNull((String)"No algo", (Object)cal1);
        Assert.assertNotNull((String)"No hol", (Object)cal1.getHolidayCalendar().getHolidays());
        Assert.assertTrue((String)"empty hol", (boolean)cal1.getHolidayCalendar().getHolidays().isEmpty());
        Object date = cal1.moveByDays(0).getCurrentBusinessDate();
        Assert.assertEquals((String)"default today", this.newDate(null), (Object)date);
        cal1.setStartDate(null);
        date = cal1.moveByDays(0).getCurrentBusinessDate();
        Assert.assertEquals((String)"default today", this.newDate(null), (Object)date);
        cal1.setStartDate(this.newDate("2006-08-08"));
        cal1.setCurrentBusinessDate(null);
        date = cal1.moveByDays(0).getCurrentBusinessDate();
        Assert.assertEquals((String)"default today", this.newDate(null), (Object)date);
    }

    public void testHolNoAlgo() {
        this.getDateCalculatorFactory().registerHolidays("UK", this.createUKHolidayCalendar());
        DateCalculator cal1 = this.getDateCalculatorFactory().getDateCalculator("UK", null);
        Assert.assertNotNull((String)"No algo", (Object)cal1);
        Assert.assertNotNull((String)"No hol", (Object)cal1.getHolidayCalendar().getHolidays());
        Assert.assertTrue((String)"non empty hol", (!cal1.getHolidayCalendar().getHolidays().isEmpty() ? 1 : 0) != 0);
        cal1.setCurrentBusinessDate(this.newDate("2006-12-25"));
        Assert.assertTrue((String)"current date is holiday", (boolean)cal1.isCurrentDateNonWorking());
        cal1.setCurrentBusinessDate(this.newDate("2006-12-24"));
        Assert.assertTrue((String)"current date is weekend", (boolean)cal1.isCurrentDateNonWorking());
    }

    public void testHolidayCalendar() {
        Set uk = this.createUKHolidays();
        DefaultHolidayCalendar ukCal = new DefaultHolidayCalendar(uk);
        this.getDateCalculatorFactory().registerHolidays("UK", (HolidayCalendar)ukCal);
        AbstractDateCalculatorFactoryTest.assertNull((String)"Early boundary", (Object)ukCal.getEarlyBoundary());
        AbstractDateCalculatorFactoryTest.assertNull((String)"Late boundary", (Object)ukCal.getLateBoundary());
    }
}

