/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.common;

import java.util.HashSet;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.objectlab.kit.datecalc.common.DateCalculator;
import net.objectlab.kit.datecalc.common.DefaultHolidayCalendar;
import net.objectlab.kit.datecalc.common.HolidayCalendar;
import net.objectlab.kit.datecalc.common.KitCalculatorsFactory;
import net.objectlab.kit.datecalc.common.Tenor;
import net.objectlab.kit.datecalc.common.WorkingWeek;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDateTestCase<E>
extends TestCase {
    public AbstractDateTestCase() {
    }

    public AbstractDateTestCase(String name) {
        super(name);
    }

    protected abstract E newDate(String var1);

    protected abstract KitCalculatorsFactory<E> getDateCalculatorFactory();

    protected void checkDate(String string, DateCalculator<E> calendar, String string2) {
        Assert.assertEquals((String)string, this.newDate(string2), (Object)calendar.getCurrentBusinessDate());
    }

    protected Set<E> newHolidaysSet() {
        HashSet<E> holidays = new HashSet<E>();
        holidays.add(this.newDate("2006-08-28"));
        holidays.add(this.newDate("2006-12-25"));
        holidays.add(this.newDate("2006-12-26"));
        return holidays;
    }

    protected HolidayCalendar<E> newHolidaysCalendar() {
        return new DefaultHolidayCalendar(this.newHolidaysSet());
    }

    protected Set<E> createUKHolidays() {
        HashSet<E> uk = new HashSet<E>();
        uk.add(this.newDate("2006-01-01"));
        uk.add(this.newDate("2006-08-28"));
        uk.add(this.newDate("2006-12-25"));
        uk.add(this.newDate("2006-12-26"));
        return uk;
    }

    protected HolidayCalendar<E> createUKHolidayCalendar() {
        return new DefaultHolidayCalendar(this.createUKHolidays(), this.newDate("2006-01-01"), this.newDate("2020-12-31"));
    }

    protected HolidayCalendar<E> createUSHolidayCalendar() {
        return new DefaultHolidayCalendar(this.createUSHolidays(), this.newDate("2005-01-01"), this.newDate("2021-12-31"));
    }

    protected Set<E> createUSHolidays() {
        HashSet<E> us = new HashSet<E>();
        us.add(this.newDate("2006-07-04"));
        us.add(this.newDate("2006-11-28"));
        us.add(this.newDate("2006-12-25"));
        return us;
    }

    protected void registerHolidays(String name, HolidayCalendar<E> holidays) {
        this.getDateCalculatorFactory().registerHolidays(name, holidays);
    }

    protected WorkingWeek getWorkingWeek(WorkingWeek ww) {
        return ww;
    }

    protected DateCalculator<E> newDateCalculator(String name, String type) {
        return this.getDateCalculatorFactory().getDateCalculator(name, type);
    }

    protected void checkMoveByTenor(String startDate, Tenor tenor, int spotLag, String expectedDate, String holidayHandlerType) {
        DateCalculator<E> cal = this.newDateCalculator("bla", holidayHandlerType);
        cal.setHolidayCalendar(this.createUKHolidayCalendar());
        cal.setStartDate(this.newDate(startDate));
        this.checkDate("Move start:" + startDate + " tenor:" + tenor + " daysToSpot:" + spotLag, cal.moveByTenor(tenor, spotLag), expectedDate);
    }

    protected void checkMoveByTenor(String startDate, Tenor tenor, String expectedDate, String holidayHandlerType) {
        DateCalculator<E> cal = this.newDateCalculator("bla", holidayHandlerType);
        cal.setHolidayCalendar(this.createUKHolidayCalendar());
        cal.setStartDate(this.newDate(startDate));
        this.checkDate("Move start:" + startDate + " tenor:" + tenor, cal.moveByTenor(tenor), expectedDate);
    }
}

