/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.common;

import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExcelDateUtilTest<E>
extends TestCase {
    protected abstract E createDate(String var1);

    protected abstract E createDateFromExcel(double var1, boolean var3);

    public void testExcelDate() {
        this.checkDate(this.createDate("1899-12-31"), 0.0, false);
        this.checkDate(this.createDate("1900-01-01"), 1.0, false);
        this.checkDate(this.createDate("1900-03-01"), 61.0, false);
        this.checkDate(this.createDate("1968-06-11"), 25000.0, false);
        this.checkDate(this.createDate("1978-05-31"), 28641.0, false);
        this.checkDate(this.createDate("1999-12-31"), 36525.0, false);
        this.checkDate(this.createDate("2000-01-01"), 36526.0, false);
        this.checkDate(this.createDate("2000-01-01"), 36526.0, false);
        this.checkDate(this.createDate("2000-02-28"), 36584.0, false);
        this.checkDate(this.createDate("2000-02-29"), 36585.0, false);
        this.checkDate(this.createDate("2000-03-01"), 36586.0, false);
        this.checkDate(null, -1.0, false);
    }

    public void testExcelDateUsing1904Windowing() {
        this.checkDate(this.createDate("1904-01-01"), 0.0, true);
        this.checkDate(this.createDate("1904-01-02"), 1.0, true);
        this.checkDate(this.createDate("1904-03-02"), 61.0, true);
        this.checkDate(null, -1.0, false);
    }

    private void checkDate(E date, double excelDate, boolean use1904windowing) {
        AbstractExcelDateUtilTest.assertEquals((String)("excel:" + excelDate), date, this.createDateFromExcel(excelDate, use1904windowing));
    }
}

