/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import net.objectlab.kit.datecalc.common.AbstractDateTestCase;
import net.objectlab.kit.datecalc.common.DateCalculator;
import net.objectlab.kit.datecalc.common.HolidayCalendar;
import net.objectlab.kit.datecalc.common.StandardTenor;
import net.objectlab.kit.datecalc.common.Tenor;
import net.objectlab.kit.datecalc.common.TenorCode;
import net.objectlab.kit.datecalc.common.WorkingWeek;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractForwardDateCalculatorTest<E>
extends AbstractDateTestCase<E> {
    public void testSimpleForwardWithWeekend() {
        DateCalculator cal = this.newDateCalculator("bla", "forward");
        Assert.assertEquals((String)"Name", (String)"bla", (String)cal.getName());
        Assert.assertEquals((String)"Holidays size", (int)0, (int)cal.getHolidayCalendar().getHolidays().size());
        Object startDate = this.newDate("2006-08-01");
        cal.setStartDate(startDate);
        this.checkDate("Move by 0 days", cal.moveByDays(0), "2006-08-01");
        this.checkDate("Move by 1 days", cal.moveByDays(1), "2006-08-02");
        this.checkDate("Move by 1 more days", cal.moveByDays(1), "2006-08-03");
        this.checkDate("Move by 1 more more days", cal.moveByDays(1), "2006-08-04");
        this.checkDate("Move by 1 more more more days (across weekend)", cal.moveByDays(1), "2006-08-07");
    }

    public void testSimpleForwardStartDateWithWeekend() {
        DateCalculator cal = this.newDateCalculator("bla", "forward");
        Assert.assertEquals((String)"Name", (String)"bla", (String)cal.getName());
        Assert.assertEquals((String)"Holidays size", (int)0, (int)cal.getHolidayCalendar().getHolidays().size());
        cal.setStartDate(this.newDate("2006-07-31"));
        this.checkDate("start date Monday", cal, "2006-07-31");
        cal.setStartDate(this.newDate("2006-08-01"));
        this.checkDate("start date Tuesday", cal, "2006-08-01");
        cal.setStartDate(this.newDate("2006-08-02"));
        this.checkDate("start date Wednesday", cal, "2006-08-02");
        cal.setStartDate(this.newDate("2006-08-03"));
        this.checkDate("start date Thursday", cal, "2006-08-03");
        cal.setStartDate(this.newDate("2006-08-04"));
        this.checkDate("start date friday", cal, "2006-08-04");
        cal.setStartDate(this.newDate("2006-08-05"));
        this.checkDate("start date Saturday", cal, "2006-08-07");
        cal.setStartDate(this.newDate("2006-08-06"));
        this.checkDate("start date Sunday", cal, "2006-08-07");
    }

    public void testSimpleForwardStartDateNoWeekend() {
        DateCalculator cal = this.newDateCalculator("bla", "forward");
        WorkingWeek ww = new WorkingWeek().withWorkingDayFromCalendar(true, 7).withWorkingDayFromCalendar(true, 1);
        cal.setWorkingWeek(this.getWorkingWeek(ww));
        Assert.assertEquals((String)"Name", (String)"bla", (String)cal.getName());
        Assert.assertEquals((String)"Holidays size", (int)0, (int)cal.getHolidayCalendar().getHolidays().size());
        cal.setStartDate(this.newDate("2006-07-31"));
        this.checkDate("start date Monday", cal, "2006-07-31");
        cal.setStartDate(this.newDate("2006-08-01"));
        this.checkDate("start date Tuesday", cal, "2006-08-01");
        cal.setStartDate(this.newDate("2006-08-02"));
        this.checkDate("start date Wednesday", cal, "2006-08-02");
        cal.setStartDate(this.newDate("2006-08-03"));
        this.checkDate("start date Thursday", cal, "2006-08-03");
        cal.setStartDate(this.newDate("2006-08-04"));
        this.checkDate("start date friday", cal, "2006-08-04");
        cal.setStartDate(this.newDate("2006-08-05"));
        this.checkDate("start date Saturday", cal, "2006-08-05");
        cal.setStartDate(this.newDate("2006-08-06"));
        this.checkDate("start date Sunday", cal, "2006-08-06");
    }

    public void testSimpleForwardStartDateWhackyWeek() {
        DateCalculator cal = this.newDateCalculator("bla", "forward");
        Assert.assertEquals((String)"Name", (String)"bla", (String)cal.getName());
        Assert.assertEquals((String)"Holidays size", (int)0, (int)cal.getHolidayCalendar().getHolidays().size());
        WorkingWeek ww = new WorkingWeek().withWorkingDayFromCalendar(false, 2).withWorkingDayFromCalendar(true, 3).withWorkingDayFromCalendar(false, 4).withWorkingDayFromCalendar(true, 5).withWorkingDayFromCalendar(false, 6).withWorkingDayFromCalendar(true, 7).withWorkingDayFromCalendar(false, 1);
        cal.setWorkingWeek(this.getWorkingWeek(ww));
        cal.setStartDate(this.newDate("2006-07-31"));
        this.checkDate("start date Monday", cal, "2006-08-01");
        cal.setStartDate(this.newDate("2006-08-01"));
        this.checkDate("start date Tuesday", cal, "2006-08-01");
        cal.setStartDate(this.newDate("2006-08-02"));
        this.checkDate("start date Wednesday", cal, "2006-08-03");
        cal.setStartDate(this.newDate("2006-08-03"));
        this.checkDate("start date Thursday", cal, "2006-08-03");
        cal.setStartDate(this.newDate("2006-08-04"));
        this.checkDate("start date friday", cal, "2006-08-05");
        cal.setStartDate(this.newDate("2006-08-05"));
        this.checkDate("start date Saturday", cal, "2006-08-05");
        cal.setStartDate(this.newDate("2006-08-06"));
        this.checkDate("start date Sunday", cal, "2006-08-08");
    }

    public void testSimpleForwardStartDateIdealWeekend() {
        DateCalculator cal = this.newDateCalculator("bla", "forward");
        Assert.assertEquals((String)"Name", (String)"bla", (String)cal.getName());
        Assert.assertEquals((String)"Holidays size", (int)0, (int)cal.getHolidayCalendar().getHolidays().size());
        WorkingWeek ww = new WorkingWeek().withWorkingDayFromCalendar(false, 2).withWorkingDayFromCalendar(true, 3).withWorkingDayFromCalendar(true, 4).withWorkingDayFromCalendar(true, 5).withWorkingDayFromCalendar(true, 6).withWorkingDayFromCalendar(false, 7).withWorkingDayFromCalendar(false, 1);
        cal.setWorkingWeek(this.getWorkingWeek(ww));
        cal.setStartDate(this.newDate("2006-07-31"));
        this.checkDate("start date Monday", cal, "2006-08-01");
        cal.setStartDate(this.newDate("2006-08-01"));
        this.checkDate("start date Tuesday", cal, "2006-08-01");
        cal.setStartDate(this.newDate("2006-08-02"));
        this.checkDate("start date Wednesday", cal, "2006-08-02");
        cal.setStartDate(this.newDate("2006-08-03"));
        this.checkDate("start date Thursday", cal, "2006-08-03");
        cal.setStartDate(this.newDate("2006-08-04"));
        this.checkDate("start date friday", cal, "2006-08-04");
        cal.setStartDate(this.newDate("2006-08-05"));
        this.checkDate("start date Saturday", cal, "2006-08-08");
        cal.setStartDate(this.newDate("2006-08-06"));
        this.checkDate("start date Sunday", cal, "2006-08-08");
    }

    public void testSimpleForwardWithHolidays() {
        DateCalculator cal = this.newDateCalculator("bla", "forward");
        HolidayCalendar holidays = this.newHolidaysCalendar();
        Assert.assertEquals((String)"Name", (String)"bla", (String)cal.getName());
        cal.setHolidayCalendar(holidays);
        Assert.assertEquals((String)"Holidays", (Object)holidays.getHolidays(), (Object)cal.getHolidayCalendar().getHolidays());
        Assert.assertEquals((String)"Holidays size", (int)3, (int)cal.getHolidayCalendar().getHolidays().size());
        Assert.assertTrue((String)"contains", (boolean)holidays.isHoliday(this.newDate("2006-08-28")));
        Assert.assertTrue((String)"contains", (boolean)cal.getHolidayCalendar().isHoliday(this.newDate("2006-08-28")));
        cal.setStartDate(this.newDate("2006-08-28"));
        this.checkDate("Move given Bank Holiday", cal, "2006-08-29");
        cal.setStartDate(this.newDate("2006-12-24"));
        this.checkDate("Xmas Eve", cal, "2006-12-27");
        cal.setStartDate(this.newDate("2006-12-21"));
        this.checkDate("21/12 + 1", cal.moveByDays(1), "2006-12-22");
        cal.setStartDate(this.newDate("2006-12-21"));
        this.checkDate("21/12 + 1", cal.moveByDays(2), "2006-12-27");
        cal.setStartDate(this.newDate("2006-12-22"));
        this.checkDate("22/12 + 1", cal.moveByDays(1), "2006-12-27");
        cal.setStartDate(this.newDate("2006-12-23"));
        this.checkDate("23/12 + 1", cal.moveByDays(1), "2006-12-28");
    }

    public void testMoveByBusinessDays() {
        DateCalculator cal = this.newDateCalculator("bla", "forward");
        HolidayCalendar holidays = this.newHolidaysCalendar();
        Assert.assertEquals((String)"Name", (String)"bla", (String)cal.getName());
        cal.setHolidayCalendar(holidays);
        Assert.assertEquals((String)"Holidays", (Object)holidays.getHolidays(), (Object)cal.getHolidayCalendar().getHolidays());
        Assert.assertEquals((String)"Holidays size", (int)3, (int)cal.getHolidayCalendar().getHolidays().size());
        cal.setStartDate(this.newDate("2006-08-24"));
        this.checkDate("Move 1 BD", cal.moveByBusinessDays(1), "2006-08-25");
        cal.setStartDate(this.newDate("2006-08-24"));
        this.checkDate("Add 1 week", cal.moveByDays(7), "2006-08-31");
        cal.setStartDate(this.newDate("2006-08-24"));
        this.checkDate("Move by 1W with 1 bank holiday", cal.moveByBusinessDays(7), "2006-09-05");
    }

    public void testMoveByTenorDaysZeroDayToSpot() {
        this.checkMoveByTenor("2006-08-08", StandardTenor.T_1D, 0, "2006-08-09", "forward");
        this.checkMoveByTenor("2006-08-08", new Tenor(2, TenorCode.DAY), 0, "2006-08-10", "forward");
        this.checkMoveByTenor("2006-08-08", new Tenor(10, TenorCode.DAY), 0, "2006-08-18", "forward");
        this.checkMoveByTenor("2006-08-08", new Tenor(11, TenorCode.DAY), 0, "2006-08-21", "forward");
        this.checkMoveByTenor("2006-08-08", new Tenor(12, TenorCode.DAY), 0, "2006-08-21", "forward");
        this.checkMoveByTenor("2006-08-08", new Tenor(13, TenorCode.DAY), 0, "2006-08-21", "forward");
        this.checkMoveByTenor("2006-09-26", new Tenor(4, TenorCode.DAY), 0, "2006-10-02", "forward");
        this.checkMoveByTenor("2006-08-08", StandardTenor.T_1D, 0, "2006-08-09", "forward");
        this.checkMoveByTenor("2006-08-08", new Tenor(2, TenorCode.DAY), "2006-08-10", "forward");
        this.checkMoveByTenor("2006-08-08", new Tenor(10, TenorCode.DAY), "2006-08-18", "forward");
        this.checkMoveByTenor("2006-08-08", new Tenor(11, TenorCode.DAY), "2006-08-21", "forward");
        this.checkMoveByTenor("2006-08-08", new Tenor(12, TenorCode.DAY), "2006-08-21", "forward");
        this.checkMoveByTenor("2006-08-08", new Tenor(13, TenorCode.DAY), "2006-08-21", "forward");
        this.checkMoveByTenor("2006-09-26", new Tenor(4, TenorCode.DAY), "2006-10-02", "forward");
    }

    public void testMoveByTenorDaysOneDayToSpot() {
        this.checkMoveByTenor("2006-08-08", StandardTenor.T_1D, 1, "2006-08-10", "forward");
        this.checkMoveByTenor("2006-08-08", new Tenor(2, TenorCode.DAY), 1, "2006-08-11", "forward");
        this.checkMoveByTenor("2006-08-07", new Tenor(10, TenorCode.DAY), 1, "2006-08-18", "forward");
        this.checkMoveByTenor("2006-08-07", new Tenor(11, TenorCode.DAY), 1, "2006-08-21", "forward");
        this.checkMoveByTenor("2006-08-07", new Tenor(12, TenorCode.DAY), 1, "2006-08-21", "forward");
        this.checkMoveByTenor("2006-08-07", new Tenor(13, TenorCode.DAY), 1, "2006-08-21", "forward");
    }

    public void testMoveByTenorDaysTwoDaysToSpot() {
        this.checkMoveByTenor("2006-08-08", StandardTenor.T_1D, 2, "2006-08-11", "forward");
        this.checkMoveByTenor("2006-08-08", new Tenor(2, TenorCode.DAY), 2, "2006-08-14", "forward");
        this.checkMoveByTenor("2006-08-07", new Tenor(10, TenorCode.DAY), 2, "2006-08-21", "forward");
        this.checkMoveByTenor("2006-08-07", new Tenor(11, TenorCode.DAY), 2, "2006-08-21", "forward");
        this.checkMoveByTenor("2006-08-07", new Tenor(12, TenorCode.DAY), 2, "2006-08-21", "forward");
        this.checkMoveByTenor("2006-08-07", new Tenor(13, TenorCode.DAY), 2, "2006-08-22", "forward");
    }

    public void testMoveByTenorWeekZeroDayToSpot() {
        this.checkMoveByTenor("2006-08-08", StandardTenor.T_1W, 0, "2006-08-15", "forward");
        this.checkMoveByTenor("2006-08-08", new Tenor(2, TenorCode.WEEK), 0, "2006-08-22", "forward");
        this.checkMoveByTenor("2006-08-08", new Tenor(4, TenorCode.WEEK), 0, "2006-09-05", "forward");
        this.checkMoveByTenor("2006-08-08", StandardTenor.T_1W, "2006-08-15", "forward");
        this.checkMoveByTenor("2006-08-08", new Tenor(2, TenorCode.WEEK), "2006-08-22", "forward");
        this.checkMoveByTenor("2006-08-08", new Tenor(4, TenorCode.WEEK), "2006-09-05", "forward");
    }

    public void testMoveByTenorWeekOneDayToSpot() {
        this.checkMoveByTenor("2006-08-08", StandardTenor.T_1W, 1, "2006-08-16", "forward");
        this.checkMoveByTenor("2006-08-08", new Tenor(2, TenorCode.WEEK), 1, "2006-08-23", "forward");
        this.checkMoveByTenor("2006-08-08", new Tenor(4, TenorCode.WEEK), 1, "2006-09-06", "forward");
    }

    public void testMoveByTenorWeekTwoDaysToSpot() {
        this.checkMoveByTenor("2006-08-08", StandardTenor.T_1W, 2, "2006-08-17", "forward");
        this.checkMoveByTenor("2006-08-08", new Tenor(2, TenorCode.WEEK), 2, "2006-08-24", "forward");
        this.checkMoveByTenor("2006-08-08", new Tenor(4, TenorCode.WEEK), 2, "2006-09-07", "forward");
    }

    public void testMoveByTenorMonthZeroDayToSpot() {
        this.checkMoveByTenor("2006-08-31", StandardTenor.T_1M, 0, "2006-10-02", "forward");
        this.checkMoveByTenor("2006-08-31", StandardTenor.T_2M, 0, "2006-10-31", "forward");
        this.checkMoveByTenor("2006-01-31", StandardTenor.T_1M, 0, "2006-02-28", "forward");
        this.checkMoveByTenor("2008-01-31", StandardTenor.T_1M, 0, "2008-02-29", "forward");
        this.checkMoveByTenor("2006-08-08", StandardTenor.T_1M, 0, "2006-09-08", "forward");
        this.checkMoveByTenor("2006-08-09", StandardTenor.T_1M, 0, "2006-09-11", "forward");
        this.checkMoveByTenor("2006-08-08", new Tenor(2, TenorCode.MONTH), 0, "2006-10-09", "forward");
        this.checkMoveByTenor("2006-08-08", new Tenor(5, TenorCode.MONTH), 0, "2007-01-08", "forward");
        this.checkMoveByTenor("2006-08-31", StandardTenor.T_1M, "2006-10-02", "forward");
        this.checkMoveByTenor("2006-08-31", StandardTenor.T_2M, "2006-10-31", "forward");
        this.checkMoveByTenor("2006-01-31", StandardTenor.T_1M, "2006-02-28", "forward");
        this.checkMoveByTenor("2008-01-31", StandardTenor.T_1M, "2008-02-29", "forward");
        this.checkMoveByTenor("2006-08-08", StandardTenor.T_1M, "2006-09-08", "forward");
        this.checkMoveByTenor("2006-08-09", StandardTenor.T_1M, "2006-09-11", "forward");
        this.checkMoveByTenor("2006-08-08", new Tenor(2, TenorCode.MONTH), "2006-10-09", "forward");
        this.checkMoveByTenor("2006-08-08", new Tenor(5, TenorCode.MONTH), "2007-01-08", "forward");
    }

    public void testMoveByTenorMonthOneDayToSpot() {
        this.checkMoveByTenor("2006-08-31", StandardTenor.T_1M, 1, "2006-10-02", "forward");
        this.checkMoveByTenor("2006-08-31", StandardTenor.T_2M, 1, "2006-11-01", "forward");
        this.checkMoveByTenor("2006-01-31", StandardTenor.T_1M, 1, "2006-03-01", "forward");
        this.checkMoveByTenor("2008-01-31", StandardTenor.T_1M, 1, "2008-03-03", "forward");
        this.checkMoveByTenor("2006-08-08", StandardTenor.T_1M, 1, "2006-09-11", "forward");
        this.checkMoveByTenor("2006-08-09", StandardTenor.T_1M, 1, "2006-09-11", "forward");
        this.checkMoveByTenor("2006-08-08", new Tenor(2, TenorCode.MONTH), 1, "2006-10-09", "forward");
        this.checkMoveByTenor("2006-08-08", new Tenor(5, TenorCode.MONTH), 1, "2007-01-09", "forward");
    }

    public void testMoveByTenorMonthTwoDaysToSpot() {
        this.checkMoveByTenor("2006-08-31", StandardTenor.T_1M, 2, "2006-10-04", "forward");
        this.checkMoveByTenor("2006-08-31", StandardTenor.T_2M, 2, "2006-11-06", "forward");
        this.checkMoveByTenor("2006-01-31", StandardTenor.T_1M, 2, "2006-03-02", "forward");
        this.checkMoveByTenor("2008-01-31", StandardTenor.T_1M, 2, "2008-03-04", "forward");
        this.checkMoveByTenor("2006-08-08", StandardTenor.T_1M, 2, "2006-09-11", "forward");
        this.checkMoveByTenor("2006-08-09", StandardTenor.T_1M, 2, "2006-09-11", "forward");
        this.checkMoveByTenor("2006-08-08", new Tenor(2, TenorCode.MONTH), 2, "2006-10-10", "forward");
        this.checkMoveByTenor("2006-08-08", new Tenor(5, TenorCode.MONTH), 2, "2007-01-10", "forward");
    }

    public void testMoveByTenorYearZeroDayToSpot() {
        this.checkMoveByTenor("2006-08-31", StandardTenor.T_1Y, 0, "2007-08-31", "forward");
        this.checkMoveByTenor("2006-08-31", StandardTenor.T_2Y, 0, "2008-09-01", "forward");
        this.checkMoveByTenor("2008-02-29", StandardTenor.T_1Y, 0, "2009-03-02", "forward");
        this.checkMoveByTenor("2008-02-29", StandardTenor.T_4Y, 0, "2012-02-29", "forward");
        this.checkMoveByTenor("2006-08-31", StandardTenor.T_1Y, "2007-08-31", "forward");
        this.checkMoveByTenor("2006-08-31", StandardTenor.T_2Y, "2008-09-01", "forward");
        this.checkMoveByTenor("2008-02-29", StandardTenor.T_1Y, "2009-03-02", "forward");
        this.checkMoveByTenor("2008-02-29", StandardTenor.T_4Y, "2012-02-29", "forward");
    }

    public void testMoveByTenorYearOneDayToSpot() {
        this.checkMoveByTenor("2006-08-31", StandardTenor.T_1Y, 1, "2007-09-03", "forward");
        this.checkMoveByTenor("2006-08-31", StandardTenor.T_2Y, 1, "2008-09-01", "forward");
        this.checkMoveByTenor("2008-02-29", StandardTenor.T_1Y, 1, "2009-03-03", "forward");
        this.checkMoveByTenor("2008-02-29", StandardTenor.T_4Y, 1, "2012-03-05", "forward");
    }

    public void testMoveByTenorYearTwoDaysToSpot() {
        this.checkMoveByTenor("2006-08-31", StandardTenor.T_1Y, 2, "2007-09-04", "forward");
        this.checkMoveByTenor("2006-08-31", StandardTenor.T_2Y, 2, "2008-09-04", "forward");
        this.checkMoveByTenor("2008-02-29", StandardTenor.T_1Y, 2, "2009-03-04", "forward");
        this.checkMoveByTenor("2008-02-29", StandardTenor.T_4Y, 2, "2012-03-05", "forward");
    }

    public void testMoveByTenorSpotZeroDayToSpot() {
        this.checkMoveByTenor("2006-08-31", StandardTenor.SPOT, 0, "2006-08-31", "forward");
        this.checkMoveByTenor("2006-08-28", StandardTenor.SPOT, 0, "2006-08-29", "forward");
        this.checkMoveByTenor("2006-08-25", StandardTenor.SPOT, 0, "2006-08-25", "forward");
        this.checkMoveByTenor("2006-08-31", StandardTenor.SPOT, "2006-08-31", "forward");
        this.checkMoveByTenor("2006-08-28", StandardTenor.SPOT, "2006-08-29", "forward");
        this.checkMoveByTenor("2006-08-25", StandardTenor.SPOT, "2006-08-25", "forward");
    }

    public void testMoveByTenorSpotOneDayToSpot() {
        this.checkMoveByTenor("2006-08-31", StandardTenor.SPOT, 1, "2006-09-01", "forward");
        this.checkMoveByTenor("2006-08-28", StandardTenor.SPOT, 1, "2006-08-30", "forward");
        this.checkMoveByTenor("2006-08-25", StandardTenor.SPOT, 1, "2006-08-29", "forward");
    }

    public void testMoveByTenorSpotTwoDaysToSpot() {
        this.checkMoveByTenor("2006-08-31", StandardTenor.SPOT, 2, "2006-09-04", "forward");
        this.checkMoveByTenor("2006-08-28", StandardTenor.SPOT, 2, "2006-08-31", "forward");
        this.checkMoveByTenor("2006-08-25", StandardTenor.SPOT, 2, "2006-08-30", "forward");
    }

    public void testMoveByTenorOvernight() {
        this.checkMoveByTenor("2006-08-24", StandardTenor.OVERNIGHT, 0, "2006-08-25", "forward");
        this.checkMoveByTenor("2006-08-25", StandardTenor.OVERNIGHT, 0, "2006-08-29", "forward");
        this.checkMoveByTenor("2006-08-31", StandardTenor.OVERNIGHT, 0, "2006-09-01", "forward");
        this.checkMoveByTenor("2006-08-28", StandardTenor.OVERNIGHT, 0, "2006-08-30", "forward");
    }

    public void testMoveByTenorOvernightOneDayToSpot() {
        this.checkMoveByTenor("2006-08-24", StandardTenor.OVERNIGHT, 1, "2006-08-25", "forward");
        this.checkMoveByTenor("2006-08-25", StandardTenor.OVERNIGHT, 1, "2006-08-29", "forward");
        this.checkMoveByTenor("2006-08-31", StandardTenor.OVERNIGHT, 1, "2006-09-01", "forward");
        this.checkMoveByTenor("2006-08-28", StandardTenor.OVERNIGHT, 1, "2006-08-30", "forward");
    }

    public void testMoveByTenorOvernightTwoDaysToSpot() {
        this.checkMoveByTenor("2006-08-24", StandardTenor.OVERNIGHT, 2, "2006-08-25", "forward");
        this.checkMoveByTenor("2006-08-25", StandardTenor.OVERNIGHT, 2, "2006-08-29", "forward");
        this.checkMoveByTenor("2006-08-31", StandardTenor.OVERNIGHT, 2, "2006-09-01", "forward");
        this.checkMoveByTenor("2006-08-28", StandardTenor.OVERNIGHT, 2, "2006-08-30", "forward");
    }

    public void testCalculateTenorsZeroDaysToSpot() {
        ArrayList<Tenor> list = new ArrayList<Tenor>();
        list.add(StandardTenor.OVERNIGHT);
        list.add(StandardTenor.SPOT);
        list.add(StandardTenor.T_1D);
        list.add(StandardTenor.T_2D);
        list.add(StandardTenor.T_1W);
        list.add(StandardTenor.T_1M);
        list.add(StandardTenor.T_2M);
        list.add(StandardTenor.T_3M);
        list.add(StandardTenor.T_6M);
        list.add(StandardTenor.T_9M);
        list.add(StandardTenor.T_1Y);
        DateCalculator cal = this.newDateCalculator("bla", "forward");
        cal.setHolidayCalendar(this.createUKHolidayCalendar());
        String startDate = "2006-08-24";
        cal.setStartDate(this.newDate(startDate));
        ArrayList expectedResults = new ArrayList();
        expectedResults.add(this.newDate("2006-08-25"));
        expectedResults.add(this.newDate("2006-08-24"));
        expectedResults.add(this.newDate("2006-08-25"));
        expectedResults.add(this.newDate("2006-08-29"));
        expectedResults.add(this.newDate("2006-08-31"));
        expectedResults.add(this.newDate("2006-09-25"));
        expectedResults.add(this.newDate("2006-10-24"));
        expectedResults.add(this.newDate("2006-11-24"));
        expectedResults.add(this.newDate("2007-02-26"));
        expectedResults.add(this.newDate("2007-05-24"));
        expectedResults.add(this.newDate("2007-08-24"));
        List results = cal.calculateTenorDates(list);
        AbstractForwardDateCalculatorTest.assertEquals((String)"Same size as tenor", (int)list.size(), (int)results.size());
        Iterator it = results.iterator();
        Iterator expected = expectedResults.iterator();
        for (Tenor tenor : list) {
            AbstractForwardDateCalculatorTest.assertEquals((String)("Move start:" + startDate + " tenor:" + tenor), expected.next(), it.next());
        }
    }

    public void testCalculateTenorsTwoDaysToSpot() {
        ArrayList<Tenor> list = new ArrayList<Tenor>();
        list.add(StandardTenor.OVERNIGHT);
        list.add(StandardTenor.SPOT);
        list.add(StandardTenor.T_1D);
        list.add(StandardTenor.T_2D);
        list.add(StandardTenor.T_1W);
        list.add(StandardTenor.T_1M);
        list.add(StandardTenor.T_2M);
        list.add(StandardTenor.T_3M);
        list.add(StandardTenor.T_6M);
        list.add(StandardTenor.T_9M);
        list.add(StandardTenor.T_1Y);
        DateCalculator cal = this.newDateCalculator("bla", "forward");
        cal.setHolidayCalendar(this.createUKHolidayCalendar());
        String startDate = "2006-08-24";
        cal.setStartDate(this.newDate(startDate));
        ArrayList expectedResults = new ArrayList();
        expectedResults.add(this.newDate("2006-08-25"));
        expectedResults.add(this.newDate("2006-08-29"));
        expectedResults.add(this.newDate("2006-08-30"));
        expectedResults.add(this.newDate("2006-08-31"));
        expectedResults.add(this.newDate("2006-09-05"));
        expectedResults.add(this.newDate("2006-09-29"));
        expectedResults.add(this.newDate("2006-10-30"));
        expectedResults.add(this.newDate("2006-11-29"));
        expectedResults.add(this.newDate("2007-02-28"));
        expectedResults.add(this.newDate("2007-05-29"));
        expectedResults.add(this.newDate("2007-08-29"));
        List results = cal.calculateTenorDates(list, 2);
        AbstractForwardDateCalculatorTest.assertEquals((String)"Same size as tenor", (int)list.size(), (int)results.size());
        Iterator it = results.iterator();
        Iterator expected = expectedResults.iterator();
        for (Tenor tenor : list) {
            AbstractForwardDateCalculatorTest.assertEquals((String)("Move start:" + startDate + " tenor:" + tenor), expected.next(), it.next());
        }
    }
}

