/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.common;

import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.objectlab.kit.datecalc.common.IMMDateCalculator;
import net.objectlab.kit.datecalc.common.IMMPeriod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIMMDateTest<E>
extends TestCase {
    private IMMDateCalculator<E> cal;

    public void setUp() {
        this.cal = this.getDateCalculator("bla");
    }

    protected abstract IMMDateCalculator<E> getDateCalculator(String var1);

    protected abstract E parseDate(String var1);

    private void checkImm(IMMDateCalculator<E> cal, E date, boolean expected) {
        AbstractIMMDateTest.assertEquals((String)("check " + date), (boolean)expected, (boolean)cal.isIMMDate(date));
    }

    public void testNextIMM() {
        E startDate = this.parseDate("2006-08-01");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-09-20"), (Object)this.cal.getNextIMMDate(startDate));
        startDate = this.parseDate("2006-01-09");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-03-15"), (Object)this.cal.getNextIMMDate(startDate));
        startDate = this.parseDate("2006-02-09");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-03-15"), (Object)this.cal.getNextIMMDate(startDate));
        startDate = this.parseDate("2006-03-09");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-03-15"), (Object)this.cal.getNextIMMDate(startDate));
        startDate = this.parseDate("2006-04-09");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-06-21"), (Object)this.cal.getNextIMMDate(startDate));
        startDate = this.parseDate("2006-05-09");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-06-21"), (Object)this.cal.getNextIMMDate(startDate));
        startDate = this.parseDate("2006-06-09");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-06-21"), (Object)this.cal.getNextIMMDate(startDate));
        startDate = this.parseDate("2006-07-09");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-09-20"), (Object)this.cal.getNextIMMDate(startDate));
        startDate = this.parseDate("2006-08-09");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-09-20"), (Object)this.cal.getNextIMMDate(startDate));
        startDate = this.parseDate("2006-09-09");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-09-20"), (Object)this.cal.getNextIMMDate(startDate));
        startDate = this.parseDate("2006-10-09");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-12-20"), (Object)this.cal.getNextIMMDate(startDate));
        startDate = this.parseDate("2006-11-09");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-12-20"), (Object)this.cal.getNextIMMDate(startDate));
        startDate = this.parseDate("2006-12-09");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-12-20"), (Object)this.cal.getNextIMMDate(startDate));
        startDate = this.parseDate("2006-03-14");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-03-15"), (Object)this.cal.getNextIMMDate(startDate));
        startDate = this.parseDate("2006-03-15");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-06-21"), (Object)this.cal.getNextIMMDate(startDate));
        startDate = this.parseDate("2006-03-16");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-06-21"), (Object)this.cal.getNextIMMDate(startDate));
        startDate = this.parseDate("2006-06-20");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-06-21"), (Object)this.cal.getNextIMMDate(startDate));
        startDate = this.parseDate("2006-06-21");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-09-20"), (Object)this.cal.getNextIMMDate(startDate));
        startDate = this.parseDate("2006-06-22");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-09-20"), (Object)this.cal.getNextIMMDate(startDate));
        startDate = this.parseDate("2006-09-19");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-09-20"), (Object)this.cal.getNextIMMDate(startDate));
        startDate = this.parseDate("2006-09-20");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-12-20"), (Object)this.cal.getNextIMMDate(startDate));
        startDate = this.parseDate("2006-09-21");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-12-20"), (Object)this.cal.getNextIMMDate(startDate));
        startDate = this.parseDate("2006-12-19");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-12-20"), (Object)this.cal.getNextIMMDate(startDate));
        startDate = this.parseDate("2006-12-20");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2007-03-21"), (Object)this.cal.getNextIMMDate(startDate));
        startDate = this.parseDate("2006-12-21");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2007-03-21"), (Object)this.cal.getNextIMMDate(startDate));
        startDate = this.parseDate("2006-03-15");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-06-21"), (Object)this.cal.getNextIMMDate(startDate));
    }

    public void testNextIMMWithPeriod() {
        E startDate = this.parseDate("2006-08-01");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-09-20"), (Object)this.cal.getNextIMMDate(startDate));
        IMMPeriod period = IMMPeriod.QUARTERLY;
        startDate = this.parseDate("2006-01-09");
        Assert.assertEquals((String)("From " + startDate + " period:" + period), this.parseDate("2006-03-15"), (Object)this.cal.getNextIMMDate(startDate, period));
        period = IMMPeriod.BI_ANNUALY_JUN_DEC;
        Assert.assertEquals((String)("From " + startDate + " period:" + period), this.parseDate("2006-06-21"), (Object)this.cal.getNextIMMDate(startDate, period));
        period = IMMPeriod.BI_ANNUALY_MAR_SEP;
        Assert.assertEquals((String)("From " + startDate + " period:" + period), this.parseDate("2006-03-15"), (Object)this.cal.getNextIMMDate(startDate, period));
        period = IMMPeriod.ANNUALLY;
        Assert.assertEquals((String)("From " + startDate + " period:" + period), this.parseDate("2007-03-21"), (Object)this.cal.getNextIMMDate(startDate, period));
        startDate = this.parseDate("2006-03-20");
        period = IMMPeriod.QUARTERLY;
        Assert.assertEquals((String)("From " + startDate + " period:" + period), this.parseDate("2006-06-21"), (Object)this.cal.getNextIMMDate(startDate, period));
        period = IMMPeriod.BI_ANNUALY_JUN_DEC;
        Assert.assertEquals((String)("From " + startDate + " period:" + period), this.parseDate("2006-06-21"), (Object)this.cal.getNextIMMDate(startDate, period));
        period = IMMPeriod.BI_ANNUALY_MAR_SEP;
        Assert.assertEquals((String)("From " + startDate + " period:" + period), this.parseDate("2006-09-20"), (Object)this.cal.getNextIMMDate(startDate, period));
        period = IMMPeriod.ANNUALLY;
        Assert.assertEquals((String)("From " + startDate + " period:" + period), this.parseDate("2007-06-20"), (Object)this.cal.getNextIMMDate(startDate, period));
        startDate = this.parseDate("2006-03-15");
        period = IMMPeriod.QUARTERLY;
        Assert.assertEquals((String)("From " + startDate + " period:" + period), this.parseDate("2006-06-21"), (Object)this.cal.getNextIMMDate(startDate, period));
        period = IMMPeriod.BI_ANNUALY_JUN_DEC;
        Assert.assertEquals((String)("From " + startDate + " period:" + period), this.parseDate("2006-06-21"), (Object)this.cal.getNextIMMDate(startDate, period));
        period = IMMPeriod.BI_ANNUALY_MAR_SEP;
        Assert.assertEquals((String)("From " + startDate + " period:" + period), this.parseDate("2006-09-20"), (Object)this.cal.getNextIMMDate(startDate, period));
        startDate = this.parseDate("2006-03-15");
        period = IMMPeriod.ANNUALLY;
        Assert.assertEquals((String)("From " + startDate + " period:" + period), this.parseDate("2007-06-20"), (Object)this.cal.getNextIMMDate(startDate, period));
    }

    public void testIfIMMDate() {
        this.checkImm(this.cal, this.parseDate("2006-08-01"), false);
        this.checkImm(this.cal, this.parseDate("2006-03-14"), false);
        this.checkImm(this.cal, this.parseDate("2006-03-15"), true);
        this.checkImm(this.cal, this.parseDate("2006-03-16"), false);
        this.checkImm(this.cal, this.parseDate("2006-06-20"), false);
        this.checkImm(this.cal, this.parseDate("2006-06-21"), true);
        this.checkImm(this.cal, this.parseDate("2006-06-22"), false);
        this.checkImm(this.cal, this.parseDate("2006-09-19"), false);
        this.checkImm(this.cal, this.parseDate("2006-09-20"), true);
        this.checkImm(this.cal, this.parseDate("2006-09-21"), false);
        this.checkImm(this.cal, this.parseDate("2006-12-19"), false);
        this.checkImm(this.cal, this.parseDate("2006-12-20"), true);
        this.checkImm(this.cal, this.parseDate("2006-12-21"), false);
    }

    public void testPreviousIMM() {
        E startDate = this.parseDate("2006-08-01");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-06-21"), (Object)this.cal.getPreviousIMMDate(startDate));
        startDate = this.parseDate("2006-01-09");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2005-12-21"), (Object)this.cal.getPreviousIMMDate(startDate));
        startDate = this.parseDate("2006-02-09");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2005-12-21"), (Object)this.cal.getPreviousIMMDate(startDate));
        startDate = this.parseDate("2006-03-09");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2005-12-21"), (Object)this.cal.getPreviousIMMDate(startDate));
        startDate = this.parseDate("2006-04-09");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-03-15"), (Object)this.cal.getPreviousIMMDate(startDate));
        startDate = this.parseDate("2006-05-09");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-03-15"), (Object)this.cal.getPreviousIMMDate(startDate));
        startDate = this.parseDate("2006-06-09");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-03-15"), (Object)this.cal.getPreviousIMMDate(startDate));
        startDate = this.parseDate("2006-07-09");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-06-21"), (Object)this.cal.getPreviousIMMDate(startDate));
        startDate = this.parseDate("2006-08-09");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-06-21"), (Object)this.cal.getPreviousIMMDate(startDate));
        startDate = this.parseDate("2006-09-09");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-06-21"), (Object)this.cal.getPreviousIMMDate(startDate));
        startDate = this.parseDate("2006-10-09");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-09-20"), (Object)this.cal.getPreviousIMMDate(startDate));
        startDate = this.parseDate("2006-11-09");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-09-20"), (Object)this.cal.getPreviousIMMDate(startDate));
        startDate = this.parseDate("2006-12-09");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-09-20"), (Object)this.cal.getPreviousIMMDate(startDate));
        startDate = this.parseDate("2006-03-14");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2005-12-21"), (Object)this.cal.getPreviousIMMDate(startDate));
        startDate = this.parseDate("2006-03-15");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2005-12-21"), (Object)this.cal.getPreviousIMMDate(startDate));
        startDate = this.parseDate("2006-03-16");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-03-15"), (Object)this.cal.getPreviousIMMDate(startDate));
        startDate = this.parseDate("2006-06-20");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-03-15"), (Object)this.cal.getPreviousIMMDate(startDate));
        startDate = this.parseDate("2006-06-21");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-03-15"), (Object)this.cal.getPreviousIMMDate(startDate));
        startDate = this.parseDate("2006-06-22");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-06-21"), (Object)this.cal.getPreviousIMMDate(startDate));
        startDate = this.parseDate("2006-09-19");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-06-21"), (Object)this.cal.getPreviousIMMDate(startDate));
        startDate = this.parseDate("2006-09-20");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-06-21"), (Object)this.cal.getPreviousIMMDate(startDate));
        startDate = this.parseDate("2006-09-21");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-09-20"), (Object)this.cal.getPreviousIMMDate(startDate));
        startDate = this.parseDate("2006-12-19");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-09-20"), (Object)this.cal.getPreviousIMMDate(startDate));
        startDate = this.parseDate("2006-12-20");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-09-20"), (Object)this.cal.getPreviousIMMDate(startDate));
        startDate = this.parseDate("2006-12-21");
        Assert.assertEquals((String)("From " + startDate), this.parseDate("2006-12-20"), (Object)this.cal.getPreviousIMMDate(startDate));
    }

    public void testIMMLists() {
        E startDate = this.parseDate("2005-12-01");
        E endDate = this.parseDate("2007-03-17");
        List imms = this.cal.getIMMDates(startDate, endDate);
        Assert.assertNotNull((Object)imms);
        Assert.assertTrue((String)"Not empty", (!imms.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Expected number of imms dates", (int)5, (int)imms.size());
        Assert.assertEquals((String)"date 1", this.parseDate("2005-12-21"), imms.get(0));
        Assert.assertEquals((String)"date 2", this.parseDate("2006-03-15"), imms.get(1));
        Assert.assertEquals((String)"date 3", this.parseDate("2006-06-21"), imms.get(2));
        Assert.assertEquals((String)"date 4", this.parseDate("2006-09-20"), imms.get(3));
        Assert.assertEquals((String)"date 5", this.parseDate("2006-12-20"), imms.get(4));
    }

    public void testEmptyIMMLists() {
        E startDate = this.parseDate("2006-03-16");
        E endDate = this.parseDate("2006-06-20");
        List imms = this.cal.getIMMDates(startDate, endDate);
        Assert.assertNotNull((Object)imms);
        Assert.assertTrue((String)"empty", (boolean)imms.isEmpty());
    }

    public void testEndOnIMMDateIMMLists() {
        E startDate = this.parseDate("2006-03-16");
        E endDate = this.parseDate("2006-06-21");
        List imms = this.cal.getIMMDates(startDate, endDate);
        Assert.assertNotNull((Object)imms);
        Assert.assertTrue((String)"empty", (!imms.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Expected number of imms dates", (int)1, (int)imms.size());
        Assert.assertEquals((String)"date 1", this.parseDate("2006-06-21"), imms.get(0));
    }

    public void testStartOnIMMDateIMMLists() {
        E startDate = this.parseDate("2006-03-15");
        E endDate = this.parseDate("2006-06-20");
        List imms = this.cal.getIMMDates(startDate, endDate);
        Assert.assertNotNull((Object)imms);
        Assert.assertTrue((String)"empty", (boolean)imms.isEmpty());
    }
}

