/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.common;

import java.util.Set;
import junit.framework.Assert;
import net.objectlab.kit.datecalc.common.AbstractDateTestCase;
import net.objectlab.kit.datecalc.common.DateCalculator;
import net.objectlab.kit.datecalc.common.DefaultHolidayCalendar;
import net.objectlab.kit.datecalc.common.HolidayCalendar;
import net.objectlab.kit.datecalc.common.WorkingWeek;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModifiedPreceedingDateCalculatorTest<E>
extends AbstractDateTestCase<E> {
    public void testSimpleForwardWithWeekend() {
        DateCalculator cal = this.newDateCalculator("bla", "modifiedPreceding");
        Assert.assertEquals((String)"Name", (String)"bla", (String)cal.getName());
        Assert.assertEquals((String)"Holidays size", (int)0, (int)cal.getHolidayCalendar().getHolidays().size());
        Object startDate = this.newDate("2006-08-01");
        cal.setStartDate(startDate);
        this.checkDate("Move by 0 days", cal.moveByDays(0), "2006-08-01");
        this.checkDate("Move by 1 days", cal.moveByDays(1), "2006-08-02");
        this.checkDate("Move by 1 more days", cal.moveByDays(1), "2006-08-03");
        this.checkDate("Move by 1 more more days", cal.moveByDays(1), "2006-08-04");
        this.checkDate("Move by 1 more more more days (across weekend)", cal.moveByDays(1), "2006-08-04");
    }

    public void testSimpleForwardStartDateWithWeekend() {
        DateCalculator cal = this.newDateCalculator("bla", "modifiedPreceding");
        Assert.assertEquals((String)"Name", (String)"bla", (String)cal.getName());
        Assert.assertEquals((String)"Holidays size", (int)0, (int)cal.getHolidayCalendar().getHolidays().size());
        cal.setStartDate(this.newDate("2006-07-31"));
        this.checkDate("start date Monday", cal, "2006-07-31");
        cal.setStartDate(this.newDate("2006-08-01"));
        this.checkDate("start date Tuesday", cal, "2006-08-01");
        cal.setStartDate(this.newDate("2006-08-02"));
        this.checkDate("start date Wednesday", cal, "2006-08-02");
        cal.setStartDate(this.newDate("2006-08-03"));
        this.checkDate("start date Thursday", cal, "2006-08-03");
        cal.setStartDate(this.newDate("2006-08-04"));
        this.checkDate("start date friday", cal, "2006-08-04");
        cal.setStartDate(this.newDate("2006-08-05"));
        this.checkDate("start date Saturday", cal, "2006-08-04");
        cal.setStartDate(this.newDate("2006-08-06"));
        this.checkDate("start date Sunday", cal, "2006-08-04");
    }

    public void testSimpleForwardStartDateNoWeekend() {
        DateCalculator cal = this.newDateCalculator("bla", "modifiedPreceding");
        WorkingWeek ww = new WorkingWeek().withWorkingDayFromCalendar(true, 7).withWorkingDayFromCalendar(true, 1);
        cal.setWorkingWeek(this.getWorkingWeek(ww));
        Assert.assertEquals((String)"Name", (String)"bla", (String)cal.getName());
        Assert.assertEquals((String)"Holidays size", (int)0, (int)cal.getHolidayCalendar().getHolidays().size());
        cal.setStartDate(this.newDate("2006-07-31"));
        this.checkDate("start date Monday", cal, "2006-07-31");
        cal.setStartDate(this.newDate("2006-08-01"));
        this.checkDate("start date Tuesday", cal, "2006-08-01");
        cal.setStartDate(this.newDate("2006-08-02"));
        this.checkDate("start date Wednesday", cal, "2006-08-02");
        cal.setStartDate(this.newDate("2006-08-03"));
        this.checkDate("start date Thursday", cal, "2006-08-03");
        cal.setStartDate(this.newDate("2006-08-04"));
        this.checkDate("start date friday", cal, "2006-08-04");
        cal.setStartDate(this.newDate("2006-08-05"));
        this.checkDate("start date Saturday", cal, "2006-08-05");
        cal.setStartDate(this.newDate("2006-08-06"));
        this.checkDate("start date Sunday", cal, "2006-08-06");
    }

    public void testSimpleForwardStartDateWhackyWeek() {
        DateCalculator cal = this.newDateCalculator("bla", "modifiedPreceding");
        Assert.assertEquals((String)"Name", (String)"bla", (String)cal.getName());
        Assert.assertEquals((String)"Holidays size", (int)0, (int)cal.getHolidayCalendar().getHolidays().size());
        WorkingWeek ww = new WorkingWeek().withWorkingDayFromCalendar(false, 2).withWorkingDayFromCalendar(true, 3).withWorkingDayFromCalendar(false, 4).withWorkingDayFromCalendar(true, 5).withWorkingDayFromCalendar(false, 6).withWorkingDayFromCalendar(true, 7).withWorkingDayFromCalendar(false, 1);
        cal.setWorkingWeek(this.getWorkingWeek(ww));
        cal.setStartDate(this.newDate("2006-07-31"));
        this.checkDate("start date Monday", cal, "2006-07-29");
        cal.setStartDate(this.newDate("2006-08-01"));
        this.checkDate("start date Tuesday", cal, "2006-08-01");
        cal.setStartDate(this.newDate("2006-08-02"));
        this.checkDate("start date Wednesday", cal, "2006-08-01");
        cal.setStartDate(this.newDate("2006-08-03"));
        this.checkDate("start date Thursday", cal, "2006-08-03");
        cal.setStartDate(this.newDate("2006-08-04"));
        this.checkDate("start date friday", cal, "2006-08-03");
        cal.setStartDate(this.newDate("2006-08-05"));
        this.checkDate("start date Saturday", cal, "2006-08-05");
        cal.setStartDate(this.newDate("2006-08-06"));
        this.checkDate("start date Sunday", cal, "2006-08-05");
    }

    public void testSimpleForwardStartDateIdealWeekend() {
        DateCalculator cal = this.newDateCalculator("bla", "modifiedPreceding");
        Assert.assertEquals((String)"Name", (String)"bla", (String)cal.getName());
        Assert.assertEquals((String)"Holidays size", (int)0, (int)cal.getHolidayCalendar().getHolidays().size());
        WorkingWeek ww = new WorkingWeek().withWorkingDayFromCalendar(false, 2).withWorkingDayFromCalendar(true, 3).withWorkingDayFromCalendar(true, 4).withWorkingDayFromCalendar(true, 5).withWorkingDayFromCalendar(true, 6).withWorkingDayFromCalendar(false, 7).withWorkingDayFromCalendar(false, 1);
        cal.setWorkingWeek(this.getWorkingWeek(ww));
        cal.setStartDate(this.newDate("2006-07-31"));
        this.checkDate("start date Monday", cal, "2006-07-28");
        cal.setStartDate(this.newDate("2006-08-01"));
        this.checkDate("start date Tuesday", cal, "2006-08-01");
        cal.setStartDate(this.newDate("2006-08-02"));
        this.checkDate("start date Wednesday", cal, "2006-08-02");
        cal.setStartDate(this.newDate("2006-08-03"));
        this.checkDate("start date Thursday", cal, "2006-08-03");
        cal.setStartDate(this.newDate("2006-08-04"));
        this.checkDate("start date friday", cal, "2006-08-04");
        cal.setStartDate(this.newDate("2006-08-05"));
        this.checkDate("start date Saturday", cal, "2006-08-04");
        cal.setStartDate(this.newDate("2006-08-06"));
        this.checkDate("start date Sunday", cal, "2006-08-04");
    }

    public void testSimpleForwardWithHolidays() {
        DateCalculator cal = this.newDateCalculator("bla", "modifiedPreceding");
        HolidayCalendar holidays = this.newHolidaysCalendar();
        Assert.assertEquals((String)"Name", (String)"bla", (String)cal.getName());
        cal.setHolidayCalendar(holidays);
        Assert.assertEquals((String)"Holidays", (Object)holidays.getHolidays(), (Object)cal.getHolidayCalendar().getHolidays());
        Assert.assertEquals((String)"Holidays size", (int)3, (int)cal.getHolidayCalendar().getHolidays().size());
        Assert.assertTrue((String)"contains", (boolean)holidays.isHoliday(this.newDate("2006-08-28")));
        Assert.assertTrue((String)"contains", (boolean)cal.getHolidayCalendar().isHoliday(this.newDate("2006-08-28")));
        cal.setStartDate(this.newDate("2006-08-28"));
        this.checkDate("Move given Bank Holiday", cal, "2006-08-25");
        cal.setStartDate(this.newDate("2006-12-24"));
        this.checkDate("Xmas Eve", cal, "2006-12-22");
        cal.setStartDate(this.newDate("2006-12-21"));
        this.checkDate("21/12 + 1", cal.moveByDays(1), "2006-12-22");
        cal.setStartDate(this.newDate("2006-12-21"));
        this.checkDate("21/12 + 1", cal.moveByDays(2), "2006-12-22");
        cal.setStartDate(this.newDate("2006-12-22"));
        this.checkDate("22/12 + 1", cal.moveByDays(1), "2006-12-22");
        cal.setStartDate(this.newDate("2006-12-23"));
        this.checkDate("23/12 + 1", cal.moveByDays(1), "2006-12-22");
    }

    public void testMoveByBusinessDays() {
        DateCalculator cal = this.newDateCalculator("bla", "modifiedPreceding");
        HolidayCalendar holidays = this.newHolidaysCalendar();
        Assert.assertEquals((String)"Name", (String)"bla", (String)cal.getName());
        cal.setHolidayCalendar(holidays);
        Assert.assertEquals((String)"Holidays", (Object)holidays.getHolidays(), (Object)cal.getHolidayCalendar().getHolidays());
        Assert.assertEquals((String)"Holidays size", (int)3, (int)cal.getHolidayCalendar().getHolidays().size());
        cal.setStartDate(this.newDate("2006-08-24"));
        try {
            cal.moveByBusinessDays(7);
            AbstractModifiedPreceedingDateCalculatorTest.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddAcrossMonth() {
        DateCalculator cal = this.newDateCalculator("bla", "modifiedPreceding");
        cal.setStartDate(this.newDate("2006-08-02"));
        cal.moveByDays(-1);
        this.checkDate("1/8", cal, "2006-08-01");
        cal.moveByDays(-1);
        this.checkDate("do move to next month", cal, "2006-07-31");
        cal.setStartDate(this.newDate("2006-08-02"));
        Set holidays = this.newHolidaysSet();
        holidays.clear();
        holidays.add(this.newDate("2006-08-01"));
        cal.setHolidayCalendar((HolidayCalendar)new DefaultHolidayCalendar(holidays));
        cal.moveByDays(-1);
        this.checkDate("do NOT move to next month", cal, "2006-08-02");
    }
}

