/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.common;

import java.util.Map;
import java.util.TreeMap;
import net.objectlab.kit.datecalc.common.AbstractDateTestCase;
import net.objectlab.kit.datecalc.common.DateCalculator;
import net.objectlab.kit.datecalc.common.HolidayCalendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPerformanceDateCalculatorTest<E>
extends AbstractDateTestCase<E> {
    private static final int REPEAT = 100000;
    private static final Map<String, String> RESULTS = new TreeMap<String, String>();

    public void testMoveByBusDate1Cal() {
        this.registerHolidays("UK", this.createUKHolidayCalendar());
        DateCalculator cal = this.newDateCalculator("UK", "forward");
        Object startDate = this.newDate("2006-08-01");
        cal.setStartDate(startDate);
        long start = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            cal.moveByBusinessDays(1);
            cal.getCurrentBusinessDate();
        }
        long stop = System.currentTimeMillis();
        this.keepResults("testMoveByBusDate", start, stop);
    }

    private void keepResults(String string, long start, long stop) {
        RESULTS.put(string + " " + ((Object)((Object)this)).getClass().getSimpleName(), "100000 = " + (stop - start) + " ms");
        System.out.println("\nPERFORMANCE\n");
        for (String str : RESULTS.keySet()) {
            System.out.println("+++++++ " + str + " " + RESULTS.get(str));
        }
    }

    public void testSetDateThenMoveByBusDate1Cal() {
        this.registerHolidays("UK", this.createUKHolidayCalendar());
        DateCalculator cal = this.newDateCalculator("UK", "forward");
        Object startDate = this.newDate("2006-08-01");
        long start = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            cal.setStartDate(startDate);
            cal.moveByBusinessDays(10);
            cal.getCurrentBusinessDate();
        }
        long stop = System.currentTimeMillis();
        this.keepResults("testSetDateThenMoveByBusDate", start, stop);
    }

    public void testMoveByBusDate2Calendars() {
        this.registerHolidays("UK", this.createUKHolidayCalendar());
        this.registerHolidays("US", this.createUSHolidayCalendar());
        DateCalculator cal1 = this.newDateCalculator("US", "forward");
        Object localDate = this.newDate("2006-08-08");
        cal1.setStartDate(localDate);
        DateCalculator cal2 = this.newDateCalculator("UK", "forward");
        Object startDate = this.newDate("2006-08-01");
        DateCalculator cal = cal1.combine(cal2);
        cal.setStartDate(startDate);
        long start = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            cal.moveByBusinessDays(1);
            cal.getCurrentBusinessDate();
        }
        long stop = System.currentTimeMillis();
        this.keepResults("testMoveByBusDate2Calendars", start, stop);
    }

    public void testCombineCalThenMoveByBusDate() {
        this.registerHolidays("UK", this.createUKHolidayCalendar());
        this.registerHolidays("US", this.createUSHolidayCalendar());
        DateCalculator cal1 = this.newDateCalculator("US", "forward");
        Object localDate = this.newDate("2006-08-08");
        cal1.setStartDate(localDate);
        DateCalculator cal2 = this.newDateCalculator("UK", "forward");
        Object startDate = this.newDate("2006-08-01");
        long start = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            DateCalculator cal = cal1.combine(cal2);
            cal.setStartDate(startDate);
            cal.moveByBusinessDays(10);
            cal.getCurrentBusinessDate();
        }
        long stop = System.currentTimeMillis();
        this.keepResults("testCombineCalThenMoveByBusDate", start, stop);
    }

    @Override
    protected HolidayCalendar<E> createUKHolidayCalendar() {
        HolidayCalendar cal = super.createUKHolidayCalendar();
        cal.setLateBoundary(this.newDate("10000-12-31"));
        return cal;
    }

    @Override
    protected HolidayCalendar<E> createUSHolidayCalendar() {
        HolidayCalendar cal = super.createUSHolidayCalendar();
        cal.setLateBoundary(this.newDate("10000-12-31"));
        return cal;
    }
}

