/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.common;

import java.util.HashSet;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.objectlab.kit.datecalc.common.StandardTenor;
import net.objectlab.kit.datecalc.common.Tenor;
import net.objectlab.kit.datecalc.common.TenorCode;

public class TenorTest
extends TestCase {
    public TenorTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return new TestSuite(TenorTest.class);
    }

    public void testValidTenors() {
        this.checkValidTenor("SP", false, TenorCode.SPOT, 0);
        this.checkValidTenor("ON", false, TenorCode.OVERNIGHT, 0);
        this.checkValidTenor("1D", true, TenorCode.DAY, 1);
        this.checkValidTenor("0D", true, TenorCode.DAY, 0);
        this.checkValidTenor("234D", true, TenorCode.DAY, 234);
        this.checkValidTenor("1M", true, TenorCode.MONTH, 1);
        this.checkValidTenor("0M", true, TenorCode.MONTH, 0);
        this.checkValidTenor("234M", true, TenorCode.MONTH, 234);
        this.checkValidTenor("1W", true, TenorCode.WEEK, 1);
        this.checkValidTenor("0W", true, TenorCode.WEEK, 0);
        this.checkValidTenor("234W", true, TenorCode.WEEK, 234);
        this.checkValidTenor("1Y", true, TenorCode.YEAR, 1);
        this.checkValidTenor("0Y", true, TenorCode.YEAR, 0);
        this.checkValidTenor("234Y", true, TenorCode.YEAR, 234);
    }

    public void testToString() {
        this.checkToString("SP");
        this.checkToString("ON");
        this.checkToString("1D");
        this.checkToString("1W");
        this.checkToString("1M");
        this.checkToString("2M");
        this.checkToString("234D");
        this.checkToString("1Y");
    }

    public void testHashcode() {
        HashSet<Tenor> set = new HashSet<Tenor>();
        set.add(StandardTenor.OVERNIGHT);
        set.add(StandardTenor.T_1D);
        set.add(StandardTenor.T_15Y);
        Assert.assertEquals((String)"size", (int)3, (int)set.size());
        Assert.assertTrue((String)("Contains " + StandardTenor.T_1D), (boolean)set.contains(StandardTenor.T_1D));
        Assert.assertTrue((String)("Contains " + StandardTenor.OVERNIGHT), (boolean)set.contains(StandardTenor.OVERNIGHT));
        Assert.assertTrue((String)("Contains " + StandardTenor.T_15Y), (boolean)set.contains(StandardTenor.T_15Y));
        Assert.assertEquals((String)"Equals ", (Object)StandardTenor.T_15Y, (Object)StandardTenor.T_15Y);
    }

    public void testEquals() {
        Assert.assertEquals((String)"Equals ", (Object)StandardTenor.T_15Y, (Object)StandardTenor.T_15Y);
        Assert.assertTrue((String)"same", (boolean)StandardTenor.OVERNIGHT.equals((Object)StandardTenor.OVERNIGHT));
        Assert.assertFalse((String)"not same", (boolean)StandardTenor.OVERNIGHT.equals((Object)StandardTenor.SPOT));
        Assert.assertFalse((String)"Different class", (boolean)StandardTenor.OVERNIGHT.equals((Object)"Hello"));
        Assert.assertFalse((String)"Null", (boolean)StandardTenor.OVERNIGHT.equals(null));
        Assert.assertTrue((String)"same", (boolean)StandardTenor.T_10Y.equals((Object)StandardTenor.T_10Y));
        Assert.assertFalse((String)"diff unit", (boolean)StandardTenor.T_10Y.equals((Object)StandardTenor.T_15Y));
        Assert.assertTrue((String)"same", (boolean)StandardTenor.T_10Y.equals((Object)new Tenor(10, TenorCode.YEAR)));
        Assert.assertFalse((String)"same", (boolean)new Tenor(10, null).equals((Object)new Tenor(10, TenorCode.YEAR)));
        Assert.assertTrue((String)"same", (boolean)new Tenor(10, null).equals((Object)new Tenor(10, null)));
    }

    public void testInvalidTenors() {
        this.checkInvalidTenor("GB");
        this.checkInvalidTenor("1SP");
        this.checkInvalidTenor("1IMM");
        this.checkInvalidTenor("IMMM");
        this.checkInvalidTenor("123SP");
        this.checkInvalidTenor("1SN");
        this.checkInvalidTenor("2SW");
        this.checkInvalidTenor("2SW55");
        this.checkInvalidTenor("3TN");
        this.checkInvalidTenor("3ON");
        this.checkInvalidTenor("D");
        this.checkInvalidTenor("M");
        this.checkInvalidTenor("W");
        this.checkInvalidTenor("Y");
    }

    private void checkToString(String string) {
        try {
            Tenor t = Tenor.valueOf((String)string);
            Assert.assertEquals((String)string, (String)t.toString());
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)e.toString());
        }
    }

    private void checkInvalidTenor(String str) {
        try {
            Tenor.valueOf((String)str);
            Assert.fail((String)(str + " is invalid and should have thrown an exception!"));
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    private Tenor checkValidTenor(String str, boolean acceptUnits, TenorCode tenorCode, int units) {
        Tenor tenor = null;
        try {
            tenor = Tenor.valueOf((String)str);
            Assert.assertEquals((String)(str + " Accept Units"), (boolean)acceptUnits, (boolean)tenor.getCode().acceptUnits());
            Assert.assertEquals((String)(str + " Accept Units"), (boolean)acceptUnits, (boolean)tenor.hasUnits());
            Assert.assertSame((String)(str + " right tenor "), (Object)tenorCode, (Object)tenor.getCode());
            Assert.assertEquals((String)(str + " Units"), (int)units, (int)tenor.getUnits());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            Assert.fail((String)("[" + str + "] should be valid!"));
        }
        return tenor;
    }
}

