/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.common;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import net.objectlab.kit.datecalc.common.Utils;

public class UtilsTest
extends TestCase {
    private SimpleDateFormat sdf;
    private Set<Calendar> calendarSet;
    private Set<Date> dateSet;

    protected void setUp() throws Exception {
        this.sdf = new SimpleDateFormat("yyyy-MM-dd");
        this.calendarSet = new HashSet<Calendar>();
        this.calendarSet.add(this.getCal(2004, 5, 31));
        this.calendarSet.add(this.getCal(2083, 12, 1));
        this.dateSet = new HashSet<Date>();
        this.dateSet.add(this.getCal(2004, 5, 31).getTime());
        this.dateSet.add(this.getCal(2083, 12, 1).getTime());
    }

    private Calendar getCal(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(year, month - 1, day, 0, 0, 0);
        return cal;
    }

    public void testGetCal() throws Exception {
        Date d = this.sdf.parse("2004-02-03");
        UtilsTest.assertEquals((Object)Utils.getCal((Date)d).getTime(), (Object)this.getCal(2004, 2, 3).getTime());
        Date d1 = this.getCal(2080, 5, 31).getTime();
        Date d2 = this.getCal(2080, 5, 31).getTime();
        UtilsTest.assertEquals((Object)Utils.getCal((Date)d1).getTime(), (Object)d2);
    }

    public void testCreateDate() throws Exception {
        UtilsTest.assertEquals((Object)this.getCal(1970, 1, 1).getTime(), (Object)Utils.createDate((String)"1970-01-01"));
        UtilsTest.assertEquals((Object)this.getCal(2020, 12, 31).getTime(), (Object)Utils.createDate((String)"2020-12-31"));
        UtilsTest.assertEquals((Object)this.getCal(2006, 8, 8).getTime(), (Object)Utils.createDate((String)"2006-08-08"));
        UtilsTest.assertEquals((Object)this.getCal(2004, 9, 12).getTime(), (Object)Utils.createDate((String)"2004-09-12"));
    }

    public void testToCalendarSet() throws Exception {
        UtilsTest.assertEquals(this.calendarSet, (Object)Utils.toCalendarSet(this.dateSet));
    }

    public void testToDateSet() {
        UtilsTest.assertEquals(this.dateSet, (Object)Utils.toDateSet(this.calendarSet));
    }

    public void testToDateList() {
        ArrayList<Date> expected = new ArrayList<Date>(this.dateSet);
        Collections.sort(expected);
        List actual = Utils.toDateList(new ArrayList<Calendar>(this.calendarSet));
        Collections.sort(actual);
        UtilsTest.assertEquals(expected, (Object)actual);
    }

    public void testFailCreateDate() {
        try {
            Utils.createDate((String)"blablabla");
            UtilsTest.fail((String)"should have thown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testFailCreateCalendar() {
        try {
            Utils.createCalendar((String)"blablabla");
            UtilsTest.fail((String)"should have thown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

