/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.common;

import java.util.Calendar;
import java.util.Date;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.objectlab.kit.datecalc.common.WorkingWeek;

public class WorkingWeekTest
extends TestCase {
    public void testIsWorkingDayFromCalendar() {
        WorkingWeek ww = new WorkingWeek();
        Assert.assertTrue((String)"Calendar.MONDAY", (boolean)ww.isWorkingDayFromCalendar(2));
        Assert.assertTrue((String)"Calendar.TUESDAY", (boolean)ww.isWorkingDayFromCalendar(3));
        Assert.assertTrue((String)"Calendar.WEDNESDAY", (boolean)ww.isWorkingDayFromCalendar(4));
        Assert.assertTrue((String)"Calendar.THURSDAY", (boolean)ww.isWorkingDayFromCalendar(5));
        Assert.assertTrue((String)"Calendar.FRIDAY", (boolean)ww.isWorkingDayFromCalendar(6));
        Assert.assertFalse((String)"Calendar.SATURDAY", (boolean)ww.isWorkingDayFromCalendar(7));
        Assert.assertFalse((String)"Calendar.SUNDAY", (boolean)ww.isWorkingDayFromCalendar(1));
    }

    public void testIsWorkingDay() {
        WorkingWeek ww = new WorkingWeek();
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        cal.set(2, 7);
        cal.set(1, 2006);
        Date date = cal.getTime();
        Assert.assertTrue((String)"Calendar.TUESDAY", (boolean)ww.isWorkingDay(date));
        cal.add(5, 1);
        date = cal.getTime();
        Assert.assertTrue((String)"Calendar.WEDNESDAY", (boolean)ww.isWorkingDay(date));
        cal.add(5, 1);
        date = cal.getTime();
        Assert.assertTrue((String)"Calendar.THURSDAY", (boolean)ww.isWorkingDay(date));
        cal.add(5, 1);
        date = cal.getTime();
        Assert.assertTrue((String)"Calendar.FRIDAY", (boolean)ww.isWorkingDay(date));
        cal.add(5, 1);
        date = cal.getTime();
        Assert.assertFalse((String)"Calendar.SATURDAY", (boolean)ww.isWorkingDay(date));
        cal.add(5, 1);
        date = cal.getTime();
        Assert.assertFalse((String)"Calendar.SUNDAY", (boolean)ww.isWorkingDay(date));
        cal.add(5, 1);
        date = cal.getTime();
        Assert.assertTrue((String)"Calendar.MONDAY", (boolean)ww.isWorkingDay(date));
    }

    public void testSetWorkingDayFromCalendar() {
        WorkingWeek ww = new WorkingWeek();
        ww = ww.withWorkingDayFromCalendar(true, 1);
        ww = ww.withWorkingDayFromCalendar(true, 1);
        Assert.assertTrue((String)"Calendar.MONDAY", (boolean)ww.isWorkingDayFromCalendar(2));
        Assert.assertTrue((String)"Calendar.TUESDAY", (boolean)ww.isWorkingDayFromCalendar(3));
        Assert.assertTrue((String)"Calendar.WEDNESDAY", (boolean)ww.isWorkingDayFromCalendar(4));
        Assert.assertTrue((String)"Calendar.THURSDAY", (boolean)ww.isWorkingDayFromCalendar(5));
        Assert.assertTrue((String)"Calendar.FRIDAY", (boolean)ww.isWorkingDayFromCalendar(6));
        Assert.assertFalse((String)"Calendar.SATURDAY", (boolean)ww.isWorkingDayFromCalendar(7));
        Assert.assertTrue((String)"Calendar.SUNDAY", (boolean)ww.isWorkingDayFromCalendar(1));
        ww = ww.withWorkingDayFromCalendar(false, 1);
        Assert.assertTrue((String)"Calendar.MONDAY", (boolean)ww.isWorkingDayFromCalendar(2));
        Assert.assertTrue((String)"Calendar.TUESDAY", (boolean)ww.isWorkingDayFromCalendar(3));
        Assert.assertTrue((String)"Calendar.WEDNESDAY", (boolean)ww.isWorkingDayFromCalendar(4));
        Assert.assertTrue((String)"Calendar.THURSDAY", (boolean)ww.isWorkingDayFromCalendar(5));
        Assert.assertTrue((String)"Calendar.FRIDAY", (boolean)ww.isWorkingDayFromCalendar(6));
        Assert.assertFalse((String)"Calendar.SATURDAY", (boolean)ww.isWorkingDayFromCalendar(7));
        Assert.assertFalse((String)"Calendar.SUNDAY", (boolean)ww.isWorkingDayFromCalendar(1));
        ww = ww.withWorkingDayFromCalendar(true, 1);
    }
}

