/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jelly.apt;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.apt.AnnotationProcessors;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.sf.jelly.apt.Context;
import net.sf.jelly.apt.decorations.DeclarationDecorator;
import net.sf.jelly.apt.decorations.DecoratedAnnotationProcessorEnvironment;
import net.sf.jelly.apt.decorations.TypeMirrorDecorator;
import net.sf.jelly.apt.util.JavaDocTagHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProcessorFactory
implements AnnotationProcessorFactory {
    public static final String TEMPLATE_FILE_OPTION = "-Atemplate";
    public static final String TEMPLATE_URL_OPTION = "-AtemplateURL";
    public static final String DECLARATION_DECORATOR_OPTION = "-A" + DeclarationDecorator.class.getName();
    public static final String TYPE_DECORATOR_OPTION = "-A" + TypeMirrorDecorator.class.getName();
    public static final String JAVADOC_TAG_HANDLER_OPTION = "-A" + JavaDocTagHandler.class.getName();
    private static final Collection<String> SUPPORTED_OPTIONS = Collections.unmodifiableCollection(Arrays.asList("-Atemplate", "-AtemplateURL", DECLARATION_DECORATOR_OPTION, TYPE_DECORATOR_OPTION, JAVADOC_TAG_HANDLER_OPTION));
    protected static int round = 0;
    protected URL template;

    protected ProcessorFactory() {
        this.template = null;
    }

    protected ProcessorFactory(URL template) {
        this.template = template;
    }

    public Collection<String> supportedOptions() {
        return SUPPORTED_OPTIONS;
    }

    public Collection<String> supportedAnnotationTypes() {
        return Collections.unmodifiableCollection(Arrays.asList("*"));
    }

    public AnnotationProcessor getProcessorFor(Set<AnnotationTypeDeclaration> set, AnnotationProcessorEnvironment env) {
        if (++round > 1) {
            return AnnotationProcessors.NO_OP;
        }
        AnnotationProcessorEnvironment ape = this.decorateEnvironment(env);
        if (ape.getOptions().containsKey(DECLARATION_DECORATOR_OPTION)) {
            System.setProperty(DeclarationDecorator.class.getName(), (String)ape.getOptions().get(DECLARATION_DECORATOR_OPTION));
        }
        if (ape.getOptions().containsKey(TYPE_DECORATOR_OPTION)) {
            System.setProperty(TypeMirrorDecorator.class.getName(), (String)ape.getOptions().get(TYPE_DECORATOR_OPTION));
        }
        Context.setCurrentEnvironment(ape);
        return this.getProcessorFor(set);
    }

    protected AnnotationProcessor getProcessorFor(Set<AnnotationTypeDeclaration> annotations) {
        URL url = this.getTemplateURL();
        if (url == null) {
            throw new IllegalArgumentException(String.format("A valid template option (%s or %s) must be set.", TEMPLATE_FILE_OPTION, TEMPLATE_URL_OPTION));
        }
        return this.newProcessor(url);
    }

    protected AnnotationProcessorEnvironment decorateEnvironment(AnnotationProcessorEnvironment env) {
        return new DecoratedAnnotationProcessorEnvironment(env);
    }

    protected URL getTemplateURL() {
        String urlOption;
        AnnotationProcessorEnvironment env = Context.getCurrentEnvironment();
        Map options = env.getOptions();
        String fileOption = (String)options.get(TEMPLATE_FILE_OPTION);
        URL url = this.template;
        if (url == null && fileOption != null) {
            try {
                url = new File(fileOption).toURL();
            }
            catch (MalformedURLException e) {
                env.getMessager().printError("Bad file: " + fileOption);
            }
        }
        if (url == null && (urlOption = (String)options.get(TEMPLATE_URL_OPTION)) != null) {
            try {
                url = new URL(urlOption);
            }
            catch (MalformedURLException e) {
                env.getMessager().printError("Bad url: " + urlOption);
            }
        }
        return url;
    }

    protected abstract AnnotationProcessor newProcessor(URL var1);
}

