/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jelly.apt.decorations.declaration;

import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.PackageDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.declaration.TypeParameterDeclaration;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.util.DeclarationVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.sf.jelly.apt.decorations.DeclarationDecorator;
import net.sf.jelly.apt.decorations.TypeMirrorDecorator;
import net.sf.jelly.apt.decorations.declaration.DecoratedMemberDeclaration;
import net.sf.jelly.apt.decorations.declaration.DecoratedMethodDeclaration;
import net.sf.jelly.apt.decorations.declaration.PropertyDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoratedTypeDeclaration
extends DecoratedMemberDeclaration
implements TypeDeclaration {
    public DecoratedTypeDeclaration(TypeDeclaration delegate) {
        super((MemberDeclaration)delegate);
    }

    public PackageDeclaration getPackage() {
        return DeclarationDecorator.decorate(((TypeDeclaration)this.delegate).getPackage());
    }

    public String getQualifiedName() {
        return ((TypeDeclaration)this.delegate).getQualifiedName();
    }

    public Collection<TypeParameterDeclaration> getFormalTypeParameters() {
        return DeclarationDecorator.decorate(((TypeDeclaration)this.delegate).getFormalTypeParameters());
    }

    public Collection<InterfaceType> getSuperinterfaces() {
        return TypeMirrorDecorator.decorate(((TypeDeclaration)this.delegate).getSuperinterfaces());
    }

    public Collection<FieldDeclaration> getFields() {
        return DeclarationDecorator.decorate(((TypeDeclaration)this.delegate).getFields());
    }

    public Collection<TypeDeclaration> getNestedTypes() {
        return DeclarationDecorator.decorate(((TypeDeclaration)this.delegate).getNestedTypes());
    }

    public Collection<? extends MethodDeclaration> getMethods() {
        return DeclarationDecorator.decorate(((TypeDeclaration)this.delegate).getMethods());
    }

    public Collection<PropertyDeclaration> getProperties() {
        HashMap<String, DecoratedMethodDeclaration> getters = new HashMap<String, DecoratedMethodDeclaration>();
        HashMap setters = new HashMap();
        for (MethodDeclaration methodDeclaration : this.getMethods()) {
            DecoratedMethodDeclaration decoratedMethod = (DecoratedMethodDeclaration)methodDeclaration;
            if (!decoratedMethod.isPublic() || !decoratedMethod.isGetter() && !decoratedMethod.isSetter()) continue;
            HashMap<String, DecoratedMethodDeclaration> methodMap = decoratedMethod.isGetter() ? getters : setters;
            methodMap.put(decoratedMethod.getPropertyName(), decoratedMethod);
        }
        ArrayList<PropertyDeclaration> properties = new ArrayList<PropertyDeclaration>(getters.size());
        for (String propertyName : getters.keySet()) {
            DecoratedMethodDeclaration setter;
            DecoratedMethodDeclaration getter = (DecoratedMethodDeclaration)getters.get(propertyName);
            if (!this.isPaired(getter, setter = (DecoratedMethodDeclaration)setters.get(propertyName))) continue;
            properties.add(new PropertyDeclaration(getter, setter));
        }
        return properties;
    }

    protected boolean isPaired(DecoratedMethodDeclaration getter, DecoratedMethodDeclaration setter) {
        if (getter == null) {
            return false;
        }
        if (!getter.isGetter()) {
            return false;
        }
        if (getter.getParameters().size() != 0) {
            return false;
        }
        if (setter != null) {
            if (!setter.isSetter()) {
                return false;
            }
            if (!getter.getPropertyName().equals(setter.getPropertyName())) {
                return false;
            }
            Collection<ParameterDeclaration> setterParams = setter.getParameters();
            if (setterParams == null || setterParams.size() != 1 || !getter.getReturnType().equals(setterParams.iterator().next().getType())) {
                return false;
            }
        }
        return true;
    }

    public boolean isClass() {
        return false;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public boolean isAnnotatedType() {
        return false;
    }

    @Override
    public void accept(DeclarationVisitor v) {
        v.visitTypeDeclaration((TypeDeclaration)this);
    }
}

