/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jelly.apt.strategies;

import com.sun.mirror.declaration.ExecutableDeclaration;
import com.sun.mirror.type.ReferenceType;
import java.util.Collection;
import java.util.Iterator;
import net.sf.jelly.apt.TemplateBlock;
import net.sf.jelly.apt.TemplateException;
import net.sf.jelly.apt.TemplateModel;
import net.sf.jelly.apt.strategies.ExecutableDeclarationLoopStrategy;
import net.sf.jelly.apt.strategies.MissingParameterException;
import net.sf.jelly.apt.strategies.StrategyStack;
import net.sf.jelly.apt.strategies.TemplateLoopStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrownTypeLoopStrategy<B extends TemplateBlock>
extends TemplateLoopStrategy<ReferenceType, B> {
    private String var;
    private String indexVar;
    private ExecutableDeclaration declaration;

    @Override
    protected Iterator<ReferenceType> getLoop(TemplateModel model) throws TemplateException {
        return this.getThrownTypes().iterator();
    }

    @Override
    protected void setupModelForLoop(TemplateModel model, ReferenceType thrownType, int index) throws TemplateException {
        super.setupModelForLoop(model, thrownType, index);
        if (this.indexVar != null) {
            model.setVariable(this.indexVar, index);
        }
        if (this.var != null) {
            model.setVariable(this.var, thrownType);
        }
    }

    protected Collection<ReferenceType> getThrownTypes() throws MissingParameterException {
        ExecutableDeclaration declaration = this.getDeclaration();
        if (declaration == null && (declaration = this.getCurrentExecutableDeclaration()) == null) {
            throw new MissingParameterException("declaration");
        }
        return declaration.getThrownTypes();
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getIndexVar() {
        return this.indexVar;
    }

    public void setIndexVar(String indexVar) {
        this.indexVar = indexVar;
    }

    public ExecutableDeclaration getDeclaration() {
        return this.declaration;
    }

    public void setDeclaration(ExecutableDeclaration declaration) {
        this.declaration = declaration;
    }

    protected ExecutableDeclaration getCurrentExecutableDeclaration() {
        ExecutableDeclarationLoopStrategy loop = StrategyStack.get().findFirst(ExecutableDeclarationLoopStrategy.class);
        if (loop != null) {
            return loop.getCurrentDeclaration();
        }
        return null;
    }
}

