/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.xml;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.sf.jstuff.core.io.MoreFiles;
import net.sf.jstuff.core.logging.Logger;
import net.sf.jstuff.core.reflection.StackTrace;
import net.sf.jstuff.core.validation.Args;
import net.sf.jstuff.core.validation.Assert;
import net.sf.jstuff.xml.DOMUtils;
import net.sf.jstuff.xml.XMLException;
import org.eclipse.jdt.annotation.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXParseException;

public class DOMFile {
    private static final Logger LOG = Logger.create();
    private final Document domDocument;
    private final Element domRoot;
    private final File xmlFile;

    public DOMFile(Document doc, File targetFile) {
        Args.notNull((String)"doc", (Object)doc);
        Args.notNull((String)"targetFile", (Object)targetFile);
        this.domDocument = doc;
        this.domRoot = doc.getDocumentElement();
        this.xmlFile = targetFile;
    }

    public DOMFile(File xmlFile) throws IOException, XMLException {
        this(xmlFile, (String)null, (File[])null);
    }

    public DOMFile(File xmlFile, File ... xmlSchemaFiles) throws IOException, XMLException {
        this(xmlFile, (String)null, xmlSchemaFiles);
    }

    public DOMFile(File xmlFile, @Nullable String rootNamespace) throws IOException, XMLException {
        this(xmlFile, rootNamespace, null);
    }

    public DOMFile(File xmlFile, @Nullable String rootNamespace, File ... xmlSchemaFiles) throws IOException, XMLException {
        Args.notNull((String)"xmlFile", (Object)xmlFile);
        Assert.isFileReadable((File)xmlFile);
        this.xmlFile = xmlFile;
        try {
            this.domDocument = DOMUtils.parseFile(xmlFile, rootNamespace, xmlSchemaFiles);
        }
        catch (XMLException ex) {
            if (ex.getCause() instanceof SAXParseException) {
                LOG.debug("Failed to parse file %s with content:\n%s", (Object)ex, (Object)xmlFile.getAbsolutePath(), (Object)MoreFiles.readAsString((Path)xmlFile.toPath()));
            }
            throw ex;
        }
        this.domRoot = this.domDocument.getDocumentElement();
    }

    private void assertNodeBelongsToDocument(String argumentName, Node node) {
        if (DOMUtils._getOwnerDocument(node) != this.domDocument) {
            IllegalArgumentException ex = new IllegalArgumentException("[" + argumentName + "] belongs to another DOM document!");
            StackTrace.removeFirstStackTraceElement((Throwable)ex);
            throw ex;
        }
    }

    public Comment createCommentBefore(Node sibling, String commentString) {
        Args.notNull((String)"sibling", (Object)sibling);
        this.assertNodeBelongsToDocument("sibling", sibling);
        return DOMUtils.createCommentBefore(sibling, commentString);
    }

    public Element createElement(Node parent, String xmlTagName) {
        Args.notNull((String)"parent", (Object)parent);
        this.assertNodeBelongsToDocument("parent", parent);
        return DOMUtils.createElement(parent, xmlTagName);
    }

    public Element createElement(Node parent, String tagName, @Nullable Map<String, String> tagAttributes) {
        Args.notNull((String)"parent", (Object)parent);
        this.assertNodeBelongsToDocument("parent", parent);
        return DOMUtils.createElement(parent, tagName, tagAttributes);
    }

    public Element createElementBefore(Node sibling, String tagName) {
        Args.notNull((String)"sibling", (Object)sibling);
        this.assertNodeBelongsToDocument("sibling", sibling);
        return DOMUtils.createElementBefore(sibling, tagName);
    }

    public Element createElementBefore(Node sibling, String tagName, @Nullable Map<String, String> tagAttributes) {
        Args.notNull((String)"sibling", (Object)sibling);
        this.assertNodeBelongsToDocument("sibling", sibling);
        return DOMUtils.createElementBefore(sibling, tagName, tagAttributes);
    }

    public Element createElementWithText(Node parent, String tagName, @Nullable Map<String, String> tagAttributes, Object text) {
        Element elem = this.createElement(parent, tagName, tagAttributes);
        this.createTextNode(elem, text);
        return elem;
    }

    public Element createElementWithText(Node parent, String tagName, Object text) {
        Element elem = this.createElement(parent, tagName, null);
        this.createTextNode(elem, text);
        return elem;
    }

    public Element createElementWithTextBefore(Node sibling, String tagName, @Nullable Map<String, String> tagAttributes, Object text) {
        Element elem = this.createElementBefore(sibling, tagName, tagAttributes);
        this.createTextNode(elem, text);
        return elem;
    }

    public Element createElementWithTextBefore(Node sibling, String tagName, Object text) {
        Element elem = this.createElementBefore(sibling, tagName, null);
        this.createTextNode(elem, text);
        return elem;
    }

    public Text createTextNode(Node parent, Object text) {
        Args.notNull((String)"parent", (Object)parent);
        this.assertNodeBelongsToDocument("parent", parent);
        return DOMUtils.createTextNode(parent, text);
    }

    public Text createTextNodeBefore(Node sibling, Object text) {
        Args.notNull((String)"sibling", (Object)sibling);
        this.assertNodeBelongsToDocument("sibling", sibling);
        return DOMUtils.createTextNodeBefore(sibling, text);
    }

    public Boolean evaluateAsBoolean(Node searchScope, String xPathExpression) throws XMLException {
        Args.notNull((String)"searchScope", (Object)searchScope);
        this.assertNodeBelongsToDocument("parent", searchScope);
        return DOMUtils.evaluateAsBoolean(searchScope, xPathExpression);
    }

    public Boolean evaluateAsBoolean(String xPathExpression) throws XMLException {
        return DOMUtils.evaluateAsBoolean(this.domRoot, xPathExpression);
    }

    public Node evaluateAsNode(Node searchScope, String xPathExpression) throws XMLException {
        Args.notNull((String)"searchScope", (Object)searchScope);
        this.assertNodeBelongsToDocument("parent", searchScope);
        return DOMUtils.evaluateAsNode(searchScope, xPathExpression);
    }

    public Node evaluateAsNode(String xPathExpression) throws XMLException {
        return DOMUtils.evaluateAsNode(this.domRoot, xPathExpression);
    }

    public <T extends Node> List<T> evaluateAsNodes(Node searchScope, String xPathExpression) throws XMLException {
        Args.notNull((String)"searchScope", (Object)searchScope);
        this.assertNodeBelongsToDocument("parent", searchScope);
        return DOMUtils.evaluateAsNodes(searchScope, xPathExpression);
    }

    public <T extends Node> List<T> evaluateAsNodes(String xPathExpression) throws XMLException {
        return DOMUtils.evaluateAsNodes(this.domRoot, xPathExpression);
    }

    public Number evaluateAsNumber(Node searchScope, String xPathExpression) throws XMLException {
        Args.notNull((String)"searchScope", (Object)searchScope);
        this.assertNodeBelongsToDocument("parent", searchScope);
        return DOMUtils.evaluateAsNumber(searchScope, xPathExpression);
    }

    public Number evaluateAsNumber(String xPathExpression) throws XMLException {
        return DOMUtils.evaluateAsNumber(this.domRoot, xPathExpression);
    }

    public String evaluateAsString(Node searchScope, String xPathExpression) throws XMLException {
        Args.notNull((String)"searchScope", (Object)searchScope);
        this.assertNodeBelongsToDocument("parent", searchScope);
        return DOMUtils.evaluateAsString(searchScope, xPathExpression);
    }

    public String evaluateAsString(String xPathExpression) throws XMLException {
        return DOMUtils.evaluateAsString(this.domRoot, xPathExpression);
    }

    public <T extends Node> @Nullable T findNode(Node searchScope, String xPathExpression) throws XMLException {
        Args.notNull((String)"searchScope", (Object)searchScope);
        this.assertNodeBelongsToDocument("parent", searchScope);
        return DOMUtils.findNode(searchScope, xPathExpression);
    }

    public <T extends Node> @Nullable T findNode(String xPathExpression) throws XMLException {
        return this.findNode(this.domRoot, xPathExpression);
    }

    public <T extends Node> List<T> findNodes(String xPathExpression) throws XMLException {
        return DOMUtils.findNodes(this.domRoot, xPathExpression);
    }

    public <T extends Node> List<T> findNodes(String xPathExpression, Node searchScope) throws XMLException {
        Args.notNull((String)"searchScope", (Object)searchScope);
        this.assertNodeBelongsToDocument("parent", searchScope);
        return DOMUtils.findNodes(searchScope, xPathExpression);
    }

    public @Nullable String findTextContent(Node searchScope, String xPathExpression, boolean recursive) throws XMLException {
        Args.notNull((String)"searchScope", (Object)searchScope);
        this.assertNodeBelongsToDocument("parent", searchScope);
        return DOMUtils.findTextContent(searchScope, xPathExpression, recursive);
    }

    public @Nullable String findTextContent(String xPathExpression, boolean recursive) throws XMLException {
        return DOMUtils.findTextContent(this.domRoot, xPathExpression, recursive);
    }

    public List<Attr> getAttributes(Node node) {
        Args.notNull((String)"node", (Object)node);
        this.assertNodeBelongsToDocument("node", node);
        return DOMUtils.getAttributes(node);
    }

    public List<Node> getChildNodes(Node parent) {
        Args.notNull((String)"parent", (Object)parent);
        this.assertNodeBelongsToDocument("parent", parent);
        return DOMUtils.getChildNodes(parent);
    }

    public Document getDOMDocument() {
        return this.domDocument;
    }

    public Element getDOMRoot() {
        return this.domRoot;
    }

    public <T extends Node> List<T> getElementsByTagName(Element parent, String tagName) {
        Args.notNull((String)"parent", (Object)parent);
        this.assertNodeBelongsToDocument("parent", parent);
        return DOMUtils.getElementsByTagName(parent, tagName);
    }

    public File getFile() {
        return this.xmlFile;
    }

    public String getFilePath() {
        return this.xmlFile.getAbsolutePath();
    }

    public @Nullable Node getFirstChild(Node parent) {
        Args.notNull((String)"parent", (Object)parent);
        this.assertNodeBelongsToDocument("parent", parent);
        return DOMUtils.getFirstChild(parent);
    }

    public List<Attr> getIdAttributes(Node node) {
        Args.notNull((String)"node", (Object)node);
        this.assertNodeBelongsToDocument("parent", node);
        return DOMUtils.getIdAttributes(node);
    }

    public <T extends Node> T importNode(Node parent, T nodeToImport) {
        Args.notNull((String)"parent", (Object)parent);
        this.assertNodeBelongsToDocument("parent", parent);
        return DOMUtils.importNode(parent, nodeToImport);
    }

    public <T extends Node> T importNodeBefore(Node sibling, T nodeToImport) {
        Args.notNull((String)"sibling", (Object)sibling);
        this.assertNodeBelongsToDocument("sibling", sibling);
        return DOMUtils.importNodeBefore(sibling, nodeToImport);
    }

    public <T extends Node> List<T> importNodes(Node parent, Collection<T> nodesToImport) {
        Args.notNull((String)"parent", (Object)parent);
        this.assertNodeBelongsToDocument("parent", parent);
        return DOMUtils.importNodes(parent, nodesToImport);
    }

    public <T extends Node> List<T> importNodes(Node parent, NodeList nodesToImport) {
        Args.notNull((String)"parent", (Object)parent);
        this.assertNodeBelongsToDocument("parent", parent);
        return DOMUtils.importNodes(parent, nodesToImport);
    }

    public <T extends Node> List<T> importNodesBefore(Node sibling, Collection<T> nodesToImport) {
        Args.notNull((String)"sibling", (Object)sibling);
        this.assertNodeBelongsToDocument("sibling", sibling);
        return DOMUtils.importNodesBefore(sibling, nodesToImport);
    }

    public <T extends Node> List<T> importNodesBefore(Node sibling, NodeList nodesToImport) {
        Args.notNull((String)"sibling", (Object)sibling);
        this.assertNodeBelongsToDocument("sibling", sibling);
        return DOMUtils.importNodesBefore(sibling, nodesToImport);
    }

    public boolean removeNode(Node node) throws DOMException {
        Args.notNull((String)"node", (Object)node);
        this.assertNodeBelongsToDocument("node", node);
        return DOMUtils.removeNode(node);
    }

    public List<Node> removeNodes(Node searchScope, String xPathExpression) throws XMLException {
        Args.notNull((String)"searchScope", (Object)searchScope);
        this.assertNodeBelongsToDocument("searchScope", searchScope);
        return DOMUtils.removeNodes(searchScope, xPathExpression);
    }

    public List<Node> removeNodes(String xPathExpression) throws XMLException {
        return this.removeNodes(this.domRoot, xPathExpression);
    }

    public void removeWhiteSpaceNodes() {
        this.removeWhiteSpaceNodes(this.domRoot);
    }

    public void removeWhiteSpaceNodes(Node searchScope) {
        Args.notNull((String)"searchScope", (Object)searchScope);
        Assert.isTrue((DOMUtils._getOwnerDocument(searchScope) == this.domDocument ? 1 : 0) != 0, (String)"[searchScope] belongs to another DOM document!");
        DOMUtils.removeWhiteSpaceNodes(searchScope);
    }

    public void save() throws IOException, XMLException {
        DOMUtils.saveToFile(this.domDocument, this.xmlFile);
    }

    public void saveAs(File file) throws IOException, XMLException {
        Args.notNull((String)"file", (Object)file);
        DOMUtils.saveToFile(this.domDocument, file);
    }

    public void saveAs(String filePath) throws IOException, XMLException {
        Args.notNull((String)"filePath", (Object)filePath);
        DOMUtils.saveToFile(this.domDocument, new File(filePath));
    }

    public void sortChildNodes(Node parent, Comparator<Node> comparator) {
        Args.notNull((String)"parent", (Object)parent);
        this.assertNodeBelongsToDocument("parent", parent);
        DOMUtils.sortChildNodes(parent, comparator);
    }

    public void sortChildNodesByAttributes(Node parent, boolean ascending, String ... attributeNames) {
        Args.notNull((String)"parent", (Object)parent);
        this.assertNodeBelongsToDocument("parent", parent);
        DOMUtils.sortChildNodesByAttributes(parent, ascending, attributeNames);
    }

    public String toXML() {
        return DOMUtils.toXML(this.domDocument, true, true);
    }

    public String toXML(boolean outputXMLDeclaration, boolean formatPretty) {
        return DOMUtils.toXML(this.domDocument, outputXMLDeclaration, formatPretty);
    }
}

