/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.jstuff.core.Strings;
import net.sf.jstuff.core.collection.CollectionUtils;
import net.sf.jstuff.core.collection.MapWithLists;
import net.sf.jstuff.core.comparator.StringComparator;
import net.sf.jstuff.core.io.CharSequenceReader;
import net.sf.jstuff.core.io.MoreFiles;
import net.sf.jstuff.core.io.stream.FastByteArrayOutputStream;
import net.sf.jstuff.core.logging.Logger;
import net.sf.jstuff.core.reflection.Types;
import net.sf.jstuff.core.validation.Args;
import net.sf.jstuff.core.validation.Assert;
import net.sf.jstuff.core.validation.NullAnalysisHelper;
import net.sf.jstuff.xml.MapBasedNamespaceContext;
import net.sf.jstuff.xml.XMLException;
import org.eclipse.jdt.annotation.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class DOMUtils {
    private static final Logger LOG = Logger.create();
    protected static final MapBasedNamespaceContext NAMESPACE_CONTEXT = new MapBasedNamespaceContext();
    private static final EntityResolver NOREMOTE_DTD_RESOLVER = new EntityResolver(){
        private final Logger log = Logger.create();

        @Override
        public @Nullable InputSource resolveEntity(@Nullable String schemaId, @Nullable String schemaLocation) throws SAXException, IOException {
            if (schemaLocation != null && !schemaLocation.startsWith("file://")) {
                this.log.debug("Ignoring DTD [%s] [%s]", (Object)schemaId, (Object)schemaLocation);
                return new InputSource(new StringReader(""));
            }
            return null;
        }
    };
    protected static final ThreadLocal<TransformerFactory> TRANSFORMER_FACTORY = ThreadLocal.withInitial(() -> {
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        return factory;
    });
    protected static final ThreadLocal<XPath> XPATH = ThreadLocal.withInitial(() -> {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(NAMESPACE_CONTEXT);
        return xpath;
    });

    private static List<Attr> _getIdAttributes(Element elem, XPathNodeConfiguration cfg) {
        Attr attr;
        NamedNodeMap nodeMap = elem.getAttributes();
        ArrayList result = CollectionUtils.newArrayList((int)nodeMap.getLength());
        if (cfg.useSchemaIdAttributes) {
            int i = 0;
            int l = nodeMap.getLength();
            while (i < l) {
                attr = (Attr)nodeMap.item(i);
                if (attr.isId()) {
                    result.add(attr);
                }
                ++i;
            }
        }
        if (result.isEmpty() && cfg.idAttributesByXMLTagName.size() > 0) {
            for (String idAttrName : cfg.getIdAttributesForXMLTagName(elem.getTagName())) {
                attr = elem.getAttributeNode(idAttrName);
                if (attr == null) continue;
                result.add(attr);
                break;
            }
            if (result.isEmpty()) {
                for (String idAttrName : cfg.getIdAttributesForXMLTagName("*")) {
                    attr = elem.getAttributeNode(idAttrName);
                    if (attr == null) continue;
                    result.add(attr);
                    break;
                }
            }
        }
        return result;
    }

    static Document _getOwnerDocument(Node node) {
        Document doc = node.getOwnerDocument();
        if (doc == null && node instanceof Document) {
            return (Document)node;
        }
        if (doc == null) {
            throw new IllegalArgumentException("Node " + node + " has no owner document!");
        }
        return doc;
    }

    private static void _getXPathNodes(Element elem, XPathNodeConfiguration cfg, CharSequence parentXPath, Map<String, XPathNode> valuesByXPath) {
        StringBuilder xPath = new StringBuilder(parentXPath);
        xPath.append('/');
        xPath.append(elem.getTagName());
        List<Attr> attrs = DOMUtils._getIdAttributes(elem, cfg);
        if (!attrs.isEmpty()) {
            xPath.append('[');
            boolean isFirst = true;
            for (Attr attr : DOMUtils._getIdAttributes(elem, cfg)) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    xPath.append(" and ");
                }
                xPath.append('@');
                xPath.append(attr.getName());
                xPath.append("='");
                xPath.append(attr.getValue());
                xPath.append('\'');
            }
            xPath.append(']');
        }
        for (Attr attr : DOMUtils.getAttributes(elem)) {
            String attrXPath = xPath + "/@" + attr.getName();
            valuesByXPath.put(attrXPath, new XPathNode(attr.getName(), attr.getValue(), attrXPath));
        }
        boolean foundTextNode = false;
        for (Node node : DOMUtils.nodeListToList(elem.getChildNodes())) {
            if (cfg.recursive && node instanceof Element) {
                DOMUtils._getXPathNodes((Element)node, cfg, xPath, valuesByXPath);
                continue;
            }
            if (!"#text".equals(node.getNodeName())) continue;
            foundTextNode = true;
            String nodeValue = node.getNodeValue().trim();
            if (nodeValue.length() <= 0) continue;
            String attrXPath = xPath + "/text()";
            valuesByXPath.put(attrXPath, new XPathNode("#text", nodeValue, attrXPath));
        }
        if (!foundTextNode) {
            String string = xPath + "/text()";
            valuesByXPath.put(string, new XPathNode("#text", null, string));
        }
    }

    public static XPathExpression compileXPath(String xPathExpression) {
        return (XPathExpression)Types.createThreadLocalized(XPathExpression.class, ThreadLocal.withInitial(() -> {
            try {
                return XPATH.get().compile(xPathExpression);
            }
            catch (XPathExpressionException ex) {
                throw new XMLException(ex);
            }
        }));
    }

    public static Comment createCommentBefore(Node sibling, String commentString) {
        Args.notNull((String)"sibling", (Object)sibling);
        Args.notNull((String)"commentString", (Object)commentString);
        Node parent = (Node)Args.notNull((String)"sibling.parentNode", (Object)sibling.getParentNode());
        return (Comment)parent.insertBefore(DOMUtils._getOwnerDocument(parent).createComment(commentString), sibling);
    }

    public static Element createElement(Node parent, String tagName) {
        return DOMUtils.createElement(parent, tagName, null);
    }

    public static Element createElement(Node parent, String tagName, @Nullable Map<String, String> tagAttributes) {
        Args.notNull((String)"parent", (Object)parent);
        Args.notEmpty((String)"tagName", (CharSequence)tagName);
        Element elem = (Element)parent.appendChild(DOMUtils._getOwnerDocument(parent).createElement(tagName));
        if (tagAttributes != null) {
            for (Map.Entry<String, String> attr : tagAttributes.entrySet()) {
                elem.setAttribute(attr.getKey(), attr.getValue());
            }
        }
        return elem;
    }

    public static Element createElementBefore(Node sibling, String tagName) {
        return DOMUtils.createElementBefore(sibling, tagName, null);
    }

    public static Element createElementBefore(Node sibling, String tagName, @Nullable Map<String, String> tagAttributes) {
        Args.notNull((String)"sibling", (Object)sibling);
        Args.notEmpty((String)"tagName", (CharSequence)tagName);
        Node parent = (Node)Args.notNull((String)"sibling.parentNode", (Object)sibling.getParentNode());
        Element elem = (Element)parent.insertBefore(DOMUtils._getOwnerDocument(parent).createElement(tagName), sibling);
        if (tagAttributes != null) {
            for (Map.Entry<String, String> attr : tagAttributes.entrySet()) {
                elem.setAttribute(attr.getKey(), attr.getValue());
            }
        }
        return elem;
    }

    public static Element createElementWithText(Node parent, String tagName, Map<String, String> tagAttributes, Object text) {
        Element elem = DOMUtils.createElement(parent, tagName, tagAttributes);
        DOMUtils.createTextNode(elem, text);
        return elem;
    }

    public static Element createElementWithText(Node parent, String tagName, Object text) {
        Element elem = DOMUtils.createElement(parent, tagName, null);
        DOMUtils.createTextNode(elem, text);
        return elem;
    }

    public static Element createElementWithTextBefore(Node sibling, String tagName, Map<String, String> tagAttributes, Object text) {
        Element elem = DOMUtils.createElementBefore(sibling, tagName, tagAttributes);
        DOMUtils.createTextNode(elem, text);
        return elem;
    }

    public static Element createElementWithTextBefore(Node sibling, String tagName, Object text) {
        Element elem = DOMUtils.createElementBefore(sibling, tagName, null);
        DOMUtils.createTextNode(elem, text);
        return elem;
    }

    public static Text createTextNode(Node parent, Object text) {
        Args.notNull((String)"parent", (Object)parent);
        Args.notNull((String)"text", (Object)text);
        return (Text)parent.appendChild(DOMUtils._getOwnerDocument(parent).createTextNode(text.toString()));
    }

    public static Text createTextNodeBefore(Node sibling, Object text) {
        Args.notNull((String)"sibling", (Object)sibling);
        Args.notNull((String)"text", (Object)text);
        Node parent = (Node)Args.notNull((String)"sibling.parentNode", (Object)sibling.getParentNode());
        return (Text)parent.insertBefore(DOMUtils._getOwnerDocument(parent).createTextNode(text.toString()), sibling);
    }

    private static <T> T evaluate(Node searchScope, String xPathExpression, QName returnType) throws XMLException {
        Args.notNull((String)"searchScope", (Object)searchScope);
        Args.notNull((String)"xPathExpression", (Object)xPathExpression);
        Args.notNull((String)"returnType", (Object)returnType);
        try {
            return (T)XPATH.get().evaluate(xPathExpression, searchScope, returnType);
        }
        catch (XPathExpressionException ex) {
            throw new XMLException(ex);
        }
    }

    public static Boolean evaluateAsBoolean(Node searchScope, String xPathExpression) throws XMLException {
        return (Boolean)DOMUtils.evaluate(searchScope, xPathExpression, XPathConstants.BOOLEAN);
    }

    public static Number evaluateAsNumber(Node searchScope, String xPathExpression) throws XMLException {
        return (Number)DOMUtils.evaluate(searchScope, xPathExpression, XPathConstants.NUMBER);
    }

    public static <T extends Node> T evaluateAsNode(Node searchScope, String xPathExpression) throws XMLException {
        return (T)((Node)DOMUtils.evaluate(searchScope, xPathExpression, XPathConstants.NODE));
    }

    public static <T extends Node> List<T> evaluateAsNodes(Node searchScope, String xPathExpression) throws XMLException {
        return DOMUtils.nodeListToList((NodeList)DOMUtils.evaluate(searchScope, xPathExpression, XPathConstants.NODESET));
    }

    public static String evaluateAsString(Node searchScope, String xPathExpression) throws XMLException {
        return (String)DOMUtils.evaluate(searchScope, xPathExpression, XPathConstants.STRING);
    }

    public static <T extends Node> @Nullable T findNode(Node searchScope, String xPathExpression) throws XMLException {
        Args.notNull((String)"searchScope", (Object)searchScope);
        Args.notNull((String)"xPathExpression", (Object)xPathExpression);
        try {
            return (T)((Node)XPATH.get().evaluate(xPathExpression, searchScope, XPathConstants.NODE));
        }
        catch (XPathExpressionException ex) {
            throw new XMLException(ex);
        }
    }

    public static <T extends Node> List<T> findNodes(Node searchScope, String xPathExpression) throws XMLException {
        Args.notNull((String)"searchScope", (Object)searchScope);
        Args.notNull((String)"xPathExpression", (Object)xPathExpression);
        try {
            NodeList nodes = (NodeList)XPATH.get().evaluate(xPathExpression, searchScope, XPathConstants.NODESET);
            return DOMUtils.nodeListToList((NodeList)NullAnalysisHelper.asNonNullUnsafe((Object)nodes));
        }
        catch (XPathExpressionException ex) {
            throw new XMLException(ex);
        }
    }

    public static @Nullable String findTextContent(Node searchScope, String xPathExpression, boolean recursive) throws XMLException {
        Object node;
        block4: {
            Args.notNull((String)"searchScope", (Object)searchScope);
            Args.notNull((String)"xPathExpression", (Object)xPathExpression);
            try {
                if (recursive) {
                    return (String)XPATH.get().evaluate(xPathExpression, searchScope, XPathConstants.STRING);
                }
                node = DOMUtils.findNode(searchScope, String.valueOf(xPathExpression) + "/text()");
                if (node != null) break block4;
                return null;
            }
            catch (XPathExpressionException ex) {
                throw new XMLException(ex);
            }
        }
        return node.getNodeValue();
    }

    public static List<Attr> getAttributes(Node node) {
        Args.notNull((String)"node", (Object)node);
        NamedNodeMap nodeMap = node.getAttributes();
        ArrayList<Attr> result = new ArrayList<Attr>(nodeMap.getLength());
        int i = 0;
        int l = nodeMap.getLength();
        while (i < l) {
            Attr attr = (Attr)nodeMap.item(i);
            result.add((Attr)NullAnalysisHelper.asNonNullUnsafe((Object)attr));
            ++i;
        }
        return result;
    }

    public static <T extends Node> List<T> getChildNodes(Node parent) {
        return DOMUtils.nodeListToList(parent.getChildNodes());
    }

    public static <T extends Node> List<T> getElementsByTagName(Element parent, String tagName) {
        Args.notNull((String)"parent", (Object)parent);
        Args.notNull((String)"tagName", (Object)tagName);
        return DOMUtils.nodeListToList(parent.getElementsByTagName(tagName));
    }

    public static @Nullable Node getFirstChild(Node node) throws XMLException {
        Args.notNull((String)"node", (Object)node);
        return DOMUtils.findNode(node, "*");
    }

    public static List<Attr> getIdAttributes(Node node) {
        Args.notNull((String)"node", (Object)node);
        NamedNodeMap nodeMap = node.getAttributes();
        ArrayList result = CollectionUtils.newArrayList((int)nodeMap.getLength());
        int i = 0;
        int l = nodeMap.getLength();
        while (i < l) {
            Attr attr = (Attr)nodeMap.item(i);
            if (attr.isId()) {
                result.add(attr);
            }
            ++i;
        }
        return result;
    }

    public static SortedMap<String, XPathNode> getXPathNodes(Element element) {
        Args.notNull((String)"element", (Object)element);
        TreeMap<String, XPathNode> valuesByXPath = new TreeMap<String, XPathNode>();
        DOMUtils._getXPathNodes(element, XPathNodeConfiguration.INTERNAL_SHARED_INSTANCE, "", valuesByXPath);
        return valuesByXPath;
    }

    public static SortedMap<String, XPathNode> getXPathNodes(Element element, XPathNodeConfiguration config) {
        Args.notNull((String)"element", (Object)element);
        Args.notNull((String)"config", (Object)config);
        TreeMap<String, XPathNode> valuesByXPath = new TreeMap<String, XPathNode>();
        DOMUtils._getXPathNodes(element, config, "", valuesByXPath);
        return valuesByXPath;
    }

    public static <T extends Node> T importNode(Node parent, T nodeToImport) {
        Args.notNull((String)"parent", (Object)parent);
        Args.notNull((String)"nodeToImport", nodeToImport);
        return (T)parent.appendChild(DOMUtils._getOwnerDocument(parent).importNode(nodeToImport, true));
    }

    public static <T extends Node> T importNodeBefore(Node sibling, T nodeToImport) {
        Args.notNull((String)"sibling", (Object)sibling);
        Args.notNull((String)"nodeToImport", nodeToImport);
        Node parent = (Node)Args.notNull((String)"sibling.parentNode", (Object)sibling.getParentNode());
        Node importedNode = DOMUtils._getOwnerDocument(parent).importNode(nodeToImport, true);
        return (T)parent.insertBefore(importedNode, sibling);
    }

    public static <T extends Node> List<T> importNodes(Node parent, Collection<T> nodesToImport) {
        Args.notNull((String)"parent", (Object)parent);
        Args.notNull((String)"nodesToImport", nodesToImport);
        Document targetDoc = DOMUtils._getOwnerDocument(parent);
        ArrayList<Node> importedNodes = new ArrayList<Node>(nodesToImport.size());
        for (Node nodeToImport : nodesToImport) {
            Node importedNode = parent.appendChild(targetDoc.importNode(nodeToImport, true));
            importedNodes.add(importedNode);
        }
        return importedNodes;
    }

    public static <T extends Node> List<T> importNodes(Node parent, NodeList nodesToImport) {
        Args.notNull((String)"nodesToImport", (Object)nodesToImport);
        return DOMUtils.importNodes(parent, DOMUtils.nodeListToList(nodesToImport));
    }

    public static <T extends Node> List<T> importNodesBefore(Node sibling, Collection<T> nodesToImport) {
        Args.notNull((String)"sibling", (Object)sibling);
        Args.notNull((String)"nodesToImport", nodesToImport);
        Node parent = (Node)Args.notNull((String)"sibling.parentNode", (Object)sibling.getParentNode());
        Document targetDoc = DOMUtils._getOwnerDocument(parent);
        ArrayList<Node> importedNodes = new ArrayList<Node>(nodesToImport.size());
        for (Node nodeToImport : nodesToImport) {
            Node importedNode = parent.insertBefore(targetDoc.importNode(nodeToImport, true), sibling);
            importedNodes.add(importedNode);
        }
        return importedNodes;
    }

    public static <T extends Node> List<T> importNodesBefore(Node sibling, NodeList nodesToImport) {
        Args.notNull((String)"nodesToImport", (Object)nodesToImport);
        return DOMUtils.importNodesBefore(sibling, DOMUtils.nodeListToList(nodesToImport));
    }

    public static Node[] nodeListToArray(NodeList nodes) {
        Args.notNull((String)"nodes", (Object)nodes);
        Node[] result = new Node[nodes.getLength()];
        int i = 0;
        int l = nodes.getLength();
        while (i < l) {
            result[i] = (Node)NullAnalysisHelper.asNonNull((Object)nodes.item(i));
            ++i;
        }
        return result;
    }

    public static <T extends Node> List<T> nodeListToList(NodeList nodes) {
        Args.notNull((String)"nodes", (Object)nodes);
        ArrayList result = CollectionUtils.newArrayList((int)nodes.getLength());
        int i = 0;
        int l = nodes.getLength();
        while (i < l) {
            result.add(nodes.item(i));
            ++i;
        }
        return result;
    }

    public static Document parseFile(File xmlFile) throws XMLException {
        Args.notNull((String)"xmlFile", (Object)xmlFile);
        Assert.isFileReadable((File)xmlFile);
        return DOMUtils.parseInputSource(new InputSource(xmlFile.toURI().toASCIIString()), xmlFile.getAbsolutePath(), null, null);
    }

    public static Document parseFile(File xmlFile, File ... xmlSchemaFiles) throws XMLException {
        Args.notNull((String)"xmlFile", (Object)xmlFile);
        Assert.isFileReadable((File)xmlFile);
        return DOMUtils.parseInputSource(new InputSource(xmlFile.toURI().toASCIIString()), xmlFile.getAbsolutePath(), null, xmlSchemaFiles);
    }

    public static Document parseFile(File xmlFile, @Nullable String defaultNamespace, File ... xmlSchemaFiles) throws XMLException {
        Args.notNull((String)"xmlFile", (Object)xmlFile);
        Assert.isFileReadable((File)xmlFile);
        return DOMUtils.parseInputSource(new InputSource(xmlFile.toURI().toASCIIString()), xmlFile.getAbsolutePath(), defaultNamespace, xmlSchemaFiles);
    }

    public static Document parseInputSource(InputSource input, String inputId) throws XMLException {
        return DOMUtils.parseInputSource(input, inputId, null, new File[0]);
    }

    public static Document parseInputSource(InputSource input, @Nullable String inputId, @Nullable String defaultNamespace, File ... xmlSchemaFiles) throws XMLException {
        Args.notNull((String)"input", (Object)input);
        try {
            LOG.debug("Parsing [%s]...", (Object)inputId);
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            domFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            domFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            domFactory.setCoalescing(true);
            domFactory.setIgnoringComments(false);
            domFactory.setXIncludeAware(true);
            if (xmlSchemaFiles == null || xmlSchemaFiles.length == 0) {
                DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
                domBuilder.setEntityResolver(NOREMOTE_DTD_RESOLVER);
                return domBuilder.parse(input);
            }
            domFactory.setNamespaceAware(true);
            domFactory.setValidating(true);
            domFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            domFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", xmlSchemaFiles);
            domFactory.setFeature("http://apache.org/xml/features/honour-all-schemaLocations", true);
            DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
            domBuilder.setEntityResolver(NOREMOTE_DTD_RESOLVER);
            SAXParseExceptionHandler errorHandler = new SAXParseExceptionHandler();
            domBuilder.setErrorHandler(errorHandler);
            Document domDoc = domBuilder.parse(input);
            Element domRoot = domDoc.getDocumentElement();
            domRoot.removeAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
            String ns = domRoot.getNamespaceURI();
            if (defaultNamespace != null && !defaultNamespace.equals(ns)) {
                LOG.debug("Fixing root namespace...");
                domRoot.setAttribute("jstuffNS", defaultNamespace);
                String newXML = DOMUtils.toXML(domDoc).replaceFirst("xmlns\\s*=\\s*(['][^']*[']|[\"][^\"]*[\"])", "").replaceFirst("jstuffNS", "xmlns");
                errorHandler.violations.clear();
                domDoc = domBuilder.parse(new InputSource(new StringReader(newXML)));
            }
            Assert.isTrue((boolean)errorHandler.violations.isEmpty(), (String)(String.valueOf(errorHandler.violations.size()) + " XML schema violation(s) detected in [" + inputId + "]:\n\n => " + Strings.join(errorHandler.violations, (String)"\n => ")));
            return domDoc;
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            throw new XMLException(ex);
        }
    }

    public static Document parseString(CharSequence input, @Nullable String inputId) throws XMLException {
        Args.notNull((String)"input", (Object)input);
        return DOMUtils.parseInputSource(new InputSource((Reader)new CharSequenceReader(input)), inputId, null, null);
    }

    public static Document parseString(CharSequence input, @Nullable String inputId, String defaultNamespace, File ... xmlSchemaFiles) throws XMLException {
        Args.notNull((String)"input", (Object)input);
        return DOMUtils.parseInputSource(new InputSource((Reader)new CharSequenceReader(input)), inputId, defaultNamespace, xmlSchemaFiles);
    }

    public static void registerNamespace(String namespaceURI, String prefix) {
        Args.notNull((String)"namespaceURI", (Object)namespaceURI);
        Args.notNull((String)"prefix", (Object)prefix);
        NAMESPACE_CONTEXT.bindNamespace(namespaceURI, prefix);
    }

    public static boolean removeNode(Node node) throws DOMException {
        Node parent = node.getParentNode();
        if (parent == null) {
            return false;
        }
        parent.removeChild(node);
        return true;
    }

    public static List<Node> removeNodes(Node searchScope, String xPathExpression) throws XMLException {
        Args.notNull((String)"searchScope", (Object)searchScope);
        Args.notEmpty((String)"xPathExpression", (CharSequence)xPathExpression);
        List<Node> nodesToRemove = DOMUtils.findNodes(searchScope, xPathExpression);
        for (Node nodeToRemove : nodesToRemove) {
            DOMUtils.removeNode(nodeToRemove);
        }
        return nodesToRemove;
    }

    public static void removeWhiteSpaceNodes(Node searchScope) {
        DOMUtils.removeNodes(searchScope, "text()[normalize-space()='']");
    }

    public static void saveToFile(Node root, File targetFile) throws IOException, XMLException {
        Args.notNull((String)"root", (Object)root);
        Args.notNull((String)"targetFile", (Object)targetFile);
        try {
            Transformer transformer = TRANSFORMER_FACTORY.get().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            Throwable throwable = null;
            Object var4_6 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), StandardCharsets.UTF_8);){
                transformer.transform(new DOMSource(root), new StreamResult(writer));
                writer.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (TransformerException ex) {
            throw new XMLException(ex);
        }
    }

    public static void saveToFileAfterBackup(Node root, File targetFile) throws IOException, XMLException {
        Args.notNull((String)"root", (Object)root);
        Args.notNull((String)"targetFile", (Object)targetFile);
        MoreFiles.backupFile((Path)targetFile.toPath());
        DOMUtils.saveToFile(root, targetFile);
    }

    public static void sortChildNodes(Node parentNode, Comparator<Node> comparator) {
        Args.notNull((String)"parentNode", (Object)parentNode);
        Args.notNull((String)"comparator", comparator);
        ArrayList<Node> sortedNodes = new ArrayList<Node>();
        for (Node node : DOMUtils.getChildNodes(parentNode)) {
            if (node instanceof Text && ((Text)node).getTextContent().trim().length() > 1) continue;
            sortedNodes.add(node);
        }
        Collections.sort(sortedNodes, comparator);
        for (Node n : sortedNodes) {
            parentNode.appendChild(n);
        }
    }

    public static void sortChildNodesByAttributes(Node parentNode, boolean ascending, String ... attributeNames) {
        Args.notNull((String)"parentNode", (Object)parentNode);
        ArrayList<Node> children = new ArrayList<Node>();
        for (Node node : DOMUtils.getChildNodes(parentNode)) {
            if (node instanceof Text && ((Text)node).getTextContent().trim().length() > 1) continue;
            children.add(node);
        }
        Collections.sort(children, (n1, n2) -> {
            NamedNodeMap m1 = n1.getAttributes();
            NamedNodeMap m2 = n2.getAttributes();
            String[] stringArray2 = attributeNames;
            int n = attributeNames.length;
            int n3 = 0;
            while (n3 < n) {
                int i2;
                int i1;
                String v2;
                String attrName = stringArray2[n3];
                Attr a1 = (Attr)m1.getNamedItem(attrName);
                Attr a2 = (Attr)m2.getNamedItem(attrName);
                String v1 = a1 == null ? null : a1.getValue();
                String string = v2 = a2 == null ? null : a2.getValue();
                int rc = v1 != null && v2 != null && Strings.isNumeric((CharSequence)v1) && Strings.isNumeric((CharSequence)v2) ? ((i1 = Integer.parseInt(v1, 10)) < (i2 = Integer.parseInt(v2, 10)) ? -1 : (i1 == i2 ? 0 : 1)) : StringComparator.INSTANCE.compare(v1, v2);
                if (rc != 0) {
                    return ascending ? rc : -1 * rc;
                }
                ++n3;
            }
            return 0;
        });
        for (Node n : children) {
            parentNode.appendChild(n);
        }
    }

    public static String toXML(Node root) throws XMLException {
        Args.notNull((String)"root", (Object)root);
        return DOMUtils.toXML(root, true, true);
    }

    public static String toXML(Node root, boolean outputXMLDeclaration, boolean formatPretty) throws XMLException {
        Args.notNull((String)"root", (Object)root);
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream();
        try {
            DOMUtils.toXML(root, (OutputStream)bos, outputXMLDeclaration, formatPretty);
        }
        catch (IOException iOException) {}
        return bos.toString();
    }

    public static void toXML(Node root, OutputStream out) throws XMLException, IOException {
        Args.notNull((String)"root", (Object)root);
        Args.notNull((String)"out", (Object)out);
        DOMUtils.toXML(root, out, true, true);
    }

    public static void toXML(Node root, OutputStream out, boolean outputXMLDeclaration, boolean formatPretty) throws XMLException, IOException {
        Args.notNull((String)"root", (Object)root);
        Args.notNull((String)"out", (Object)out);
        try {
            Transformer transformer = TRANSFORMER_FACTORY.get().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("media-type", "text/xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            if (outputXMLDeclaration) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                out.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>".getBytes(StandardCharsets.UTF_8));
                out.write(Strings.NEW_LINE.getBytes(StandardCharsets.UTF_8));
            } else {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            if (formatPretty) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            } else {
                transformer.setOutputProperty("indent", "no");
            }
            transformer.transform(new DOMSource(root), new StreamResult(out));
        }
        catch (TransformerException ex) {
            throw new XMLException(ex);
        }
    }

    private static final class SAXParseExceptionHandler
    extends DefaultHandler {
        private final List<SAXParseException> violations = new ArrayList<SAXParseException>();

        private SAXParseExceptionHandler() {
        }

        @Override
        public void error(SAXParseException ex) throws SAXException {
            this.violations.add(ex);
        }

        @Override
        public void warning(SAXParseException ex) throws SAXException {
            this.violations.add(ex);
        }
    }

    public static class XPathNode
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final String name;
        public final @Nullable String value;
        public final String xPath;

        public XPathNode(String name, @Nullable String value, String xPath) {
            this.name = name;
            this.value = value;
            this.xPath = xPath;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            XPathNode other = (XPathNode)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value) && Objects.equals(this.xPath, other.xPath);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.value, this.xPath);
        }

        public String toString() {
            String value = this.value;
            return value == null ? "null" : value;
        }
    }

    public static class XPathNodeConfiguration
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 1L;
        private static final XPathNodeConfiguration INTERNAL_SHARED_INSTANCE = new XPathNodeConfiguration();
        public boolean recursive = true;
        public boolean useSchemaIdAttributes = true;
        public final MapWithLists<String, String> idAttributesByXMLTagName = new MapWithLists();

        protected XPathNodeConfiguration clone() throws CloneNotSupportedException {
            XPathNodeConfiguration clone = new XPathNodeConfiguration();
            clone.recursive = this.recursive;
            clone.useSchemaIdAttributes = this.useSchemaIdAttributes;
            clone.idAttributesByXMLTagName.putAll(this.idAttributesByXMLTagName);
            return clone;
        }

        public List<String> getIdAttributesForXMLTagName(String xmlTagName) {
            return (List)this.idAttributesByXMLTagName.getNullSafe((Object)xmlTagName);
        }
    }
}

