/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.xml;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.SchemaOutputResolver;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.jstuff.core.Strings;
import net.sf.jstuff.core.io.stream.FastByteArrayOutputStream;
import net.sf.jstuff.core.validation.Args;
import net.sf.jstuff.xml.XMLException;
import org.eclipse.jdt.annotation.Nullable;

public abstract class JAXBUtils {
    public static String toXML(Object obj) throws XMLException {
        Args.notNull((String)"obj", (Object)obj);
        FastByteArrayOutputStream baos = new FastByteArrayOutputStream();
        JAXBUtils.toXML(obj, (OutputStream)baos);
        return baos.toString();
    }

    public static void toXML(Object obj, OutputStream out) throws XMLException {
        Args.notNull((String)"obj", (Object)obj);
        Args.notNull((String)"out", (Object)out);
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
            Marshaller m = ctx.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.setProperty("jaxb.encoding", (Object)"UTF-8");
            if (ctx.createJAXBIntrospector().getElementName(obj) == null) {
                m.marshal((Object)new JAXBElement(new QName(Strings.lowerCaseFirstChar((CharSequence)obj.getClass().getSimpleName())), obj.getClass(), obj), out);
            } else {
                m.marshal(obj, out);
            }
        }
        catch (JAXBException ex) {
            throw new XMLException(ex);
        }
    }

    public static String toXSD(Class<?> ... xmlRootClasses) throws XMLException {
        Args.notNull((String)"xmlRootClasses", xmlRootClasses);
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        try {
            JAXBUtils.toXSD((OutputStream)out, xmlRootClasses);
        }
        catch (IOException iOException) {}
        return out.toString();
    }

    public static void toXSD(OutputStream out, Class<?> ... xmlRootClasses) throws XMLException, IOException {
        Args.notNull((String)"xmlRootClasses", xmlRootClasses);
        Args.notNull((String)"out", (Object)out);
        try {
            final StreamResult result = new StreamResult(out);
            JAXBContext.newInstance((Class[])xmlRootClasses).generateSchema(new SchemaOutputResolver(){

                public @Nullable Result createOutput(String namespaceURI, String suggestedFileName) throws IOException {
                    result.setSystemId(new File(suggestedFileName));
                    return result;
                }
            });
        }
        catch (JAXBException ex) {
            throw new XMLException(ex);
        }
    }
}

