/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.xml.stream;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.jstuff.core.Strings;
import net.sf.jstuff.core.collection.primitive.IntArrayList;
import net.sf.jstuff.core.logging.Logger;
import org.eclipse.jdt.annotation.Nullable;

public abstract class StAXUtils {
    private static final Logger LOG = Logger.create();

    public static @Nullable ElementInfo findElement(XMLStreamReader reader, String xpath) throws XMLStreamException {
        List<ElementInfo> elems = StAXUtils.findElements(reader, xpath, 1);
        return elems.isEmpty() ? null : elems.get(0);
    }

    public static List<ElementInfo> findElements(XMLStreamReader reader, String xpath) throws XMLStreamException {
        return StAXUtils.findElements(reader, xpath, Integer.MAX_VALUE);
    }

    public static List<ElementInfo> findElements(XMLStreamReader reader, String xpath, int max) throws XMLStreamException {
        StringBuilder path = new StringBuilder();
        IntArrayList pathElemSize = new IntArrayList();
        StringBuilder pathElem = new StringBuilder();
        boolean evaluteAttributes = Strings.contains((CharSequence)xpath, (int)91);
        SortedMap<String, String> attrs = null;
        Pattern xpathPattern = StAXUtils.xpathToPattern(xpath);
        ArrayList<ElementInfo> result = new ArrayList<ElementInfo>(max < 10 ? max : 10);
        ElementInfo elem = null;
        while (reader.hasNext()) {
            reader.next();
            switch (reader.getEventType()) {
                case 1: {
                    pathElem.setLength(0);
                    pathElem.append('/');
                    pathElem.append(reader.getLocalName());
                    if (evaluteAttributes && (attrs = StAXUtils.readAttributes(reader, attrs)).size() > 0) {
                        pathElem.append('[');
                        boolean isFirstAttr = true;
                        for (Map.Entry<String, String> entry : attrs.entrySet()) {
                            if (isFirstAttr) {
                                isFirstAttr = false;
                            } else {
                                pathElem.append(',');
                            }
                            pathElem.append('@').append(entry.getKey()).append("='").append(entry.getValue()).append('\'');
                        }
                        pathElem.append(']');
                    }
                    pathElemSize.add(pathElem.length());
                    path.append((CharSequence)pathElem);
                    boolean isMatch = xpathPattern.matcher(path).matches();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("\n--------------------------------\n    PATH: " + path + "\n" + "   XPATH: " + xpath + "\n" + "   REGEX: " + xpathPattern + "\n" + "IS_MATCH: " + isMatch + "\n" + "--------------------------------");
                    }
                    if (!isMatch) break;
                    if (attrs == null) {
                        attrs = StAXUtils.readAttributes(reader, attrs);
                    }
                    elem = new ElementInfo(reader.getLocalName(), reader.getPrefix(), reader.getNamespaceURI(), reader.getLocation(), attrs);
                    attrs = null;
                    break;
                }
                case 4: {
                    if (elem == null) break;
                    elem.text = elem.text == null ? reader.getText() : String.valueOf(elem.text) + reader.getText();
                    break;
                }
                case 2: {
                    if (elem != null) {
                        result.add(elem);
                        elem = null;
                    }
                    if (result.size() == max) {
                        return result;
                    }
                    if (pathElemSize.isEmpty()) break;
                    int size = pathElemSize.removeLast();
                    if (path.length() <= 0) break;
                    path.setLength(path.length() - size);
                }
            }
        }
        return result;
    }

    public static @Nullable String getAttributeValue(XMLStreamReader reader, String attrLocalName) {
        int i = 0;
        while (i < reader.getAttributeCount()) {
            String localName = reader.getAttributeLocalName(i);
            if (localName.equals(attrLocalName)) {
                return reader.getAttributeValue(i);
            }
            ++i;
        }
        return null;
    }

    public static String getAttributeValue(XMLStreamReader reader, String attrLocalName, String defaultValue) {
        String val = StAXUtils.getAttributeValue(reader, attrLocalName);
        return val == null ? defaultValue : val;
    }

    public static boolean getAttributeValueAsBoolean(XMLStreamReader reader, String attrLocalName, boolean defaultValue) {
        String val = StAXUtils.getAttributeValue(reader, attrLocalName);
        if (val == null || Strings.isBlank((CharSequence)val)) {
            return defaultValue;
        }
        return Boolean.parseBoolean(val);
    }

    private static SortedMap<String, String> readAttributes(XMLStreamReader reader, @Nullable SortedMap<String, String> reusableMap) {
        if (reusableMap == null) {
            reusableMap = new TreeMap<String, String>();
        } else {
            reusableMap.clear();
        }
        int i = 0;
        while (i < reader.getAttributeCount()) {
            reusableMap.put(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
            ++i;
        }
        return reusableMap;
    }

    private static Pattern xpathToPattern(String xpath) {
        boolean evaluteAttributes = Strings.contains((CharSequence)xpath, (int)91);
        StringBuilder sb = new StringBuilder("^");
        xpath = xpath.trim();
        xpath = Strings.replace((String)xpath, (String)"//", (String)".*/");
        String[] elems = Strings.split((String)xpath, (char)'/');
        int i = 0;
        while (i < elems.length) {
            String elem = elems[i];
            if (i == 0) {
                if (elem.length() == 0) {
                    sb.append('^');
                } else {
                    sb.append(".*");
                }
            }
            sb.append("\\/");
            if (evaluteAttributes) {
                if (Strings.contains((CharSequence)elem, (int)91)) {
                    sb.append(Strings.substringBefore((String)elem, (String)"["));
                    sb.append("\\[.*");
                    Object[] attrValues = Strings.splitByWholeSeparator((String)Strings.substringBetween((String)elem, (String)"[", (String)"]"), (String)" and ");
                    Arrays.sort(attrValues);
                    Object[] objectArray = attrValues;
                    int n = attrValues.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object attrValue = objectArray[n2];
                        sb.append(Strings.replace((String)((String)attrValue).trim(), (String)"\"", (String)"'")).append(".*");
                        ++n2;
                    }
                    sb.append("\\]");
                } else {
                    sb.append(elem).append("(\\[.*\\])?");
                }
            } else {
                sb.append(elem);
            }
            ++i;
        }
        sb.append('$');
        return Pattern.compile(sb.toString());
    }

    public static final class ElementInfo {
        public final String localName;
        public final @Nullable String nsPrefix;
        public final @Nullable String nsURI;
        public final @Nullable Location location;
        private @Nullable String text;
        public final SortedMap<String, String> attrs;

        private ElementInfo(String localName, @Nullable String nsPrefix, @Nullable String nsURI, @Nullable Location location, SortedMap<String, String> attrs) {
            this.localName = localName;
            this.nsPrefix = nsPrefix;
            this.nsURI = nsURI;
            this.location = location;
            this.attrs = attrs;
        }

        public @Nullable String getText() {
            return this.text;
        }

        public String toString() {
            String nsPrefix = this.nsPrefix;
            return String.valueOf(nsPrefix == null || nsPrefix.length() == 0 ? "" : String.valueOf(nsPrefix) + ":") + this.localName;
        }
    }
}

