/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.xml.xjc;

import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAnnotationValue;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import jakarta.xml.bind.annotation.XmlElementRefs;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import net.sf.jstuff.core.logging.Logger;
import net.sf.jstuff.core.reflection.Fields;
import net.sf.jstuff.core.validation.NullAnalysisHelper;
import net.sf.jstuff.xml.xjc.AbstractPlugin;
import org.eclipse.jdt.annotation.Nullable;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class FieldInstantiatingPlugin
extends AbstractPlugin {
    private static final Logger LOG = Logger.create();
    public static final String OPTION_NAME = "Xinst-fields";
    private static final String CUSTOMIZATION_NAMESPACE = "FieldInstantiatingPlugin";
    private static final String CUSTOMIZATION_ENABLED_TAG = "enabled";

    @Override
    protected @Nullable String getCustomizationNS() {
        return CUSTOMIZATION_NAMESPACE;
    }

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return "  -Xinst-fields       : Automatically instantiate fields with types defined in the schema.";
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) throws SAXException {
        ArrayList<JDefinedClass> typeDefs = new ArrayList<JDefinedClass>();
        for (ClassOutline classDef : outline.getClasses()) {
            typeDefs.add(classDef.implClass);
        }
        for (ClassOutline classDef : outline.getClasses()) {
            for (JFieldVar fieldDecl : classDef.implClass.fields().values()) {
                Field memberValueFields = Fields.get(JAnnotationUse.class, (String)"memberValues");
                for (JAnnotationUse a : fieldDecl.annotations()) {
                    if (!XmlElementRefs.class.getName().equals(a.getAnnotationClass().binaryName()) && !"javax.xml.bind.annotation.XmlElementRefs".equals(a.getAnnotationClass().binaryName())) continue;
                    for (JAnnotationUse xmlElementRefAnno : ((JAnnotationArrayMember)NullAnalysisHelper.asNonNull((Object)((JAnnotationValue)a.getAnnotationMembers().get("value")))).annotations()) {
                        JAnnotationValue requiredAttribute = (JAnnotationValue)xmlElementRefAnno.getAnnotationMembers().get("required");
                        if (requiredAttribute == null) continue;
                        ((Map)Fields.read((Object)xmlElementRefAnno, (Field)memberValueFields)).remove("required");
                    }
                }
                if (!typeDefs.contains(fieldDecl.type())) continue;
                FieldOutline fieldDef = null;
                FieldOutline[] fieldOutlineArray = classDef.getDeclaredFields();
                int n = fieldOutlineArray.length;
                int xmlElementRefAnno = 0;
                while (xmlElementRefAnno < n) {
                    FieldOutline f = fieldOutlineArray[xmlElementRefAnno];
                    if (f.getPropertyInfo().getName(false).equals(fieldDecl.name())) {
                        fieldDef = f;
                    }
                    ++xmlElementRefAnno;
                }
                if (fieldDef == null) {
                    throw new IllegalStateException("FieldOutline not found for " + fieldDecl.name());
                }
                boolean doInstantiate = false;
                for (CPluginCustomization pc : this.findCustomizations(fieldDef.getPropertyInfo().getCustomizations(), CUSTOMIZATION_ENABLED_TAG)) {
                    pc.markAsAcknowledged();
                    doInstantiate = true;
                }
                if (doInstantiate) {
                    LOG.info("%s#%s = new %s()", (Object)classDef.implClass.name(), (Object)fieldDecl.name(), (Object)fieldDecl.type().name());
                    fieldDecl.init((JExpression)JExpr._new((JType)fieldDecl.type()));
                    continue;
                }
                LOG.info("Not instantiating %s#%s", (Object)classDef.implClass.name(), (Object)fieldDecl.name());
            }
        }
        return true;
    }

    public boolean isCustomizationTagName(String nsURI, String localName) {
        if (!CUSTOMIZATION_NAMESPACE.equals(nsURI)) {
            return false;
        }
        return CUSTOMIZATION_ENABLED_TAG.equals(localName);
    }
}

