/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.xml.xjc;

import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAnnotationValue;
import com.sun.codemodel.JFieldVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import jakarta.xml.bind.annotation.XmlElementRefs;
import java.lang.reflect.Field;
import java.util.Map;
import net.sf.jstuff.core.reflection.Fields;
import net.sf.jstuff.core.validation.NullAnalysisHelper;
import net.sf.jstuff.xml.xjc.AbstractPlugin;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class MakeJAXB21CompatiblePlugin
extends AbstractPlugin {
    private static final Field MEMBER_VALUES_FIELD = Fields.get(JAnnotationUse.class, (String)"memberValues");
    public static final String OPTION_NAME = "Xjaxb21compat";

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return "  -Xjaxb21compat    :  fixes the generate code to be compatible with JAXB2.1";
    }

    private void removeRequiredAttribute(JFieldVar fieldDecl) {
        for (JAnnotationUse a : fieldDecl.annotations()) {
            if (!XmlElementRefs.class.getName().equals(a.getAnnotationClass().binaryName()) && !"javax.xml.bind.annotation.XmlElementRefs".equals(a.getAnnotationClass().binaryName())) continue;
            for (JAnnotationUse xmlElementRefAnno : ((JAnnotationArrayMember)NullAnalysisHelper.asNonNull((Object)((JAnnotationValue)a.getAnnotationMembers().get("value")))).annotations()) {
                JAnnotationValue requiredAttribute = (JAnnotationValue)xmlElementRefAnno.getAnnotationMembers().get("required");
                if (requiredAttribute == null) continue;
                ((Map)Fields.read((Object)xmlElementRefAnno, (Field)MEMBER_VALUES_FIELD)).remove("required");
            }
        }
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) throws SAXException {
        for (ClassOutline classDef : outline.getClasses()) {
            for (JFieldVar fieldDecl : classDef.implClass.fields().values()) {
                this.removeRequiredAttribute(fieldDecl);
            }
        }
        return true;
    }
}

