package com.ibm.as400.access;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.*;
import java.util.Calendar;

// 
// This extends AS400JDBCPrepareStatement for compatibility reasons only
// All methods have been overridden
// 
public class AS400JDBCPreparedStatementRedirect  extends AS400JDBCPreparedStatement {

  AS400JDBCPreparedStatement stmt_ = null;
  AS400JDBCConnection connection_; 

  AS400JDBCPreparedStatementRedirect(AS400JDBCPreparedStatement stmt)
      throws SQLException {

    stmt_ = stmt;
    connection_ = (AS400JDBCConnection) stmt.getConnection(); 
  }

  // Methods from AS400JDBCStatementRedirect.  
  // Needed because we can't have double inheritance
  
  public void addBatch(String sql) throws SQLException {
    stmt_.addBatch(sql); 
  }

  public void cancel() throws SQLException {
    stmt_.cancel(); 
  }

  void checkOpen() throws SQLException {
    stmt_.checkOpen(); 
  }

  public void clearBatch() throws SQLException {
    stmt_.clearBatch(); 
  }

  public void clearWarnings() throws SQLException {
    stmt_.clearWarnings(); 
  }

  
  public void close() throws SQLException {
    
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT; 
    while (true) {
      
      try {
         stmt_.close(); 
         return; 
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--; 
          if (retryCount >= 0 ) {
            // keep trying in loop
          } else {
            throw e; 
          }
        } else {
          throw e; 
        }
      }
    } /* retry */

  }

  void finishClosing() throws SQLException {
    stmt_.finishClosing(); 
  }
  
  void closeResultSet(int reuseFlag) throws SQLException {
    stmt_.closeResultSet(reuseFlag);
  }
  
  /* Note: commonExecute not needed */
  /* Note: commonExecuteAfter not needed */ 
  /* Note: commonExecuteBefore not needed */
  /* Note: commonPrepare not needed */
  /* Note: commonAfter not needed */
  /* Note: commonBefore not needed */
  /* Note: commonBypass not needed */
  
  public boolean execute(String sql) throws SQLException {
    return stmt_.execute(sql);  
  }

  public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
    return stmt_.execute(sql, autoGeneratedKeys); 
  }

  public boolean execute(String sql, int[] columnIndexes) throws SQLException {
    return stmt_.execute(sql, columnIndexes); 
  }

  public boolean execute(String sql, String[] columnNames) throws SQLException {
    return stmt_.execute(sql, columnNames); 
  }

  public int[] executeBatch() throws SQLException {
    return stmt_.executeBatch(); 
  }
 
  
 public ResultSet executeQuery(String sql) throws SQLException {
       return stmt_.executeQuery(sql);
 }
 
 public int executeUpdate(String sql) throws SQLException {
       return stmt_.executeUpdate(sql); 
 }

 public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return stmt_.executeUpdate(sql,autoGeneratedKeys); 
 }

 public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return stmt_.executeUpdate(sql, columnIndexes); 
 }

 public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return stmt_.executeUpdate(sql, columnNames); 
 }

 /* Note: finalize not used */

 int getBlockingFactor(String cursorSensitivityProperty, JDSQLStatement sqlStatement, int rowLength) { 
   return stmt_.getBlockingFactor(cursorSensitivityProperty, sqlStatement, rowLength);
 }
 
 public Connection getConnection() throws SQLException {
   return stmt_.getConnection(); 
 }

 String getCursorName() {
   return stmt_.getCursorName(); 
 }
 
 public int getFetchDirection() throws SQLException {
   return stmt_.getFetchDirection(); 
 }

 public int getFetchSize() throws SQLException {
   return stmt_.getFetchSize(); 
 }

 public ResultSet getGeneratedKeys() throws SQLException {
   return stmt_.getGeneratedKeys(); 
 }

 public int getMaxFieldSize() throws SQLException {
   return stmt_.getMaxFieldSize();
 }

 public int getMaxRows() throws SQLException {
   return stmt_.getMaxRows(); 
 }

 
 public boolean getMoreResults() throws SQLException {
   return stmt_.getMoreResults(); 
 }


 public boolean getMoreResults(int current) throws SQLException {
   return stmt_.getMoreResults(current); 
 }

 public int getPositionOfSyntaxError() throws SQLException {
   return stmt_.getPositionOfSyntaxError(); 
 }

 public int getQueryTimeout() throws SQLException {
   return stmt_.getQueryTimeout(); 
 }

 public ResultSet getResultSet() throws SQLException {
   AS400JDBCResultSet rs = (AS400JDBCResultSet) stmt_.getResultSet();
   if (rs != null) { 
      rs.setStatement(this);
   }
   return rs; 
 }

 public int getResultSetConcurrency() throws SQLException {
   return stmt_.getResultSetConcurrency(); 
 }

 public int getResultSetHoldability() throws SQLException {
   return stmt_.getResultSetHoldability(); 
 }

 public int getResultSetType() throws SQLException {
   return stmt_.getResultSetType(); 
 }

 public int getUpdateCount() throws SQLException {
   return stmt_.getUpdateCount(); 
 }

 public SQLWarning getWarnings() throws SQLException {
   return stmt_.getWarnings(); 
 }
 
 void setHoldStatement(boolean hold) {
   stmt_.setHoldStatement(hold);
 }
 
 boolean isHoldStatement() { 
   return stmt_.isHoldStatement(); 
 }
 
 void setAssociatedWithLocators(boolean hasLocator) {
   stmt_.setAssociatedWithLocators(hasLocator);
 }
 
 boolean isAssociatedWithLocators() { 
   return stmt_.isAssociatedWithLocators(); 
 }
 
 
 public boolean isClosed() throws SQLException {
   return stmt_.isClosed(); 
 }

 void markCursorClosed(boolean isRollback) throws SQLException {
   stmt_.markCursorClosed(isRollback);
 }
 
 void notifyClose () throws SQLException   {
   stmt_.notifyClose(); 
}
 
 void postWarning(SQLWarning sqlWarning) { 
   stmt_.postWarning(sqlWarning);
 }

 public void setCursorName(String name) throws SQLException {
   stmt_.setCursorName(name); 
 }

 public void setEscapeProcessing(boolean enable) throws SQLException {
   stmt_.setEscapeProcessing(enable);
 }

 public void setFetchDirection(int direction) throws SQLException {
   stmt_.setFetchDirection(direction); 
 }

 public void setFetchSize(int rows) throws SQLException {
   stmt_.setFetchSize(rows);
 }

 public void setMaxFieldSize(int max) throws SQLException {
   stmt_.setMaxFieldSize(max); 
 }

 public void setMaxRows(int max) throws SQLException {
   stmt_.setMaxRows(max); 
 }

 public void setQueryTimeout(int seconds) throws SQLException {
   stmt_.setQueryTimeout(seconds); 
 }

 public String toString() {
   return stmt_.toString(); 
 }

 /* Note: verifyGeneratedKeysParameter not needed */ 
 
 
 public void setPoolable(boolean poolable) throws SQLException {
   stmt_.setPoolable(poolable); 
 }

 public boolean isPoolable() throws SQLException {
   return stmt_.isPoolable(); 
 }

 protected java.lang.String[] getValidWrappedList() {
   return stmt_.getValidWrappedList(); 
 }
 
 public void closeOnCompletion() throws SQLException {
   ((AS400JDBCStatement)stmt_).closeOnCompletion(); 
 }

 public boolean isCloseOnCompletion() throws SQLException {
   return ((AS400JDBCStatement)stmt_).isCloseOnCompletion(); 
 }

 protected void startCancelThread() {
   stmt_.startCancelThread(); 
 }

 protected void endCancelThread() {
   stmt_.endCancelThread(); 
 }

 public   long getLargeUpdateCount() throws SQLException {
   return stmt_.getLargeUpdateCount();  
 }

 public void setLargeMaxRows(long max) throws SQLException {
   stmt_.setLargeMaxRows(max); 
 }

 public long getLargeMaxRows() throws SQLException {
   return stmt_.getLargeMaxRows(); 
 }


     
   
   public long[] executeLargeBatch()    throws SQLException  {
     return stmt_.executeLargeBatch(); 
   }

  public long executeLargeUpdate(String sql)   throws SQLException {
        return stmt_.executeLargeUpdate(sql); 
  }


   public long executeLargeUpdate(String sql,
                                   int autoGeneratedKeys)
                            throws SQLException {
         return stmt_.executeLargeUpdate(sql, autoGeneratedKeys); 
   }


   public long executeLargeUpdate(String sql,
                                   int[] columnIndexes) 
                            throws SQLException {
         return stmt_.executeLargeUpdate(sql, columnIndexes); 
   }

   public long executeLargeUpdate(String sql,
                                   String[] columnNames)  throws SQLException {
         return stmt_.executeLargeUpdate(sql, columnNames); 
   }




   JDSQLStatement getJDSQLStatement() {
     return stmt_.getJDSQLStatement(); 
   }
   
   void setConnectionReset(boolean reset) {
     stmt_.setConnectionReset(reset);
   }
  
   JDCursor getCursor() {
     return stmt_.getCursor(); 
   }
   
   AS400JDBCStatementLock getInternalLock() {
     return stmt_.getInternalLock(); 
   }

   
   int getInternalResultSetHoldability() {
     return stmt_.getInternalResultSetHoldability(); 
   }

   boolean isQueryRunning() {
     return stmt_.isQueryRunning();  
   }

 int getInternalQueryTimeout() {

   return stmt_.getInternalQueryTimeout();

 }
   
  
  
  //
  // Start of prepared statement only methods 
  // 
  
  public ResultSet executeQuery() throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        AS400JDBCResultSet rs = (AS400JDBCResultSet) stmt_.executeQuery();
        if (rs != null) { 
           rs.setStatement(this);
        }
        return rs; 
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying          
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */

  }

  public int executeUpdate() throws SQLException {
    
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      
      try {
        return stmt_.executeUpdate();
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */
  }

  public void setNull(int parameterIndex, int sqlType) throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        stmt_.setNull(parameterIndex, sqlType);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */

  }

  public void setBoolean(int parameterIndex, boolean x) throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        stmt_.setBoolean(parameterIndex, x);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */

  }

  public void setByte(int parameterIndex, byte x) throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        stmt_.setByte(parameterIndex, x);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */

  }

  public void setShort(int parameterIndex, short x) throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        stmt_.setShort(parameterIndex, x);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */

  }

  public void setInt(int parameterIndex, int x) throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        stmt_.setInt(parameterIndex, x);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */

  }

  public void setLong(int parameterIndex, long x) throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        stmt_.setLong(parameterIndex, x);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */
    

  }

  public void setFloat(int parameterIndex, float x) throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        stmt_.setFloat(parameterIndex, x);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */

  }

  public void setDouble(int parameterIndex, double x) throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        stmt_.setDouble(parameterIndex, x);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */

  }

  public void setBigDecimal(int parameterIndex, BigDecimal x)
      throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        stmt_.setBigDecimal(parameterIndex, x);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */

  }

  public void setString(int parameterIndex, String x) throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        stmt_.setString(parameterIndex, x);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */

  }

  public void setBytes(int parameterIndex, byte[] x) throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        stmt_.setBytes(parameterIndex, x);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */

  }

  public void setDate(int parameterIndex, Date x) throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        stmt_.setDate(parameterIndex, x);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */

  }

  public void setTime(int parameterIndex, Time x) throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        stmt_.setTime(parameterIndex, x);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */

  }

  public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        stmt_.setTimestamp(parameterIndex, x);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */

  }

  public void setAsciiStream(int parameterIndex, InputStream x, int length)
      throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;

    
    while (true) {
      try {
        stmt_.setAsciiStream(parameterIndex, x, length);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */

  }

  public void setUnicodeStream(int parameterIndex, InputStream x, int length)
      throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        stmt_.setUnicodeStream(parameterIndex, x, length);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */

  }

  public void setBinaryStream(int parameterIndex, InputStream stream, int length)
      throws SQLException {
    
    // Validate the length parameter
    if (length < 0)
      JDError.throwSQLException(this, JDError.EXC_BUFFER_LENGTH_INVALID);

    
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    byte[] value = null; 
    if (stream != null) { 
     value = JDUtilities.streamToBytes(stream, length);
    }
    
    while (true) {
      try {
        stmt_.setBytes(parameterIndex, value);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */

  }

  public void clearParameters() throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        stmt_.clearParameters();
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */
  }

  public void setObject(int parameterIndex, Object x, int targetSqlType,
      int scale) throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        stmt_.setObject(parameterIndex, x, targetSqlType, scale);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */

  }

  public void setObject(int parameterIndex, Object x, int targetSqlType)
      throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        stmt_.setObject(parameterIndex, x, targetSqlType);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */

  }

  public void setObject(int parameterIndex, Object x) throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        stmt_.setObject(parameterIndex, x);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */

  }

  public boolean execute() throws SQLException {
    
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      
      try {
        return stmt_.execute();
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */
  }

  public void addBatch() throws SQLException {
    stmt_.addBatch();
  }

  public void setCharacterStream(int parameterIndex, Reader reader, int length)
      throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        stmt_.setCharacterStream(parameterIndex, reader, length);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */
  }

  public void setRef(int parameterIndex, Ref x) throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        stmt_.setRef(parameterIndex, x);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */
  }

  public void setBlob(int parameterIndex, Blob x) throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        stmt_.setBlob(parameterIndex, x);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */

  }

  public void setClob(int parameterIndex, Clob x) throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        stmt_.setClob(parameterIndex, x);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */

  }

  public void setArray(int parameterIndex, Array x) throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        stmt_.setArray(parameterIndex, x);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */

  }

  public ResultSetMetaData getMetaData() throws SQLException {
    return stmt_.getMetaData(); 
  }

  public void setDate(int parameterIndex, Date x, Calendar cal)
      throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        stmt_.setDate(parameterIndex, x, cal);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */

  }

  public void setTime(int parameterIndex, Time x, Calendar cal)
      throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        stmt_.setTime(parameterIndex, x, cal);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */

  }

  public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal)
      throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        stmt_.setTimestamp(parameterIndex, x, cal);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */

  }

  public void setNull(int parameterIndex, int sqlType, String typeName)
      throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        stmt_.setNull(parameterIndex, sqlType, typeName);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */

  }

  public void setURL(int parameterIndex, URL x) throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        stmt_.setURL(parameterIndex, x);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */

  }

  public ParameterMetaData getParameterMetaData() throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        return stmt_.getParameterMetaData();
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */
  }

     
     public void setNClob(int parameterIndex, Reader reader) throws SQLException 
     {
       int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
       while (true) {
         try {
           stmt_.setNClob(parameterIndex, reader); 
           return;
         } catch (AS400JDBCTransientException e) {
           if (connection_.canSeamlessFailover()) {
             retryCount--;
             if (retryCount >= 0) {
               // keep trying in loop
             } else {
               throw e;
             }
           } else {
             throw e;
           }
         }
       } /* retry */
     }

    public void setAsciiStream(int parameterIndex, InputStream stream) throws SQLException {
      int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
      while (true) {
        try {
          stmt_.setAsciiStream(parameterIndex, stream); 
          return;
        } catch (AS400JDBCTransientException e) {
          if (connection_.canSeamlessFailover()) {
            retryCount--;
            if (retryCount >= 0) {
              // keep trying in loop
            } else {
              throw e;
            }
          } else {
            throw e;
          }
        }
      } /* retry */
    }

    public void setAsciiStream(int parameterIndex, InputStream stream, long length)
        throws SQLException {
      int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
      while (true) {
        try {
          stmt_.setAsciiStream(parameterIndex,  stream, length); 
          return;
        } catch (AS400JDBCTransientException e) {
          if (connection_.canSeamlessFailover()) {
            retryCount--;
            if (retryCount >= 0) {
              // keep trying in loop
            } else {
              throw e;
            }
          } else {
            throw e;
          }
        }
      } /* retry */
  
    }

    
    public void setBinaryStream(int parameterIndex, InputStream stream) throws SQLException {
      int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
      byte[] value = null; 
      
      if (stream != null) {
        value = JDUtilities.streamToBytes(stream);
      }
      while (true) {
        try {
          stmt_.setBytes(parameterIndex,  value); 
          return;
        } catch (AS400JDBCTransientException e) {
          if (connection_.canSeamlessFailover()) {
            retryCount--;
            if (retryCount >= 0) {
              // keep trying in loop
            } else {
              throw e;
            }
          } else {
            throw e;
          }
        }
      } /* retry */
    }

    
    public void setBinaryStream(int parameterIndex, InputStream stream, long length)
        throws SQLException {
      // Validate the length parameter
      if (length < 0)
        JDError.throwSQLException(this, JDError.EXC_BUFFER_LENGTH_INVALID);

      int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
      byte[] value = null; 
      if (stream != null) { 
        value = JDUtilities.streamToBytes(stream, (int) length);
      }
      while (true) {
        try {
          stmt_.setBytes(parameterIndex,value); 
          return;
        } catch (AS400JDBCTransientException e) {
          if (connection_.canSeamlessFailover()) {
            retryCount--;
            if (retryCount >= 0) {
              // keep trying in loop
            } else {
              throw e;
            }
          } else {
            throw e;
          }
        }
      } /* retry */
    }

    
    public void setBlob(int parameterIndex, InputStream stream) throws SQLException {
      int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
      byte[] value = null; 
      if (stream != null) { 
        value = JDUtilities.streamToBytes(stream);
        
      }

      while (true) {
        try {
          stmt_.setBytes(parameterIndex,  value); 
          return;
        } catch (AS400JDBCTransientException e) {
          if (connection_.canSeamlessFailover()) {
            retryCount--;
            if (retryCount >= 0) {
              // keep trying in loop
            } else {
              throw e;
            }
          } else {
            throw e;
          }
        }
      } /* retry */
    }

    
    public void setBlob(int parameterIndex, InputStream stream, long length)
        throws SQLException {
      
      // Validate the length parameter
      if (length < 0 || length > Integer.MAX_VALUE)
        JDError.throwSQLException(this, JDError.EXC_BUFFER_LENGTH_INVALID);

      int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
      // In the case of an input stream, we need to save the data for the retry,  
      byte[] value = null; 
      if (stream != null) { 
        
        value = JDUtilities.streamToBytes(stream, (int) length); 
      }

      while (true) {
        try {
          stmt_.setBytes(parameterIndex,  value); 
          return;
        } catch (AS400JDBCTransientException e) {
          if (connection_.canSeamlessFailover()) {
            retryCount--;
            if (retryCount >= 0) {
              // keep trying in loop
            } else {
              throw e;
            }
          } else {
            throw e;
          }
        }
      } /* retry */
      
      
    }

    
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
      int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
      while (true) {
        try {
          stmt_.setCharacterStream(parameterIndex, reader); 
          return;
        } catch (AS400JDBCTransientException e) {
          if (connection_.canSeamlessFailover()) {
            retryCount--;
            if (retryCount >= 0) {
              // keep trying in loop
            } else {
              throw e;
            }
          } else {
            throw e;
          }
        }
      } /* retry */
    }

    
    public void setCharacterStream(int parameterIndex, Reader reader, long length)
        throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
        stmt_.setCharacterStream(parameterIndex,  reader, length);   
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } /* retry */
    }

    
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
      int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
      while (true) {
        try {
          stmt_.setClob(parameterIndex, reader); 
          return;
        } catch (AS400JDBCTransientException e) {
          if (connection_.canSeamlessFailover()) {
            retryCount--;
            if (retryCount >= 0) {
              // keep trying in loop
            } else {
              throw e;
            }
          } else {
            throw e;
          }
        }
      } /* retry */
      
    }

    
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
      int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
      while (true) {
        try {
          stmt_.setClob(parameterIndex, reader, length); 
          return;
        } catch (AS400JDBCTransientException e) {
          if (connection_.canSeamlessFailover()) {
            retryCount--;
            if (retryCount >= 0) {
              // keep trying in loop
            } else {
              throw e;
            }
          } else {
            throw e;
          }
        }
      } /* retry */
    }

    
    public void setNCharacterStream(int parameterIndex, Reader reader) throws SQLException {
      int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
      while (true) {
        try {
          stmt_.setNCharacterStream(parameterIndex,  reader); 
          return;
        } catch (AS400JDBCTransientException e) {
          if (connection_.canSeamlessFailover()) {
            retryCount--;
            if (retryCount >= 0) {
              // keep trying in loop
            } else {
              throw e;
            }
          } else {
            throw e;
          }
        }
      } /* retry */
    }

    
    public void setNCharacterStream(int parameterIndex, Reader reader, long length)
        throws SQLException {
int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
while (true) {
  try {
    stmt_.setNCharacterStream(parameterIndex,  reader, length); 
    return;
  } catch (AS400JDBCTransientException e) {
    if (connection_.canSeamlessFailover()) {
      retryCount--;
      if (retryCount >= 0) {
        // keep trying in loop
      } else {
        throw e;
      }
    } else {
      throw e;
    }
  }
} /* retry */
    }

    

    
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
      int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
      while (true) {
        try {
          stmt_.setNClob(parameterIndex,  reader, length); 
          return;
        } catch (AS400JDBCTransientException e) {
          if (connection_.canSeamlessFailover()) {
            retryCount--;
            if (retryCount >= 0) {
              // keep trying in loop
            } else {
              throw e;
            }
          } else {
            throw e;
          }
        }
      } /* retry */
    }

    
    public void setNString(int parameterIndex, String x) throws SQLException {
      int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
      while (true) {
        try {
          stmt_.setNString(parameterIndex, x); 
          return;
        } catch (AS400JDBCTransientException e) {
          if (connection_.canSeamlessFailover()) {
            retryCount--;
            if (retryCount >= 0) {
              // keep trying in loop
            } else {
              throw e;
            }
          } else {
            throw e;
          }
        }
      } /* retry */
    }

    public void setDB2Default(int parameterIndex) throws SQLException {
      int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
      while (true) {
        try {
          stmt_.setDB2Default(parameterIndex); 
          return;
        } catch (AS400JDBCTransientException e) {
          if (connection_.canSeamlessFailover()) {
            retryCount--;
            if (retryCount >= 0) {
              // keep trying in loop
            } else {
              throw e;
            }
          } else {
            throw e;
          }
        }
      } // retry 
    }

    public void setDBDefault(int parameterIndex) throws SQLException {
      int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
      while (true) {
        try {
          stmt_.setDBDefault(parameterIndex); 
          return;
        } catch (AS400JDBCTransientException e) {
          if (connection_.canSeamlessFailover()) {
            retryCount--;
            if (retryCount >= 0) {
              // keep trying in loop
            } else {
              throw e;
            }
          } else {
            throw e;
          }
        }
      } // retry 
      
    }

    public void setDB2Unassigned(int parameterIndex) throws SQLException {
      int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
      while (true) {
        try {
          stmt_.setDB2Unassigned(parameterIndex);
          return;
        } catch (AS400JDBCTransientException e) {
          if (connection_.canSeamlessFailover()) {
            retryCount--;
            if (retryCount >= 0) {
              // keep trying in loop
            } else {
              throw e;
            }
          } else {
            throw e;
          }
        }
      } // retry 
      
      
    }

    public void setDBUnassigned(int parameterIndex) throws SQLException {
      int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
      while (true) {
        try {
          stmt_.setDBUnassigned(parameterIndex);
          return;
        } catch (AS400JDBCTransientException e) {
          if (connection_.canSeamlessFailover()) {
            retryCount--;
            if (retryCount >= 0) {
              // keep trying in loop
            } else {
              throw e;
            }
          } else {
            throw e;
          }
        }
      } // retry 
      
    }

    public String getDB2ParameterName(int parm) throws SQLException {
      int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
      while (true) {
        try {
          return stmt_.getDB2ParameterName(parm);
        } catch (AS400JDBCTransientException e) {
          if (connection_.canSeamlessFailover()) {
            retryCount--;
            if (retryCount >= 0) {
              // keep trying in loop
            } else {
              throw e;
            }
          } else {
            throw e;
          }
        }
      } // retry 
      
    }


  
    
    public  void setObject(int parameterIndex,
        Object x,
/* ifdef JDBC42        
        SQLType  
endif*/ 
/* ifndef JDBC42 */
Object
/* endif */
        targetSqlType,
        int scaleOrLength)
 throws SQLException  {
      int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
      while (true) {
        try {
          stmt_.setObject(parameterIndex,x,targetSqlType,scaleOrLength); 
          return;
        } catch (AS400JDBCTransientException e) {
          if (connection_.canSeamlessFailover()) {
            retryCount--;
            if (retryCount >= 0) {
              // keep trying in loop
            } else {
              throw e;
            }
          } else {
            throw e;
          }
        }
      } /* retry */
    }
  

    public void setObject(int parameterIndex,
        Object x,
        /* ifdef JDBC42        
        SQLType  
  endif*/ 
  /* ifndef JDBC42 */
  Object
  /* endif */
        targetSqlType)
 throws SQLException {
      int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
      while (true) {
        try {
          stmt_.setObject(parameterIndex,  x, targetSqlType); 
          return;
        } catch (AS400JDBCTransientException e) {
          if (connection_.canSeamlessFailover()) {
            retryCount--;
            if (retryCount >= 0) {
              // keep trying in loop
            } else {
              throw e;
            }
          } else {
            throw e;
          }
        }
      } /* retry */
    }
  
    
    

    public long executeLargeUpdate() throws SQLException {
      return stmt_.executeLargeUpdate(); 
    }

    int findParameterIndex(String s) throws SQLException {
      int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
      while (true) {
        try {
          return stmt_.findParameterIndex(s); 
        } catch (AS400JDBCTransientException e) {
          if (connection_.canSeamlessFailover()) {
            retryCount--;
            if (retryCount >= 0) {
              // keep trying in loop
            } else {
              throw e;
            }
          } else {
            throw e;
          }
        }
      } /* retry */

    }

    int getParameterCcsid(int p) throws SQLException {
      return stmt_.getParameterCcsid(p); 
      
    }

    String getParameterClassName(int p) throws SQLException {
      return stmt_.getParameterClassName(p); 
      
    }

    int getParameterCount() throws SQLException {
      return stmt_.getParameterCount();
    }

    int getParameterMode(int param) throws SQLException {
      return stmt_.getParameterMode(param); 
    }

    int getParameterType(int param) throws SQLException {
      return stmt_.getParameterType(param); 
    }

    String getParameterTypeName(int param) throws SQLException {
      return stmt_.getParameterTypeName(param); 
    }

    int getPrecision(int param) throws SQLException {
      return stmt_.getPrecision(param); 
    }

    JDServerRow getResultRow() {
      return stmt_.getResultRow(); 
    }

    int getScale(int param) throws SQLException {
      return stmt_.getScale(param); 
    }

    int isNullable(int param) throws SQLException {
      return stmt_.isNullable(param); 
    }

    boolean isSigned(int param) throws SQLException {
      return stmt_.isSigned(param); 
    }

    void setSaveParameterValues(boolean saveParameterValues) {
      stmt_.setSaveParameterValues(saveParameterValues); 
      
    }

    

    
/* ifdef JDBC40


    public void setNClob(int parameterIndex, NClob clob) throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
      stmt_.setNClob(parameterIndex,  clob);
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } // retry 
    }

    
    
    public void setSQLXML(int parameterIndex, SQLXML xml) throws SQLException {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
      stmt_.setSQLXML(parameterIndex, xml); 
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } // retry 
    }

    
    
    public void setRowId(int parameterIndex, RowId x) throws SQLException
    {
    int retryCount = AS400JDBCConnectionRedirect.SEAMLESS_RETRY_COUNT;
    while (true) {
      try {
      stmt_.setRowId(parameterIndex, x); 
        return;
      } catch (AS400JDBCTransientException e) {
        if (connection_.canSeamlessFailover()) {
          retryCount--;
          if (retryCount >= 0) {
            // keep trying in loop
          } else {
            throw e;
          }
        } else {
          throw e;
        }
      }
    } // retry 
     } 

 
endif */

}
