/*
 * Decompiled with CFR 0.152.
 */
package net.sf.m2javafxc.javafxc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import net.sf.m2javafxc.javafxc.IsolatedClassLoader;
import org.codehaus.plexus.compiler.AbstractCompiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerError;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class JavafxcCompiler
extends AbstractCompiler {
    public static final String FORK_EXECUTABLE_NAME = "javafxc";
    public static final String FORK_EXECUTABLE_NAME_FROM_JFX_HOME = "bin/javafxc";
    public static final String JAVAFXC_JAR_LOCATION = "lib/javafxc.jar";
    public static final String JFX_COMPILER_CLASS = "com.sun.tools.javafx.Main";
    public static final String JFX_HOME_VARIABLE_NAME = "JFX_HOME";
    private static final String WARNING_PREFIX = "warning: ";
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$io$PrintWriter;
    static /* synthetic */ Class class$net$sf$m2javafxc$javafxc$JavafxcCompiler;

    public JavafxcCompiler() {
        super(CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE, ".fx", ".class", null);
    }

    public List compile(CompilerConfiguration config) throws CompilerException {
        List messages;
        String[] sourceFiles;
        File destinationDir = new File(config.getOutputLocation());
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        if ((sourceFiles = AbstractCompiler.getSourceFiles((CompilerConfiguration)config)).length == 0) {
            return Collections.EMPTY_LIST;
        }
        this.getLogger().info("Compiling " + sourceFiles.length + " " + "source file" + (sourceFiles.length == 1 ? "" : "s") + " to " + (destinationDir == null ? "NULL" : destinationDir.getAbsolutePath()));
        JavafxcArguments a = JavafxcCompiler.buildCompilerArguments(config, sourceFiles);
        String[] args = a.arguments;
        if (config.isFork()) {
            String executable = config.getExecutable();
            if (StringUtils.isEmpty((String)executable)) {
                executable = FORK_EXECUTABLE_NAME;
                if (a.useJFXHome) {
                    String jfxHome = a.jfxHome;
                    if (jfxHome == null) {
                        jfxHome = System.getenv(JFX_HOME_VARIABLE_NAME);
                    }
                    executable = new File(new File(jfxHome), FORK_EXECUTABLE_NAME_FROM_JFX_HOME).getAbsolutePath();
                }
            }
            messages = this.compileOutOfProcess(config, executable, args);
        } else {
            messages = this.compileInProcess(args, a.useJFXHome, a.jfxHome);
        }
        return messages;
    }

    public String[] createCommandLine(CompilerConfiguration config) throws CompilerException {
        return JavafxcCompiler.buildCompilerArguments((CompilerConfiguration)config, (String[])AbstractCompiler.getSourceFiles((CompilerConfiguration)config)).arguments;
    }

    private static JavafxcArguments buildCompilerArguments(CompilerConfiguration config, String[] sourceFiles) {
        List sourceLocations;
        ArrayList<String> args = new ArrayList<String>();
        JavafxcArguments result = new JavafxcArguments();
        File destinationDir = new File(config.getOutputLocation());
        args.add("-d");
        args.add(destinationDir.getAbsolutePath());
        List classpathEntries = config.getClasspathEntries();
        if (classpathEntries != null && !classpathEntries.isEmpty()) {
            args.add("-classpath");
            args.add(AbstractCompiler.getPathString((List)classpathEntries));
        }
        if ((sourceLocations = config.getSourceLocations()) != null && !sourceLocations.isEmpty() && sourceFiles.length == 0) {
            args.add("-sourcepath");
            args.add(AbstractCompiler.getPathString((List)sourceLocations));
        }
        for (int i = 0; i < sourceFiles.length; ++i) {
            args.add(sourceFiles[i]);
        }
        if (config.isOptimize()) {
            args.add("-O");
        }
        if (config.isVerbose()) {
            args.add("-verbose");
        }
        if (config.isShowDeprecation()) {
            args.add("-deprecation");
            config.setShowWarnings(true);
        }
        if (!config.isShowWarnings()) {
            args.add("-nowarn");
        }
        if (!StringUtils.isEmpty((String)config.getTargetVersion())) {
            args.add("-target");
            args.add(config.getTargetVersion());
        }
        if (!StringUtils.isEmpty((String)config.getSourceVersion())) {
            args.add("-source");
            args.add(config.getSourceVersion());
        }
        if (!StringUtils.isEmpty((String)config.getSourceEncoding())) {
            args.add("-encoding");
            args.add(config.getSourceEncoding());
        }
        Iterator it = ((HashMap)config.getCustomCompilerArguments()).entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            if (StringUtils.isEmpty((String)key)) continue;
            String value = (String)entry.getValue();
            if (StringUtils.equals((String)key, (String)"-jfxHome")) {
                if (StringUtils.equals((String)value, (String)"true")) {
                    result.jfxHome = null;
                    result.useJFXHome = true;
                    continue;
                }
                if (StringUtils.equals((String)value, (String)"false")) {
                    result.jfxHome = null;
                    result.useJFXHome = false;
                    continue;
                }
                result.jfxHome = value;
                result.useJFXHome = true;
                continue;
            }
            args.add(key);
            if (StringUtils.isEmpty((String)value)) continue;
            args.add(value);
        }
        result.arguments = args.toArray(new String[args.size()]);
        return result;
    }

    List compileOutOfProcess(CompilerConfiguration config, String executable, String[] args) throws CompilerException {
        List messages;
        int returnCode;
        Commandline cli = new Commandline();
        cli.setWorkingDirectory(config.getWorkingDirectory().getAbsolutePath());
        cli.setExecutable(executable);
        try {
            File argumentsFile = this.createFileWithArguments(args);
            cli.addArguments(new String[]{"@" + argumentsFile.getCanonicalPath().replace(File.separatorChar, '/')});
            if (!StringUtils.isEmpty((String)config.getMaxmem())) {
                cli.addArguments(new String[]{"-J-Xmx" + config.getMaxmem()});
            }
            if (!StringUtils.isEmpty((String)config.getMeminitial())) {
                cli.addArguments(new String[]{"-J-Xms" + config.getMeminitial()});
            }
        }
        catch (IOException e) {
            throw new CompilerException("Error creating file with javafxc arguments", (Throwable)e);
        }
        CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        try {
            returnCode = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)err);
            messages = JavafxcCompiler.parseModernStream(new BufferedReader(new StringReader(err.getOutput())));
        }
        catch (CommandLineException e) {
            throw new CompilerException("Error while executing the external compiler.", (Throwable)e);
        }
        catch (IOException e) {
            throw new CompilerException("Error while executing the external compiler.", (Throwable)e);
        }
        if (returnCode != 0 && messages.isEmpty()) {
            if (err.getOutput().length() == 0) {
                throw new CompilerException("Unknown error trying to execute the external compiler: " + AbstractCompiler.EOL + cli.toString());
            }
            messages.add(new CompilerError("Failure executing javafxc,  but could not parse the error:" + AbstractCompiler.EOL + err.getOutput(), true));
        }
        return messages;
    }

    List compileInProcess(String[] args, boolean useJFXHome, String jfxHome) throws CompilerException {
        List messages;
        Integer ok;
        Class c;
        block22: {
            IsolatedClassLoader cl = new IsolatedClassLoader();
            File toolsJar = null;
            if (useJFXHome) {
                this.getLogger().debug("Configured to use jfxHome");
                if (jfxHome == null) {
                    jfxHome = System.getenv(JFX_HOME_VARIABLE_NAME);
                    this.getLogger().debug("jfxHome from $JFX_HOME = " + jfxHome);
                } else {
                    this.getLogger().debug("jfxHome from <jfxHome> = " + jfxHome);
                }
                if (jfxHome != null) {
                    toolsJar = new File(jfxHome, JAVAFXC_JAR_LOCATION);
                }
                if (toolsJar != null && toolsJar.exists()) {
                    try {
                        cl.addURL(toolsJar.toURL());
                    }
                    catch (MalformedURLException e) {
                        throw new CompilerException("Could not convert the file reference to tools.jar to a URL, path to tools.jar: '" + toolsJar.getAbsolutePath() + "'.");
                    }
                }
            }
            try {
                try {
                    if (useJFXHome) {
                        c = cl.loadClass(JFX_COMPILER_CLASS);
                        this.getLogger().debug("com.sun.tools.javafx.Main loaded from isolated class loader");
                        break block22;
                    }
                    c = ((Object)((Object)this)).getClass().getClassLoader().loadClass(JFX_COMPILER_CLASS);
                    this.getLogger().debug("com.sun.tools.javafx.Main loaded from plugin dependencies");
                }
                catch (ClassNotFoundException e) {
                    this.getLogger().debug("We did not find com.sun.tools.javafx.Main in classpath or in specified <jfxHome> last chance in $JFX_HOME");
                    jfxHome = System.getenv(JFX_HOME_VARIABLE_NAME);
                    this.getLogger().debug("last chance from $JFX_HOME = " + jfxHome);
                    if (jfxHome != null) {
                        toolsJar = new File(jfxHome, JAVAFXC_JAR_LOCATION);
                    }
                    if (toolsJar != null && toolsJar.exists()) {
                        try {
                            cl.addURL(toolsJar.toURL());
                        }
                        catch (MalformedURLException e2) {
                            throw new CompilerException("Could not convert the file reference to tools.jar to a URL, path to tools.jar: '" + toolsJar.getAbsolutePath() + "'.");
                        }
                    }
                    c = cl.loadClass(JFX_COMPILER_CLASS);
                    this.getLogger().debug("Last chance was successfull, com.sun.tools.javafx.Main is loaded from " + toolsJar);
                }
            }
            catch (ClassNotFoundException e) {
                String message = "Unable to locate the JavaFXc Compiler in:" + AbstractCompiler.EOL + "  " + toolsJar + " (JFX_HOME)" + AbstractCompiler.EOL + " or in classpath" + AbstractCompiler.EOL + "Please ensure that \"" + JFX_COMPILER_CLASS + "\"" + AbstractCompiler.EOL + "is in your classpath." + AbstractCompiler.EOL + "In most cases you can specify the location of your JavaFX" + AbstractCompiler.EOL + "installation by setting the JFX_HOME environment variable, " + AbstractCompiler.EOL + "or using <jfxHome> compiler argument";
                return Collections.singletonList(new CompilerError(message, true));
            }
        }
        StringWriter out = new StringWriter();
        try {
            Method compile = c.getMethod("compile", array$Ljava$lang$String == null ? (array$Ljava$lang$String = JavafxcCompiler.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, class$java$io$PrintWriter == null ? (class$java$io$PrintWriter = JavafxcCompiler.class$("java.io.PrintWriter")) : class$java$io$PrintWriter);
            ok = (Integer)compile.invoke(null, args, new PrintWriter(out));
            messages = JavafxcCompiler.parseModernStream(new BufferedReader(new StringReader(out.toString())));
        }
        catch (NoSuchMethodException e) {
            throw new CompilerException("Error while executing the compiler.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new CompilerException("Error while executing the compiler.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new CompilerException("Error while executing the compiler.", (Throwable)e);
        }
        catch (IOException e) {
            throw new CompilerException("Error while executing the compiler.", (Throwable)e);
        }
        if (ok != 0 && messages.isEmpty()) {
            messages.add(new CompilerError("Failure executing javafxc, but could not parse the error:" + AbstractCompiler.EOL + out.toString(), true));
        }
        return messages;
    }

    protected static List parseModernStream(BufferedReader input) throws IOException {
        ArrayList<CompilerError> errors = new ArrayList<CompilerError>();
        while (true) {
            String line;
            StringBuffer buffer = new StringBuffer();
            do {
                if ((line = input.readLine()) == null) {
                    return errors;
                }
                if (buffer.length() == 0 && line.startsWith("error: ")) {
                    errors.add(new CompilerError(line, true));
                    continue;
                }
                if (buffer.length() == 0 && line.startsWith("Note: ")) continue;
                buffer.append(line);
                buffer.append(AbstractCompiler.EOL);
            } while (!line.endsWith("^"));
            errors.add(JavafxcCompiler.parseModernError(buffer.toString()));
        }
    }

    public static CompilerError parseModernError(String error) {
        StringTokenizer tokens = new StringTokenizer(error, ":");
        boolean isError = true;
        try {
            int endcolumn;
            String file = tokens.nextToken();
            if (file.length() == 1) {
                file = file + ":" + tokens.nextToken();
            }
            int line = Integer.parseInt(tokens.nextToken());
            StringBuffer msgBuffer = new StringBuffer();
            String msg = tokens.nextToken(AbstractCompiler.EOL).substring(2);
            boolean bl = isError = !msg.startsWith(WARNING_PREFIX);
            if (!isError) {
                msg = msg.substring(WARNING_PREFIX.length());
            }
            msgBuffer.append(msg);
            msgBuffer.append(AbstractCompiler.EOL);
            String context = tokens.nextToken(AbstractCompiler.EOL);
            String pointer = tokens.nextToken(AbstractCompiler.EOL);
            if (tokens.hasMoreTokens()) {
                msgBuffer.append(context);
                msgBuffer.append(AbstractCompiler.EOL);
                msgBuffer.append(pointer);
                msgBuffer.append(AbstractCompiler.EOL);
                context = tokens.nextToken(AbstractCompiler.EOL);
                try {
                    pointer = tokens.nextToken(AbstractCompiler.EOL);
                }
                catch (NoSuchElementException e) {
                    pointer = context;
                    context = null;
                }
            }
            String message = msgBuffer.toString();
            int startcolumn = pointer.indexOf("^");
            int n = endcolumn = context == null ? startcolumn : context.indexOf(" ", startcolumn);
            if (endcolumn == -1) {
                endcolumn = context.length();
            }
            return new CompilerError(file, isError, line, startcolumn, line, endcolumn, message);
        }
        catch (NoSuchElementException e) {
            return new CompilerError("no more tokens - could not parse error message: " + error, isError);
        }
        catch (NumberFormatException e) {
            return new CompilerError("could not parse error message: " + error, isError);
        }
        catch (Exception e) {
            return new CompilerError("could not parse error message: " + error, isError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createFileWithArguments(String[] args) throws IOException {
        PrintWriter writer = null;
        try {
            File tempFile = File.createTempFile((class$net$sf$m2javafxc$javafxc$JavafxcCompiler == null ? (class$net$sf$m2javafxc$javafxc$JavafxcCompiler = JavafxcCompiler.class$("net.sf.m2javafxc.javafxc.JavafxcCompiler")) : class$net$sf$m2javafxc$javafxc$JavafxcCompiler).getName(), "arguments");
            tempFile.deleteOnExit();
            writer = new PrintWriter(new FileWriter(tempFile));
            for (int i = 0; i < args.length; ++i) {
                String argValue = args[i].replace(File.separatorChar, '/');
                writer.write("\"" + argValue + "\"");
                writer.write(AbstractCompiler.EOL);
            }
            writer.flush();
            File file = tempFile;
            return file;
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class JavafxcArguments {
        public String[] arguments;
        public boolean useJFXHome = true;
        public String jfxHome = null;

        private JavafxcArguments() {
        }
    }
}

