/*
 * Decompiled with CFR 0.152.
 */
package net.sf.minuteProject.architecture.filter.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.minuteProject.architecture.filter.data.ClauseCriterion;

public class InCriterion
extends ClauseCriterion {
    private List<String> values;
    private String field;
    private boolean isQuoted;

    public InCriterion(String field, List<String> values, boolean isQuoted) {
        this.field = field;
        this.values = values;
        this.isQuoted = isQuoted;
    }

    @Override
    public String getExpression() {
        StringBuffer sb = new StringBuffer();
        List<String> values = this.getValues();
        if (!values.isEmpty()) {
            sb.append(" " + this.field + " in (");
            Iterator<String> iter = values.iterator();
            while (iter.hasNext()) {
                String value = iter.next();
                if (!this.isQuoted) {
                    sb.append(value);
                } else {
                    sb.append("'" + value + "'");
                }
                if (!iter.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(")");
            return sb.toString();
        }
        return "";
    }

    private List<String> getValues() {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        return this.values;
    }
}

